/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.util.terms;

import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.entity.IndividualVariable;
import com.clarkparsia.pellet.api.term.entity.LiteralVariable;
import com.clarkparsia.pellet.api.term.entity.Variable;
import com.google.common.base.Function;

public class VarGenerator<V extends Variable> {
    private final String prefix;
    private final Function<String, V> varCreator;
    private int index = 0;
    private V var;

    public VarGenerator(String prefix, Function<String, V> varCreator) {
        this.prefix = prefix;
        this.varCreator = varCreator;
    }

    public V current() {
        return this.var;
    }

    public V next() {
        ++this.index;
        this.var = (Variable)this.varCreator.apply((Object)(this.prefix + this.index));
        return this.current();
    }

    public V reset() {
        this.index = 0;
        return this.next();
    }

    public static VarGenerator<IndividualVariable> ind() {
        return VarGenerator.ind("x");
    }

    public static VarGenerator<IndividualVariable> ind(String prefix) {
        return new VarGenerator<IndividualVariable>(prefix, new Function<String, IndividualVariable>(){

            public IndividualVariable apply(String name) {
                return TermFactory.individualVariable(name);
            }
        });
    }

    public static VarGenerator<LiteralVariable> lit() {
        return VarGenerator.lit("x");
    }

    public static VarGenerator<LiteralVariable> lit(String prefix) {
        return new VarGenerator<LiteralVariable>(prefix, new Function<String, LiteralVariable>(){

            public LiteralVariable apply(String name) {
                return TermFactory.literalVariable(name);
            }
        });
    }
}

