/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.util.terms;

import com.clarkparsia.pellet.api.term.Term;
import com.clarkparsia.pellet.api.term.visitor.RecursiveTermVisitorVoid;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class TermCollector
extends RecursiveTermVisitorVoid {
    private final Predicate<? super Term> predicate;
    protected final Set<Term> result = new LinkedHashSet<Term>();

    public static <T extends Term> Set<T> collect(Term term, Class<T> classType) {
        return TermCollector.collect((Iterable<? extends Term>)ImmutableSet.of((Object)term), classType);
    }

    public static <T extends Term> Set<T> collect(Iterable<? extends Term> terms, Class<T> classType) {
        return TermCollector.collect(terms, (Predicate<? super Term>)Predicates.instanceOf(classType));
    }

    public static Set<? extends Term> collect(Term term, Predicate<? super Term> predicate) {
        return TermCollector.collect((Iterable<? extends Term>)ImmutableSet.of((Object)term), predicate);
    }

    public static Set<? extends Term> collect(Iterable<? extends Term> terms, Predicate<? super Term> predicate) {
        TermCollector collector = new TermCollector(predicate);
        for (Term term : terms) {
            collector.collectFrom(term);
        }
        return collector.getResult();
    }

    public TermCollector(Predicate<? super Term> p) {
        this.predicate = p;
    }

    @Override
    protected void defaultVisit(Term term) {
        if (this.predicate.apply((Object)term)) {
            this.result.add(term);
        }
    }

    public void reset() {
        this.result.clear();
    }

    public Set<? extends Term> getResult() {
        return this.result;
    }

    public void collectFrom(Term t) {
        t.accept(this);
    }
}

