/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.util.progress;

import com.clarkparsia.pellet.util.progress.ProgressMonitor;

public abstract class AbstractProgressMonitor
implements ProgressMonitor {
    protected String progressTitle = "";
    protected int progress = 0;
    protected int progressLength = 0;
    protected int progressPercent = -1;
    protected long startTime;
    protected boolean cancelled = false;

    public AbstractProgressMonitor() {
    }

    public AbstractProgressMonitor(int length) {
        this.setProgressLength(length);
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public int getProgressLength() {
        return this.progressLength;
    }

    @Override
    public int getProgressPercent() {
        return this.progressPercent;
    }

    public String getProgressTitle() {
        return this.progressTitle;
    }

    @Override
    public void incrementProgress() {
        this.setProgress(this.progress + 1);
    }

    @Override
    public boolean isCanceled() {
        return this.cancelled;
    }

    protected void resetProgress() {
        this.progress = 0;
        this.progressPercent = -1;
    }

    @Override
    public void setProgress(int progress) {
        this.progress = progress;
        this.updateProgress();
    }

    @Override
    public void setProgressLength(int progressLength) {
        this.progressLength = progressLength;
        this.resetProgress();
    }

    @Override
    public void setProgressTitle(String progressTitle) {
        this.progressTitle = progressTitle;
    }

    @Override
    public void taskFinished() {
        this.setProgress(this.progressLength);
    }

    @Override
    public void taskStarted() {
        this.resetProgress();
        this.startTime = System.currentTimeMillis();
    }

    protected long getElapsedTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    protected abstract void updateProgress();
}

