/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.util.fsm;

import com.clarkparsia.pellet.util.fsm.State;
import com.clarkparsia.pellet.util.fsm.Transition;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class TransitionGraph<T> {
    private State<T> initialState = null;
    private Set<State<T>> allStates = new HashSet<State<T>>();
    private Set<State<T>> finalStates = new HashSet<State<T>>();
    private Set<T> alphabet = new HashSet<T>();

    public int size() {
        return this.allStates.size();
    }

    public State<T> newState() {
        State s = new State();
        this.allStates.add(s);
        return s;
    }

    public Set<T> getAlpahabet() {
        return Collections.unmodifiableSet(this.alphabet);
    }

    public Set<State<T>> getAllStates() {
        return Collections.unmodifiableSet(this.allStates);
    }

    public void setInitialState(State<T> s) {
        this.initialState = s;
    }

    public State<T> getInitialState() {
        return this.initialState;
    }

    public void addFinalState(State<T> s) {
        this.finalStates.add(s);
    }

    public Set<State<T>> getFinalStates() {
        return this.finalStates;
    }

    public State<T> getFinalState() {
        int size = this.finalStates.size();
        if (size == 0) {
            throw new RuntimeException("There are no final states!");
        }
        if (size > 1) {
            throw new RuntimeException("There is more than one final state!");
        }
        return this.finalStates.iterator().next();
    }

    public void addTransition(State<T> begin, T transition, State<T> end) {
        if (transition == null) {
            throw new NullPointerException();
        }
        begin.addTransition(transition, end);
        this.alphabet.add(transition);
    }

    public void addTransition(State<T> begin, State<T> end) {
        begin.addTransition(end);
    }

    public Map<State<T>, State<T>> findTransitions(T transition) {
        HashMap result = Maps.newHashMap();
        for (State<T> s1 : this.allStates) {
            State<T> s2 = s1.move(transition);
            if (s2 == null) continue;
            result.put(s1, s2);
        }
        return result;
    }

    public boolean isInitial(State<T> st) {
        return this.initialState.equals(st);
    }

    public boolean isFinal(State<T> st) {
        return this.finalStates.contains(st);
    }

    public boolean isAnyFinal(Set<State<T>> ss) {
        for (State<T> st : ss) {
            if (!this.finalStates.contains(st)) continue;
            return true;
        }
        return false;
    }

    public TransitionGraph<T> epsilon() {
        TransitionGraph<T> tg = new TransitionGraph<T>();
        State<T> s = tg.newState();
        State<T> f = tg.newState();
        s.addTransition(f);
        tg.initialState = s;
        tg.finalStates.add(f);
        return tg;
    }

    public static <T> TransitionGraph<T> symbol(T transition) {
        TransitionGraph<T> tg = new TransitionGraph<T>();
        State<T> s = tg.newState();
        State<T> f = tg.newState();
        s.addTransition(transition, f);
        tg.initialState = s;
        tg.finalStates.add(f);
        tg.alphabet.add(transition);
        return tg;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[Transition Graph\n");
        for (State<T> st : this.allStates) {
            buf.append(st.getName()).append(": ");
            Iterator<Transition<T>> i = st.getTransitions().iterator();
            while (i.hasNext()) {
                buf.append(i.next());
                if (!i.hasNext()) continue;
                buf.append(", ");
            }
            buf.append("\n");
        }
        buf.append("initial state: ");
        buf.append(this.initialState.getName());
        buf.append("\n");
        buf.append("final states: ");
        buf.append(this.finalStates);
        buf.append("\n");
        buf.append("alphabet: ");
        buf.append(this.alphabet);
        buf.append("\n");
        buf.append("]\n");
        return buf.toString();
    }

    public TransitionGraph<T> renumber() {
        HashSet processed = new HashSet();
        LinkedList workList = new LinkedList();
        int val = 0;
        workList.addFirst(this.initialState);
        while (workList.size() > 0) {
            State s = (State)workList.removeFirst();
            s.setName(val++);
            processed.add(s);
            for (Transition e : s.getTransitions()) {
                if (!processed.add(e.getTo())) continue;
                workList.addLast(e.getTo());
            }
        }
        return this;
    }

    public boolean accepts(List<T> str) {
        State<T> s = this.initialState;
        for (T ch : str) {
            if ((s = s.move(ch)) != null) continue;
            return false;
        }
        return this.finalStates.contains(s);
    }

    public TransitionGraph<T> choice(TransitionGraph<T> t) {
        State<T> s = this.newState();
        State<T> f = this.newState();
        this.allStates.addAll(t.allStates);
        this.finalStates.addAll(t.finalStates);
        s.addTransition(this.initialState);
        s.addTransition(t.initialState);
        this.initialState = s;
        for (State<T> fs : this.finalStates) {
            fs.addTransition(f);
        }
        this.finalStates.clear();
        this.finalStates.add(f);
        this.alphabet.addAll(t.alphabet);
        return this;
    }

    public TransitionGraph<T> concat(TransitionGraph<T> t) {
        State<T> s = this.newState();
        State<T> f = this.newState();
        this.allStates.addAll(t.allStates);
        s.addTransition(this.initialState);
        this.initialState = s;
        for (State<T> fs : this.finalStates) {
            fs.addTransition(t.initialState);
        }
        for (State<T> tfs : t.finalStates) {
            tfs.addTransition(f);
        }
        this.finalStates.clear();
        this.finalStates.add(f);
        this.alphabet.addAll(t.alphabet);
        return this;
    }

    public TransitionGraph<T> closure() {
        State<T> s = this.newState();
        State<T> f = this.newState();
        for (State<T> fs : this.finalStates) {
            fs.addTransition(this.initialState);
            fs.addTransition(f);
        }
        this.finalStates.clear();
        this.finalStates.add(f);
        s.addTransition(this.initialState);
        s.addTransition(f);
        this.initialState = s;
        return this;
    }

    public TransitionGraph<T> insert(TransitionGraph<T> tg, State<T> i, State<T> f) {
        this.alphabet.addAll(tg.alphabet);
        HashMap<State<T>, State<T>> newStates = new HashMap<State<T>, State<T>>();
        newStates.put(tg.getInitialState(), i);
        for (State<T> fs : tg.getFinalStates()) {
            newStates.put(fs, f);
        }
        for (State<T> s1 : tg.allStates) {
            State<T> n1 = (State<T>)newStates.get(s1);
            if (n1 == null) {
                n1 = this.newState();
                newStates.put(s1, n1);
            }
            for (Transition<T> t : s1.getTransitions()) {
                State<T> s2 = t.getTo();
                State<T> n2 = (State<T>)newStates.get(s2);
                if (n2 == null) {
                    n2 = this.newState();
                    newStates.put(s2, n2);
                }
                if (t.isEpsilon()) {
                    n1.addTransition(n2);
                    continue;
                }
                n1.addTransition(t.getName(), n2);
            }
        }
        return this;
    }

    public Set<State<T>> move(Set<State<T>> stateSet, T c) {
        HashSet<State<T>> result = new HashSet<State<T>>();
        for (State<T> st : stateSet) {
            for (Transition<T> e : st.getTransitions()) {
                if (!e.hasName(c)) continue;
                result.add(e.getTo());
            }
        }
        return result;
    }

    public Set<State<T>> epsilonClosure(State<T> s, Set<State<T>> result) {
        result.add(s);
        for (Transition<T> e : s.getTransitions()) {
            if (!e.isEpsilon() || result.contains(e.getTo())) continue;
            result = this.epsilonClosure(e.getTo(), result);
        }
        return result;
    }

    public Set<State<T>> epsilonClosure(Set<State<T>> stateSet) {
        Set<State<T>> result = new HashSet<State<T>>();
        for (State<T> s : stateSet) {
            result = this.epsilonClosure(s, result);
        }
        return result;
    }

    public boolean isDeterministic() {
        if (!this.allStates.contains(this.initialState)) {
            throw new IllegalStateException("Initial state not found");
        }
        for (State<T> s : this.allStates) {
            HashSet<T> seenSymbols = new HashSet<T>();
            for (Transition<T> t : s.getTransitions()) {
                T symbol = t.getName();
                if (!t.isEpsilon() && seenSymbols.add(symbol)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isConnected() {
        HashSet visited = new HashSet();
        Stack stack = new Stack();
        stack.push(this.initialState);
        visited.add(this.initialState);
        while (!stack.isEmpty()) {
            State state = (State)stack.pop();
            if (!this.allStates.contains(state)) {
                return false;
            }
            for (Transition t : state.getTransitions()) {
                if (!visited.add(t.getTo())) continue;
                stack.push(t.getTo());
            }
        }
        return visited.size() == this.allStates.size();
    }

    public TransitionGraph<T> determinize() {
        HashMap<Set, State> dStates = new HashMap<Set, State>();
        State s = new State();
        Set ss = this.epsilonClosure(this.initialState, new HashSet<State<T>>());
        this.initialState = s;
        HashSet<State> processList = new HashSet<State>();
        processList.add(s);
        dStates.put(ss, s);
        this.initialState = s;
        boolean moreToProcess = true;
        while (moreToProcess) {
            State u = null;
            Set<State<T>> U = null;
            moreToProcess = false;
            for (Map.Entry entry : dStates.entrySet()) {
                s = (State)entry.getValue();
                ss = (Set)entry.getKey();
                moreToProcess = processList.contains(s);
                if (!moreToProcess) continue;
                break;
            }
            if (!moreToProcess) continue;
            for (Map.Entry a : this.alphabet) {
                U = this.epsilonClosure(this.move(ss, a));
                if (U.size() == 0) continue;
                u = (State)dStates.get(U);
                if (u == null) {
                    u = new State();
                    processList.add(u);
                    dStates.put(U, u);
                } else if (u.equals(s)) {
                    u = s;
                }
                s.addTransition(a, u);
            }
            processList.remove(s);
            dStates.put(ss, s);
        }
        HashSet<State<T>> acceptingStates = new HashSet<State<T>>();
        this.allStates.clear();
        for (Map.Entry entry : dStates.entrySet()) {
            s = (State)entry.getValue();
            ss = (Set)entry.getKey();
            this.allStates.add(s);
            if (!this.isAnyFinal(ss)) continue;
            acceptingStates.add(s);
        }
        this.finalStates.clear();
        this.finalStates = acceptingStates;
        return this;
    }

    public void setPartition(Set<State<T>> stateSet, int num, Map<State<T>, Integer> partitions) {
        for (State<T> s : stateSet) {
            partitions.put(s, num);
        }
    }

    public TransitionGraph<T> minimize() {
        State t;
        ArrayList partitions = new ArrayList(this.allStates.size());
        HashMap<State<T>, Integer> partitionNumbers = new HashMap<State<T>, Integer>();
        HashMap<State, State> partitionRep = new HashMap<State, State>();
        HashSet<State<T>> firstPartition = new HashSet<State<T>>(this.finalStates);
        partitions.add(firstPartition);
        this.setPartition(firstPartition, 0, partitionNumbers);
        if (firstPartition.size() < this.allStates.size()) {
            HashSet<State<T>> secondPartition = new HashSet<State<T>>(this.allStates);
            secondPartition.removeAll(this.finalStates);
            partitions.add(secondPartition);
            this.setPartition(secondPartition, 1, partitionNumbers);
        }
        for (int p = 0; p < partitions.size(); ++p) {
            Iterator i = ((Set)partitions.get(p)).iterator();
            State s = (State)i.next();
            HashSet<State> newPartition = null;
            block1: while (i.hasNext()) {
                t = (State)i.next();
                for (T a : this.alphabet) {
                    if (this.isEquivalentState(s.move(a), t.move(a), partitionNumbers)) continue;
                    if (newPartition == null) {
                        newPartition = new HashSet<State>();
                        partitions.add(newPartition);
                    }
                    i.remove();
                    newPartition.add(t);
                    partitionNumbers.put(t, partitions.size() - 1);
                    continue block1;
                }
            }
            if (newPartition == null) continue;
            p = -1;
        }
        int startPartition = (Integer)partitionNumbers.get(this.initialState);
        for (int p = 0; p < partitions.size(); ++p) {
            Iterator i = ((Set)partitions.get(p)).iterator();
            State s = (State)i.next();
            partitionRep.put(s, s);
            if (p == startPartition) {
                this.initialState = s;
            }
            while (i.hasNext()) {
                t = (State)i.next();
                this.allStates.remove(t);
                this.finalStates.remove(t);
                partitionRep.put(t, s);
            }
        }
        for (State<T> t2 : this.allStates) {
            for (Transition<T> edge : t2.getTransitions()) {
                edge.setTo((State)partitionRep.get(edge.getTo()));
            }
        }
        return this;
    }

    protected boolean isEquivalentState(State<T> s1, State<T> s2, Map<State<T>, Integer> partitionNum) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return partitionNum.get(s1).equals(partitionNum.get(s2));
    }
}

