/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.util.fsm;

import com.clarkparsia.pellet.util.fsm.Transition;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;

public class State<T> {
    private static int next_unused_name = 0;
    private int name = next_unused_name++;
    private Multimap<T, Transition<T>> transitions = HashMultimap.create();

    public void addTransition(T symbol, State<T> s) {
        if (symbol == null || s == null) {
            throw new NullPointerException();
        }
        Transition<T> t = new Transition<T>(symbol, s);
        this.transitions.put(symbol, t);
    }

    public void addTransition(State<T> s) {
        if (s == null) {
            throw new NullPointerException();
        }
        Transition<T> t = new Transition<T>(s);
        this.transitions.put(null, t);
    }

    public boolean removeTransition(Transition<T> t) {
        return this.transitions.remove(t.getName(), t);
    }

    public Collection<Transition<T>> getTransitions() {
        return this.transitions.values();
    }

    public State<T> move(T symbol) {
        Collection t = this.transitions.get(symbol);
        return t.isEmpty() ? null : ((Transition)t.iterator().next()).getTo();
    }

    public int getName() {
        return this.name;
    }

    public void setName(int i) {
        this.name = i;
    }

    public String toString() {
        return String.valueOf(this.name);
    }
}

