/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.util.collections;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class SetUtils {
    public static <T> Set<T> add(T o, Set<T> set) {
        int size = set.size();
        if (size == 0) {
            set = ImmutableSet.of(o);
        } else if (size == 1) {
            Object existing = set.iterator().next();
            if (!existing.equals(o)) {
                set = Sets.newHashSetWithExpectedSize((int)2);
                set.add(existing);
                set.add(o);
            }
        } else {
            set.add(o);
        }
        return set;
    }

    public static <T> Set<T> remove(Object o, Set<T> set) {
        int size = set.size();
        if (size != 0) {
            if (size == 1) {
                if (set.contains(o)) {
                    set = ImmutableSet.of();
                }
            } else {
                set.remove(o);
            }
        }
        return set;
    }

    public static boolean subset(Set<?> sub, Set<?> sup) {
        return sub.size() <= sup.size() && sup.containsAll(sub);
    }

    public static <T> boolean equals(Set<T> s1, Set<T> s2) {
        return s1.size() == s2.size() && s1.containsAll(s2);
    }

    public static <T> Set<T> difference(Collection<T> c1, Collection<? extends Object> c2) {
        HashSet set = Sets.newHashSet(c1);
        if (c2 instanceof Set) {
            set.removeAll(c2);
        } else {
            for (Object object : c2) {
                set.remove(object);
            }
        }
        return set;
    }

    public static <T> Set<T> union(Collection<? extends T> c1, Collection<? extends T> c2) {
        HashSet result = Sets.newHashSet(c1);
        result.addAll(c2);
        return result;
    }

    public static <T> Set<T> intersection(Collection<? extends T> c1, Collection<? extends T> c2) {
        HashSet set = Sets.newHashSet(c1);
        set.retainAll(c2);
        return set;
    }
}

