/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.util.collections;

import com.clarkparsia.pellet.util.collections.Stack;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayStack<T>
extends ArrayList<T>
implements Stack<T> {
    private static final long serialVersionUID = 7370366962807579336L;

    @Override
    public T element() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return (T)this.get(this.size() - 1);
    }

    @Override
    public T peek() {
        if (this.isEmpty()) {
            return null;
        }
        return (T)this.get(this.size() - 1);
    }

    @Override
    public T pop() {
        if (this.isEmpty()) {
            return null;
        }
        return (T)this.remove(this.size() - 1);
    }

    @Override
    public boolean push(T o) {
        return this.add(o);
    }

    @Override
    public T remove() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return (T)this.remove(this.size() - 1);
    }

    @Override
    public Iterator<T> iterator() {
        return new Itr();
    }

    private class Itr
    implements Iterator<T> {
        int cursor;
        int expectedModCount;

        private Itr() {
            this.cursor = ArrayStack.this.size() - 1;
            this.expectedModCount = ArrayStack.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor >= 0;
        }

        @Override
        public T next() {
            this.checkForComodification();
            try {
                return ArrayStack.this.get(this.cursor--);
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        final void checkForComodification() {
            if (ArrayStack.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

