/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.util.collections;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ArraySet<T>
extends AbstractSet<T>
implements Set<T> {
    private static final ArraySet<Object> EMPTY = new ArraySet(ImmutableList.of());
    private final List<T> data;

    public static <T> ArraySet<T> empty() {
        return EMPTY;
    }

    public static <T> ArraySet<T> immutable(Iterable<T> elements) {
        if (elements instanceof Set) {
            return new ArraySet<T>(Lists.newArrayList((Iterable)((Set)elements)));
        }
        return new ArraySet<T>(Lists.newArrayList((Iterable)Sets.newHashSet(elements)));
    }

    public ArraySet() {
        this(Lists.newArrayList());
    }

    private ArraySet(List<T> data) {
        this.data = data;
    }

    @Override
    public boolean add(T e) {
        return this.data.contains(e) ? false : this.data.add(e);
    }

    @Override
    public Iterator<T> iterator() {
        return this.data.iterator();
    }

    @Override
    public int size() {
        return this.data.size();
    }
}

