/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.util;

import com.clarkparsia.pellet.api.term.Term;
import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.axiom.AnnotationPropertyDomain;
import com.clarkparsia.pellet.api.term.axiom.AnnotationPropertyRange;
import com.clarkparsia.pellet.api.term.axiom.Axiom;
import com.clarkparsia.pellet.api.term.axiom.DataFunctional;
import com.clarkparsia.pellet.api.term.axiom.DataPropertyAssertion;
import com.clarkparsia.pellet.api.term.axiom.DataPropertyDomain;
import com.clarkparsia.pellet.api.term.axiom.DataPropertyRange;
import com.clarkparsia.pellet.api.term.axiom.DatatypeDefinition;
import com.clarkparsia.pellet.api.term.axiom.Declaration;
import com.clarkparsia.pellet.api.term.axiom.DifferentIndividuals;
import com.clarkparsia.pellet.api.term.axiom.DisjointClasses;
import com.clarkparsia.pellet.api.term.axiom.DisjointDataProperties;
import com.clarkparsia.pellet.api.term.axiom.DisjointObjectProperties;
import com.clarkparsia.pellet.api.term.axiom.DisjointUnion;
import com.clarkparsia.pellet.api.term.axiom.EquivalentClasses;
import com.clarkparsia.pellet.api.term.axiom.EquivalentDataProperties;
import com.clarkparsia.pellet.api.term.axiom.EquivalentObjectProperties;
import com.clarkparsia.pellet.api.term.axiom.InverseProperties;
import com.clarkparsia.pellet.api.term.axiom.Irreflexive;
import com.clarkparsia.pellet.api.term.axiom.NegativeDataPropertyAssertion;
import com.clarkparsia.pellet.api.term.axiom.NegativeObjectPropertyAssertion;
import com.clarkparsia.pellet.api.term.axiom.ObjectFunctional;
import com.clarkparsia.pellet.api.term.axiom.ObjectInverseFunctional;
import com.clarkparsia.pellet.api.term.axiom.ObjectPropertyAssertion;
import com.clarkparsia.pellet.api.term.axiom.ObjectPropertyDomain;
import com.clarkparsia.pellet.api.term.axiom.ObjectPropertyRange;
import com.clarkparsia.pellet.api.term.axiom.Reflexive;
import com.clarkparsia.pellet.api.term.axiom.SameIndividual;
import com.clarkparsia.pellet.api.term.axiom.SubAnnotationPropertyOf;
import com.clarkparsia.pellet.api.term.axiom.SubClassOf;
import com.clarkparsia.pellet.api.term.axiom.SubDataPropertyOf;
import com.clarkparsia.pellet.api.term.axiom.SubObjectPropertyChain;
import com.clarkparsia.pellet.api.term.axiom.SubObjectPropertyOf;
import com.clarkparsia.pellet.api.term.axiom.Symmetric;
import com.clarkparsia.pellet.api.term.axiom.Transitive;
import com.clarkparsia.pellet.api.term.axiom.TypeAssertion;
import com.clarkparsia.pellet.api.term.builtins.Classes;
import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.api.term.builtins.ObjectProperties;
import com.clarkparsia.pellet.api.term.entity.ClassExpression;
import com.clarkparsia.pellet.api.term.entity.Individual;
import com.clarkparsia.pellet.api.term.entity.NamedClass;
import com.clarkparsia.pellet.api.term.entity.ObjectProperty;
import com.clarkparsia.pellet.api.term.visitor.BaseTermVisitor;
import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;

public class SatisfiabilityConverter {
    private static final AxiomConverter CONVERTER = new AxiomConverter();
    public static final Function<Axiom, ClassExpression> INSTANCE = new Function<Axiom, ClassExpression>(){

        public ClassExpression apply(Axiom from) {
            return SatisfiabilityConverter.convert(from);
        }
    };

    public static ClassExpression convert(Axiom axiom) {
        return axiom.accept(CONVERTER);
    }

    public static Function<Axiom, ClassExpression> getInstance() {
        return INSTANCE;
    }

    private SatisfiabilityConverter() {
    }

    private static class AxiomConverter
    extends BaseTermVisitor<ClassExpression> {
        private AxiomConverter() {
        }

        @Override
        protected ClassExpression defaultVisit(Term term) {
            throw new UnsupportedOperationException("Axiom not supported: " + String.valueOf(term));
        }

        private ClassExpression convertType(Individual ind, ClassExpression cls) {
            return this.convertSubClass(TermFactory.oneOf(ind), cls);
        }

        private ClassExpression convertSubClass(ClassExpression sub, ClassExpression sup) {
            return sub.and((ClassExpression)TermFactory.not(sup));
        }

        @Override
        public ClassExpression visit(AnnotationPropertyDomain axiom) {
            return this.defaultVisit(axiom);
        }

        @Override
        public ClassExpression visit(AnnotationPropertyRange axiom) {
            return this.defaultVisit(axiom);
        }

        @Override
        public ClassExpression visit(DataFunctional axiom) {
            return this.defaultVisit(axiom);
        }

        @Override
        public ClassExpression visit(DataPropertyAssertion axiom) {
            return this.convertType(axiom.getSubject(), axiom.getProperty().value(axiom.getObject()));
        }

        @Override
        public ClassExpression visit(DataPropertyDomain axiom) {
            return this.convertSubClass(axiom.getProperty().some(Datatypes.TOP), axiom.getDomain());
        }

        @Override
        public ClassExpression visit(DataPropertyRange axiom) {
            return axiom.getProperty().some(TermFactory.dataNot(axiom.getRange()));
        }

        @Override
        public ClassExpression visit(DatatypeDefinition axiom) {
            return this.defaultVisit(axiom);
        }

        @Override
        public ClassExpression visit(Declaration axiom) {
            return this.defaultVisit(axiom);
        }

        @Override
        public ClassExpression visit(DifferentIndividuals axiom) {
            int n = axiom.size();
            if (n < 2) {
                return Classes.THING;
            }
            Iterator inds = axiom.iterator();
            Individual ind1 = (Individual)inds.next();
            Individual ind2 = (Individual)inds.next();
            if (inds.hasNext()) {
                this.defaultVisit(axiom);
            }
            return this.convertType(ind1, TermFactory.oneOf(ind2));
        }

        @Override
        public ClassExpression visit(DisjointClasses axiom) {
            return TermFactory.and(axiom.getArgs());
        }

        @Override
        public ClassExpression visit(DisjointDataProperties axiom) {
            return this.defaultVisit(axiom);
        }

        @Override
        public ClassExpression visit(DisjointObjectProperties axiom) {
            Iterator props = axiom.iterator();
            ObjectProperty p1 = (ObjectProperty)props.next();
            ObjectProperty p2 = (ObjectProperty)props.next();
            if (props.hasNext()) {
                this.defaultVisit(axiom);
            }
            NamedClass c = TermFactory.namedClass("_C_");
            return TermFactory.not(c).and(p1.some(c), p2.some(c), ObjectProperties.TOP.max(1, c));
        }

        @Override
        public ClassExpression visit(DisjointUnion axiom) {
            return this.defaultVisit(axiom);
        }

        @Override
        public ClassExpression visit(EquivalentClasses axiom) {
            Iterator classes = axiom.iterator();
            ClassExpression c1 = (ClassExpression)classes.next();
            ClassExpression c2 = (ClassExpression)classes.next();
            if (classes.hasNext()) {
                this.defaultVisit(axiom);
            }
            if (c1.equals(Classes.NOTHING)) {
                return c2;
            }
            if (c2.equals(Classes.NOTHING)) {
                return c1;
            }
            if (c1.equals(Classes.THING)) {
                return TermFactory.not(c2);
            }
            if (c2.equals(Classes.THING)) {
                return TermFactory.not(c1);
            }
            return this.convertSubClass(c1, c2).or(this.convertSubClass(c2, c1));
        }

        @Override
        public ClassExpression visit(EquivalentDataProperties axiom) {
            return this.defaultVisit(axiom);
        }

        @Override
        public ClassExpression visit(EquivalentObjectProperties axiom) {
            return this.defaultVisit(axiom);
        }

        @Override
        public ClassExpression visit(ObjectInverseFunctional axiom) {
            return this.defaultVisit(axiom);
        }

        @Override
        public ClassExpression visit(InverseProperties axiom) {
            return this.defaultVisit(axiom);
        }

        @Override
        public ClassExpression visit(Irreflexive axiom) {
            return this.defaultVisit(axiom);
        }

        @Override
        public ClassExpression visit(NegativeDataPropertyAssertion axiom) {
            return this.convertType(axiom.getSubject(), TermFactory.not(axiom.getProperty().value(axiom.getObject())));
        }

        @Override
        public ClassExpression visit(NegativeObjectPropertyAssertion axiom) {
            return this.convertType(axiom.getSubject(), TermFactory.not(axiom.getProperty().value(axiom.getObject())));
        }

        @Override
        public ClassExpression visit(ObjectFunctional axiom) {
            return this.defaultVisit(axiom);
        }

        @Override
        public ClassExpression visit(ObjectPropertyAssertion axiom) {
            return this.convertType(axiom.getSubject(), axiom.getProperty().value(axiom.getObject()));
        }

        @Override
        public ClassExpression visit(ObjectPropertyDomain axiom) {
            return this.convertSubClass(axiom.getProperty().some(Classes.THING), axiom.getDomain());
        }

        @Override
        public ClassExpression visit(ObjectPropertyRange axiom) {
            return axiom.getProperty().some(TermFactory.not(axiom.getRange()));
        }

        @Override
        public ClassExpression visit(Reflexive axiom) {
            return this.defaultVisit(axiom);
        }

        @Override
        public ClassExpression visit(SameIndividual axiom) {
            int n = axiom.size();
            if (n < 2) {
                return Classes.THING;
            }
            HashSet terms = Sets.newHashSet();
            Iterator inds = axiom.iterator();
            Individual ind1 = (Individual)inds.next();
            while (inds.hasNext()) {
                Individual ind2 = (Individual)inds.next();
                terms.add(TermFactory.oneOf(ind2));
            }
            return TermFactory.oneOf(ind1).and((ClassExpression)TermFactory.not(TermFactory.and(terms)));
        }

        @Override
        public ClassExpression visit(SubAnnotationPropertyOf axiom) {
            return this.defaultVisit(axiom);
        }

        @Override
        public ClassExpression visit(SubClassOf axiom) {
            ClassExpression sub = axiom.getSub();
            ClassExpression sup = axiom.getSuper();
            if (sup.equals(Classes.NOTHING)) {
                return sub;
            }
            if (sub.equals(Classes.THING)) {
                return TermFactory.not(sup);
            }
            return this.convertSubClass(sub, sup);
        }

        @Override
        public ClassExpression visit(SubDataPropertyOf axiom) {
            return this.defaultVisit(axiom);
        }

        @Override
        public ClassExpression visit(SubObjectPropertyChain axiom) {
            return this.defaultVisit(axiom);
        }

        @Override
        public ClassExpression visit(SubObjectPropertyOf axiom) {
            ObjectProperty sub = axiom.getSub();
            ObjectProperty sup = axiom.getSuper();
            NamedClass c = TermFactory.namedClass("_C_");
            return sub.some(c).and((ClassExpression)sup.only(TermFactory.not(c)));
        }

        @Override
        public ClassExpression visit(Symmetric axiom) {
            return this.defaultVisit(axiom);
        }

        @Override
        public ClassExpression visit(Transitive axiom) {
            return this.defaultVisit(axiom);
        }

        @Override
        public ClassExpression visit(TypeAssertion axiom) {
            return this.convertType(axiom.getIndividual(), axiom.getType());
        }
    }
}

