/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.stark;

import com.clarkparsia.pellet.api.io.OntologySyntax;
import com.clarkparsia.pellet.rdf.AbstractRDFInput;
import com.clarkparsia.pellet.rdf.RDFInput;
import com.clarkparsia.pellet.rdf.RDFInputProvider;
import com.clarkparsia.pellet.stark.StarkRDFFactory;
import com.google.common.collect.ImmutableMap;
import com.stardog.stark.IRI;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Statements;
import com.stardog.stark.Value;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFParsers;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.input.ReaderInputStream;

public final class StarkGraphInput
extends AbstractRDFInput<Set<Statement>, Statement, Value, Resource, IRI, Iterator<Statement>> {
    public static final RDFInputProvider<Set<Statement>, Statement, Value, Resource, IRI, Iterator<Statement>> PROVIDER = new RDFInputProvider<Set<Statement>, Statement, Value, Resource, IRI, Iterator<Statement>>(){

        @Override
        public RDFInput<Statement, Value, Resource, IRI, Iterator<Statement>> getInput(InputStream in, OntologySyntax syntax) {
            try {
                return this.getInput(RDFParsers.read((InputStream)in, (RDFFormat)StarkGraphInput.getFormat(syntax)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public RDFInput<Statement, Value, Resource, IRI, Iterator<Statement>> getInput(Reader in, OntologySyntax syntax) {
            try {
                return this.getInput(RDFParsers.read((InputStream)new ReaderInputStream(in), (RDFFormat)StarkGraphInput.getFormat(syntax)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public RDFInput<Statement, Value, Resource, IRI, Iterator<Statement>> getInput(Set<Statement> graph) {
            return new StarkGraphInput(StarkRDFFactory.INSTANCE, graph);
        }
    };
    public static final Map<OntologySyntax, RDFFormat> SYNTAX_MAPPING = ImmutableMap.of((Object)OntologySyntax.RDF_XML, (Object)RDFFormats.RDFXML, (Object)OntologySyntax.TURTLE, (Object)RDFFormats.TURTLE);

    protected static RDFFormat getFormat(OntologySyntax syntax) {
        RDFFormat format = SYNTAX_MAPPING.get(syntax);
        if (format == null) {
            throw new UnsupportedOperationException("Unsupported syntax: " + String.valueOf(syntax));
        }
        return format;
    }

    public StarkGraphInput(Set<Statement> graph) {
        super(StarkRDFFactory.INSTANCE, graph);
    }

    public StarkGraphInput(StarkRDFFactory factory, Set<Statement> graph) {
        super(factory, graph);
    }

    @Override
    public void close(Iterator<Statement> i) {
    }

    @Override
    public Iterator<Statement> find(Resource subj, IRI pred, Value obj) {
        return ((Set)this.graph).stream().filter(Statements.matches((Resource)subj, (IRI)pred, (Value)obj, (Resource[])new Resource[0])).iterator();
    }

    @Override
    public boolean contains(Resource subj, IRI pred, Value obj) {
        return ((Set)this.graph).stream().anyMatch(Statements.matches((Resource)subj, (IRI)pred, (Value)obj, (Resource[])new Resource[0]));
    }
}

