/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rdf;

import com.clarkparsia.pellet.rdf.RDFTerm;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;

public class RDFTerms {
    public static final ImmutableList<RDFTerm> QUALIFIED_RESTRICTIONS = ImmutableList.of((Object)((Object)RDFTerm.OWL2_minQualifiedCardinality), (Object)((Object)RDFTerm.OWL2_maxQualifiedCardinality), (Object)((Object)RDFTerm.OWL2_qualifiedCardinality));
    public static final ImmutableList<RDFTerm> UNQUALIFIED_RESTRICTIONS = ImmutableList.of((Object)((Object)RDFTerm.OWL_someValuesFrom), (Object)((Object)RDFTerm.OWL_allValuesFrom), (Object)((Object)RDFTerm.OWL_hasValue), (Object)((Object)RDFTerm.OWL_minCardinality), (Object)((Object)RDFTerm.OWL_maxCardinality), (Object)((Object)RDFTerm.OWL_cardinality), (Object)((Object)RDFTerm.OWL2_hasSelf));
    public static final ImmutableList<RDFTerm> RESTRICTIONS = ImmutableList.builder().addAll(UNQUALIFIED_RESTRICTIONS).addAll(QUALIFIED_RESTRICTIONS).build();
    public static final ImmutableList<RDFTerm> EXPRESSIONS = ImmutableList.of((Object)((Object)RDFTerm.OWL_intersectionOf), (Object)((Object)RDFTerm.OWL_unionOf), (Object)((Object)RDFTerm.OWL_complementOf), (Object)((Object)RDFTerm.OWL_oneOf), (Object)((Object)RDFTerm.OWL_inverseOf), (Object)((Object)RDFTerm.OWL2_datatypeComplementOf), (Object)((Object)RDFTerm.OWL2_onDatatype));
    public static final ImmutableList<RDFTerm> FACETS = ImmutableList.of((Object)((Object)RDFTerm.XSD_length), (Object)((Object)RDFTerm.XSD_maxExclusive), (Object)((Object)RDFTerm.XSD_maxInclusive), (Object)((Object)RDFTerm.XSD_maxLength), (Object)((Object)RDFTerm.XSD_minExclusive), (Object)((Object)RDFTerm.XSD_minInclusive), (Object)((Object)RDFTerm.XSD_minLength), (Object)((Object)RDFTerm.XSD_pattern), (Object)((Object)RDFTerm.RDF_langRange));
    public static final ImmutableList<RDFTerm> TBOX_TYPES;
    public static final ImmutableList<RDFTerm> TBOX_PREDICATES;
    public static final ImmutableMap<String, RDFTerm> ALL;

    public static RDFTerm get(String uri) {
        return (RDFTerm)((Object)ALL.get((Object)uri));
    }

    static {
        ImmutableMap.Builder aResources = ImmutableMap.builder();
        ImmutableList.Builder aTBoxPreds = ImmutableList.builder();
        ImmutableList.Builder aTBoxTypes = ImmutableList.builder();
        for (RDFTerm term : RDFTerm.values()) {
            aResources.put((Object)term.getURI(), (Object)term);
            if (term.isPredicate()) {
                if (term.isABox() || term.isSyntax() || term.isPredefined()) continue;
                aTBoxPreds.add((Object)term);
                continue;
            }
            if (term.isABox() || term.isSyntax()) continue;
            aTBoxTypes.add((Object)term);
        }
        ALL = aResources.build();
        TBOX_PREDICATES = aTBoxPreds.build();
        TBOX_TYPES = aTBoxTypes.build();
    }
}

