/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rdf;

import com.clarkparsia.pellet.api.factory.AbstractFactory;
import com.clarkparsia.pellet.api.io.ExternalOntologyReader;
import com.clarkparsia.pellet.api.io.OntologyReader;
import com.clarkparsia.pellet.api.io.OntologyReaderFactory;
import com.clarkparsia.pellet.api.io.OntologySyntax;
import com.clarkparsia.pellet.api.io.impl.AbstractOntologyReader;
import com.clarkparsia.pellet.api.kb.AxiomStore;
import com.clarkparsia.pellet.rdf.RDFAxiomHandlers;
import com.clarkparsia.pellet.rdf.RDFAxiomReader;
import com.clarkparsia.pellet.rdf.RDFAxiomReaders;
import com.clarkparsia.pellet.rdf.RDFInput;
import com.clarkparsia.pellet.rdf.RDFInputProvider;
import com.complexible.common.base.Options;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;

public class RDFOntologyReaderFactory<Graph, Triple, Node, Resource extends Node, Predicate extends Resource, ClosableIterator extends Iterator<Triple>>
extends AbstractFactory<OntologyReader>
implements OntologyReaderFactory {
    private final OntologySyntax syntax;
    private final RDFInputProvider<Graph, Triple, Node, Resource, Predicate, ClosableIterator> factory;

    public static <G, T, N, R extends N, P extends R, CI extends Iterator<T>> OntologyReaderFactory create(RDFInputProvider<G, T, N, R, P, CI> factory, OntologySyntax syntax) {
        return new RDFOntologyReaderFactory<G, T, N, R, P, CI>(factory, syntax);
    }

    public static <G, T, N, R extends N, P extends R, CI extends Iterator<T>> ExternalOntologyReader<G> createExternalReader(RDFInputProvider<G, T, N, R, P, CI> factory, OntologySyntax syntax, Options options) {
        return new RDFOntologyReaderFactory<G, T, N, R, P, CI>(factory, syntax).create(options);
    }

    public RDFOntologyReaderFactory(RDFInputProvider<Graph, Triple, Node, Resource, Predicate, ClosableIterator> provider, OntologySyntax syntax) {
        this.factory = provider;
        this.syntax = syntax;
    }

    @Override
    public ExternalOntologyReader<Graph> create(Options options) {
        return new RDFExternalOntologyReader(options, this.syntax);
    }

    @Override
    public OntologySyntax getSyntax() {
        return this.syntax;
    }

    private class RDFExternalOntologyReader
    extends AbstractOntologyReader
    implements ExternalOntologyReader<Graph> {
        public RDFExternalOntologyReader(Options options, OntologySyntax syntax) {
            super(options, syntax);
        }

        @Override
        public <T> void read(AxiomStore kb, RDFInput<Triple, Node, Resource, Predicate, ClosableIterator> provider) {
            RDFAxiomReader axiomReader = RDFAxiomReaders.create(this.options);
            axiomReader.read(provider, RDFAxiomHandlers.addTo(kb));
        }

        @Override
        public void read(AxiomStore kb, Reader reader) throws IOException {
            this.read(kb, (Graph)RDFOntologyReaderFactory.this.factory.getInput(reader, this.syntax));
        }

        @Override
        public void read(AxiomStore kb, InputStream in) throws IOException {
            this.read(kb, (Graph)RDFOntologyReaderFactory.this.factory.getInput(in, this.syntax));
        }

        @Override
        public void read(AxiomStore kb, Graph graph) throws IOException {
            this.read(kb, (Graph)RDFOntologyReaderFactory.this.factory.getInput(graph));
        }
    }
}

