/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rdf;

import com.clarkparsia.pellet.api.kb.KnowledgeBase;
import com.clarkparsia.pellet.api.term.axiom.Axiom;
import com.clarkparsia.pellet.rdf.CachingRDFAxiomReader;
import com.clarkparsia.pellet.rdf.DefaultRDFAxiomReader;
import com.clarkparsia.pellet.rdf.RDFAxiomHandlers;
import com.clarkparsia.pellet.rdf.RDFAxiomReader;
import com.clarkparsia.pellet.rdf.RDFAxiomReaderOptions;
import com.clarkparsia.pellet.rdf.RDFInput;
import com.complexible.common.base.Options;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class RDFAxiomReaders {
    public static RDFAxiomReader create() {
        return RDFAxiomReaders.create(Options.create());
    }

    public static RDFAxiomReader create(Options options) {
        return RDFAxiomReaders.create(options, null);
    }

    public static RDFAxiomReader create(Options options, KnowledgeBase kb) {
        DefaultRDFAxiomReader axiomReader = null;
        axiomReader = options.is(RDFAxiomReaderOptions.MINIMIZE_QUERIES) ? new CachingRDFAxiomReader(options, kb) : new DefaultRDFAxiomReader(options, kb);
        return axiomReader;
    }

    public static <T, N, R extends N, P extends R, C extends Iterator<T>> Set<Axiom> read(RDFInput<T, N, R, P, C> input) {
        return RDFAxiomReaders.read(input, RDFAxiomReaders.create());
    }

    public static <T, N, R extends N, P extends R, C extends Iterator<T>> Set<Axiom> read(RDFInput<T, N, R, P, C> input, Options options) {
        return RDFAxiomReaders.read(input, RDFAxiomReaders.create(options));
    }

    public static <T, N, R extends N, P extends R, C extends Iterator<T>> Set<Axiom> read(RDFInput<T, N, R, P, C> input, Options options, KnowledgeBase kb) {
        return RDFAxiomReaders.read(input, RDFAxiomReaders.create(options, kb));
    }

    public static <T, N, R extends N, P extends R, C extends Iterator<T>> Set<Axiom> read(RDFInput<T, N, R, P, C> input, RDFAxiomReader reader) {
        HashSet axioms = Sets.newHashSet();
        reader.read(input, RDFAxiomHandlers.addTo(axioms));
        return axioms;
    }
}

