/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rdf;

import com.clarkparsia.pellet.api.io.OntologyWriterOptions;
import com.clarkparsia.pellet.api.term.Term;
import com.clarkparsia.pellet.api.term.TermCollection;
import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.axiom.AnnotationEntityVariable;
import com.clarkparsia.pellet.api.term.axiom.AnnotationPropertyDomain;
import com.clarkparsia.pellet.api.term.axiom.AnnotationPropertyRange;
import com.clarkparsia.pellet.api.term.axiom.Asymmetric;
import com.clarkparsia.pellet.api.term.axiom.AxiomAnnotation;
import com.clarkparsia.pellet.api.term.axiom.DataFunctional;
import com.clarkparsia.pellet.api.term.axiom.DataInverseFunctional;
import com.clarkparsia.pellet.api.term.axiom.DataPropertyAssertion;
import com.clarkparsia.pellet.api.term.axiom.DataPropertyDomain;
import com.clarkparsia.pellet.api.term.axiom.DataPropertyRange;
import com.clarkparsia.pellet.api.term.axiom.DatatypeDefinition;
import com.clarkparsia.pellet.api.term.axiom.Declaration;
import com.clarkparsia.pellet.api.term.axiom.DifferentIndividuals;
import com.clarkparsia.pellet.api.term.axiom.DisjointClasses;
import com.clarkparsia.pellet.api.term.axiom.DisjointDataProperties;
import com.clarkparsia.pellet.api.term.axiom.DisjointObjectProperties;
import com.clarkparsia.pellet.api.term.axiom.DisjointUnion;
import com.clarkparsia.pellet.api.term.axiom.EntityAnnotation;
import com.clarkparsia.pellet.api.term.axiom.EquivalentClasses;
import com.clarkparsia.pellet.api.term.axiom.EquivalentDataProperties;
import com.clarkparsia.pellet.api.term.axiom.EquivalentObjectProperties;
import com.clarkparsia.pellet.api.term.axiom.HasKey;
import com.clarkparsia.pellet.api.term.axiom.InverseProperties;
import com.clarkparsia.pellet.api.term.axiom.Irreflexive;
import com.clarkparsia.pellet.api.term.axiom.NamedAnnotationEntity;
import com.clarkparsia.pellet.api.term.axiom.NegativeDataPropertyAssertion;
import com.clarkparsia.pellet.api.term.axiom.NegativeObjectPropertyAssertion;
import com.clarkparsia.pellet.api.term.axiom.ObjectFunctional;
import com.clarkparsia.pellet.api.term.axiom.ObjectInverseFunctional;
import com.clarkparsia.pellet.api.term.axiom.ObjectPropertyAssertion;
import com.clarkparsia.pellet.api.term.axiom.ObjectPropertyDomain;
import com.clarkparsia.pellet.api.term.axiom.ObjectPropertyRange;
import com.clarkparsia.pellet.api.term.axiom.Reflexive;
import com.clarkparsia.pellet.api.term.axiom.SameIndividual;
import com.clarkparsia.pellet.api.term.axiom.SubAnnotationPropertyOf;
import com.clarkparsia.pellet.api.term.axiom.SubClassOf;
import com.clarkparsia.pellet.api.term.axiom.SubDataPropertyOf;
import com.clarkparsia.pellet.api.term.axiom.SubObjectPropertyChain;
import com.clarkparsia.pellet.api.term.axiom.SubObjectPropertyOf;
import com.clarkparsia.pellet.api.term.axiom.Symmetric;
import com.clarkparsia.pellet.api.term.axiom.Transitive;
import com.clarkparsia.pellet.api.term.axiom.TypeAssertion;
import com.clarkparsia.pellet.api.term.builtins.Classes;
import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.api.term.builtins.Functions;
import com.clarkparsia.pellet.api.term.builtins.Literals;
import com.clarkparsia.pellet.api.term.entity.AnnotationPropertyVariable;
import com.clarkparsia.pellet.api.term.entity.AnonIndividual;
import com.clarkparsia.pellet.api.term.entity.ClassVariable;
import com.clarkparsia.pellet.api.term.entity.DataAll;
import com.clarkparsia.pellet.api.term.entity.DataAnd;
import com.clarkparsia.pellet.api.term.entity.DataCardinality;
import com.clarkparsia.pellet.api.term.entity.DataHasValue;
import com.clarkparsia.pellet.api.term.entity.DataMax;
import com.clarkparsia.pellet.api.term.entity.DataMin;
import com.clarkparsia.pellet.api.term.entity.DataNot;
import com.clarkparsia.pellet.api.term.entity.DataOneOf;
import com.clarkparsia.pellet.api.term.entity.DataOr;
import com.clarkparsia.pellet.api.term.entity.DataPropertyVariable;
import com.clarkparsia.pellet.api.term.entity.DataSome;
import com.clarkparsia.pellet.api.term.entity.DatatypeVariable;
import com.clarkparsia.pellet.api.term.entity.Entity;
import com.clarkparsia.pellet.api.term.entity.FacetRestriction;
import com.clarkparsia.pellet.api.term.entity.HasValue;
import com.clarkparsia.pellet.api.term.entity.Individual;
import com.clarkparsia.pellet.api.term.entity.IndividualVariable;
import com.clarkparsia.pellet.api.term.entity.InverseObjectProperty;
import com.clarkparsia.pellet.api.term.entity.Literal;
import com.clarkparsia.pellet.api.term.entity.LiteralVariable;
import com.clarkparsia.pellet.api.term.entity.NamedAnnotationProperty;
import com.clarkparsia.pellet.api.term.entity.NamedClass;
import com.clarkparsia.pellet.api.term.entity.NamedDataProperty;
import com.clarkparsia.pellet.api.term.entity.NamedDatatype;
import com.clarkparsia.pellet.api.term.entity.NamedEntity;
import com.clarkparsia.pellet.api.term.entity.NamedIndividual;
import com.clarkparsia.pellet.api.term.entity.NamedObjectProperty;
import com.clarkparsia.pellet.api.term.entity.ObjectAll;
import com.clarkparsia.pellet.api.term.entity.ObjectAnd;
import com.clarkparsia.pellet.api.term.entity.ObjectCardinality;
import com.clarkparsia.pellet.api.term.entity.ObjectHasValue;
import com.clarkparsia.pellet.api.term.entity.ObjectMax;
import com.clarkparsia.pellet.api.term.entity.ObjectMin;
import com.clarkparsia.pellet.api.term.entity.ObjectNot;
import com.clarkparsia.pellet.api.term.entity.ObjectOneOf;
import com.clarkparsia.pellet.api.term.entity.ObjectOr;
import com.clarkparsia.pellet.api.term.entity.ObjectPropertyList;
import com.clarkparsia.pellet.api.term.entity.ObjectPropertyVariable;
import com.clarkparsia.pellet.api.term.entity.ObjectSelf;
import com.clarkparsia.pellet.api.term.entity.ObjectSome;
import com.clarkparsia.pellet.api.term.entity.QualifiedCardinalityRestriction;
import com.clarkparsia.pellet.api.term.entity.QualifiedRestriction;
import com.clarkparsia.pellet.api.term.entity.RestrictedDatatype;
import com.clarkparsia.pellet.api.term.entity.Restriction;
import com.clarkparsia.pellet.api.term.entity.Variable;
import com.clarkparsia.pellet.api.term.function.BindAtom;
import com.clarkparsia.pellet.api.term.function.Expression;
import com.clarkparsia.pellet.api.term.function.FilterAtom;
import com.clarkparsia.pellet.api.term.function.Function;
import com.clarkparsia.pellet.api.term.function.FunctionEval;
import com.clarkparsia.pellet.api.term.query.DatatypeAtom;
import com.clarkparsia.pellet.api.term.query.DirectSubClassOf;
import com.clarkparsia.pellet.api.term.query.DirectSubDataPropertyOf;
import com.clarkparsia.pellet.api.term.query.DirectSubObjectPropertyOf;
import com.clarkparsia.pellet.api.term.query.DirectTypeAssertion;
import com.clarkparsia.pellet.api.term.query.StrictSubClassOf;
import com.clarkparsia.pellet.api.term.query.StrictSubDataPropertyOf;
import com.clarkparsia.pellet.api.term.query.StrictSubObjectPropertyOf;
import com.clarkparsia.pellet.api.term.rule.Rule;
import com.clarkparsia.pellet.api.term.rule.RuleAtom;
import com.clarkparsia.pellet.api.term.visitor.BaseTermVisitor;
import com.clarkparsia.pellet.api.term.visitor.BaseTermVisitorVoid;
import com.clarkparsia.pellet.api.term.visitor.TermVisitor;
import com.clarkparsia.pellet.api.term.visitor.TermVisitorVoid;
import com.clarkparsia.pellet.rdf.RDFAxiomWriter;
import com.clarkparsia.pellet.rdf.RDFFactory;
import com.clarkparsia.pellet.rdf.RDFOutput;
import com.clarkparsia.pellet.rdf.RDFTerm;
import com.complexible.common.base.Options;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultRDFAxiomWriter<Node, Resource extends Node, Predicate extends Resource>
implements RDFAxiomWriter {
    private RDFFactory<?, Node, Resource, Predicate> factory;
    private RDFOutput<Node, Resource, Predicate> graph;
    private final Options options;
    private final TermVisitorVoid axiomWriter = new BaseTermVisitorVoid(){

        @Override
        public void visit(DisjointClasses axiom) {
            DefaultRDFAxiomWriter.this.writeBinaryOrNary(RDFTerm.OWL2_AllDisjointClasses, RDFTerm.OWL_members, RDFTerm.OWL_disjointWith, axiom);
        }

        @Override
        public void visit(DisjointUnion axiom) {
            Object list = DefaultRDFAxiomWriter.this.writeList(axiom.getDefinition());
            Object cls = axiom.getNamedClass().accept(DefaultRDFAxiomWriter.this.entityResourceWriter);
            DefaultRDFAxiomWriter.this.graph.add(cls, RDFTerm.OWL2_disjointUnionOf, list);
        }

        @Override
        public void visit(EquivalentClasses axiom) {
            DefaultRDFAxiomWriter.this.writeBinaryForEach(RDFTerm.OWL_equivalentClass, axiom);
        }

        @Override
        public void visit(SubClassOf axiom) {
            DefaultRDFAxiomWriter.this.writeTriple(axiom.getSub(), RDFTerm.RDFS_subClassOf, axiom.getSuper());
        }

        @Override
        public void visit(DataPropertyAssertion axiom) {
            Object subj = axiom.getSubject().accept(DefaultRDFAxiomWriter.this.entityResourceWriter);
            Object pred = axiom.getProperty().accept(DefaultRDFAxiomWriter.this.entityResourceWriter);
            Object obj = axiom.getObject().accept(DefaultRDFAxiomWriter.this.entityNodeWriter);
            DefaultRDFAxiomWriter.this.graph.add(subj, pred, obj);
        }

        @Override
        public void visit(DifferentIndividuals axiom) {
            DefaultRDFAxiomWriter.this.writeBinaryOrNary(RDFTerm.OWL_AllDifferent, RDFTerm.OWL_members, RDFTerm.OWL_differentFrom, axiom);
        }

        @Override
        public void visit(TypeAssertion axiom) {
            DefaultRDFAxiomWriter.this.writeTriple(axiom.getIndividual(), RDFTerm.RDF_type, axiom.getType());
        }

        @Override
        public void visit(NegativeDataPropertyAssertion axiom) {
            Object n = DefaultRDFAxiomWriter.this.factory.createResource();
            DefaultRDFAxiomWriter.this.graph.add(n, RDFTerm.RDF_type, RDFTerm.OWL2_NegativePropertyAssertion);
            DefaultRDFAxiomWriter.this.graph.add(n, RDFTerm.OWL2_sourceIndividual, axiom.getSubject().accept(DefaultRDFAxiomWriter.this.entityResourceWriter));
            DefaultRDFAxiomWriter.this.graph.add(n, RDFTerm.OWL2_assertionProperty, axiom.getProperty().accept(DefaultRDFAxiomWriter.this.entityResourceWriter));
            DefaultRDFAxiomWriter.this.graph.add(n, RDFTerm.OWL2_targetValue, axiom.getObject().accept(DefaultRDFAxiomWriter.this.entityNodeWriter));
        }

        @Override
        public void visit(NegativeObjectPropertyAssertion axiom) {
            Object n = DefaultRDFAxiomWriter.this.factory.createResource();
            DefaultRDFAxiomWriter.this.graph.add(n, RDFTerm.RDF_type, RDFTerm.OWL2_NegativePropertyAssertion);
            DefaultRDFAxiomWriter.this.graph.add(n, RDFTerm.OWL2_sourceIndividual, axiom.getSubject().accept(DefaultRDFAxiomWriter.this.entityResourceWriter));
            DefaultRDFAxiomWriter.this.graph.add(n, RDFTerm.OWL2_assertionProperty, axiom.getProperty().accept(DefaultRDFAxiomWriter.this.entityResourceWriter));
            DefaultRDFAxiomWriter.this.graph.add(n, RDFTerm.OWL2_targetIndividual, axiom.getObject().accept(DefaultRDFAxiomWriter.this.entityResourceWriter));
        }

        @Override
        public void visit(ObjectPropertyAssertion axiom) {
            Object subj = axiom.getSubject().accept(DefaultRDFAxiomWriter.this.entityResourceWriter);
            Object pred = axiom.getProperty().accept(DefaultRDFAxiomWriter.this.entityResourceWriter);
            Object obj = axiom.getObject().accept(DefaultRDFAxiomWriter.this.entityResourceWriter);
            DefaultRDFAxiomWriter.this.graph.add(subj, pred, obj);
        }

        @Override
        public void visit(SameIndividual axiom) {
            DefaultRDFAxiomWriter.this.writeBinaryForEach(RDFTerm.OWL_sameAs, axiom);
        }

        @Override
        public void visit(Asymmetric axiom) {
            DefaultRDFAxiomWriter.this.writeUnary(RDFTerm.OWL2_AsymmetricProperty, axiom.getProperty());
        }

        @Override
        public void visit(DataPropertyDomain axiom) {
            DefaultRDFAxiomWriter.this.writeTriple(axiom.getProperty(), RDFTerm.RDFS_domain, axiom.getDomain());
        }

        @Override
        public void visit(DataPropertyRange axiom) {
            DefaultRDFAxiomWriter.this.writeTriple(axiom.getProperty(), RDFTerm.RDFS_range, axiom.getRange());
        }

        @Override
        public void visit(DisjointDataProperties axiom) {
            DefaultRDFAxiomWriter.this.writeBinaryOrNary(RDFTerm.OWL2_AllDisjointProperties, RDFTerm.OWL_members, RDFTerm.OWL2_propertyDisjointWith, axiom);
        }

        @Override
        public void visit(DisjointObjectProperties axiom) {
            DefaultRDFAxiomWriter.this.writeBinaryOrNary(RDFTerm.OWL2_AllDisjointProperties, RDFTerm.OWL_members, RDFTerm.OWL2_propertyDisjointWith, axiom);
        }

        @Override
        public void visit(EquivalentDataProperties axiom) {
            DefaultRDFAxiomWriter.this.writeBinaryForEach(RDFTerm.OWL_equivalentProperty, axiom);
        }

        @Override
        public void visit(EquivalentObjectProperties axiom) {
            DefaultRDFAxiomWriter.this.writeBinaryForEach(RDFTerm.OWL_equivalentProperty, axiom);
        }

        @Override
        public void visit(DataFunctional axiom) {
            DefaultRDFAxiomWriter.this.writeUnary(RDFTerm.OWL_FunctionalProperty, axiom.getProperty());
        }

        @Override
        public void visit(ObjectFunctional axiom) {
            DefaultRDFAxiomWriter.this.writeUnary(RDFTerm.OWL_FunctionalProperty, axiom.getProperty());
        }

        @Override
        public void visit(DataInverseFunctional axiom) {
            DefaultRDFAxiomWriter.this.writeUnary(RDFTerm.OWL_InverseFunctionalProperty, axiom.getProperty());
        }

        @Override
        public void visit(ObjectInverseFunctional axiom) {
            DefaultRDFAxiomWriter.this.writeUnary(RDFTerm.OWL_InverseFunctionalProperty, axiom.getProperty());
        }

        @Override
        public void visit(InverseProperties axiom) {
            DefaultRDFAxiomWriter.this.writeTriple(axiom.getProperty(), RDFTerm.OWL_inverseOf, axiom.getInverseProperty());
        }

        @Override
        public void visit(Irreflexive axiom) {
            DefaultRDFAxiomWriter.this.writeUnary(RDFTerm.OWL2_IrreflexiveProperty, axiom.getProperty());
        }

        @Override
        public void visit(ObjectPropertyRange axiom) {
            DefaultRDFAxiomWriter.this.writeTriple(axiom.getProperty(), RDFTerm.RDFS_range, axiom.getRange());
        }

        @Override
        public void visit(ObjectPropertyDomain axiom) {
            DefaultRDFAxiomWriter.this.writeTriple(axiom.getProperty(), RDFTerm.RDFS_domain, axiom.getDomain());
        }

        @Override
        public void visit(Reflexive axiom) {
            DefaultRDFAxiomWriter.this.writeUnary(RDFTerm.OWL2_ReflexiveProperty, axiom.getProperty());
        }

        @Override
        public void visit(SubDataPropertyOf axiom) {
            DefaultRDFAxiomWriter.this.writeTriple(axiom.getSub(), RDFTerm.RDFS_subPropertyOf, axiom.getSuper());
        }

        @Override
        public void visit(SubObjectPropertyChain axiom) {
            Object list = DefaultRDFAxiomWriter.this.writeList(axiom.getSub());
            DefaultRDFAxiomWriter.this.graph.add(axiom.getSuper().accept(DefaultRDFAxiomWriter.this.entityResourceWriter), RDFTerm.OWL2_propertyChainAxiom, list);
        }

        @Override
        public void visit(SubObjectPropertyOf axiom) {
            DefaultRDFAxiomWriter.this.writeTriple(axiom.getSub(), RDFTerm.RDFS_subPropertyOf, axiom.getSuper());
        }

        @Override
        public void visit(Symmetric axiom) {
            DefaultRDFAxiomWriter.this.writeUnary(RDFTerm.OWL_SymmetricProperty, axiom.getProperty());
        }

        @Override
        public void visit(Transitive axiom) {
            DefaultRDFAxiomWriter.this.writeUnary(RDFTerm.OWL_TransitiveProperty, axiom.getProperty());
        }

        @Override
        public void visit(DatatypeDefinition axiom) {
            DefaultRDFAxiomWriter.this.writeTriple(axiom.getDatatype(), RDFTerm.OWL_equivalentClass, axiom.getDefinition());
        }

        @Override
        public void visit(Rule axiom) {
            Object node = DefaultRDFAxiomWriter.this.factory.createResource();
            DefaultRDFAxiomWriter.this.graph.add(node, RDFTerm.RDF_type, RDFTerm.SWRL_Imp);
            DefaultRDFAxiomWriter.this.graph.add(node, RDFTerm.SWRL_head, DefaultRDFAxiomWriter.this.writeList(axiom.getHead(), DefaultRDFAxiomWriter.this.ruleAtomWriter));
            DefaultRDFAxiomWriter.this.graph.add(node, RDFTerm.SWRL_body, DefaultRDFAxiomWriter.this.writeList(DefaultRDFAxiomWriter.flattenRuleAtoms(axiom.getBody()), DefaultRDFAxiomWriter.this.ruleAtomWriter));
        }

        @Override
        public void visit(Declaration declaration) {
            NamedEntity entity = declaration.getEntity();
            if (DefaultRDFAxiomWriter.this.options.get(OntologyWriterOptions.DECLARATION_HANDLING) != OntologyWriterOptions.DeclarationHandling.WRITE_NONE) {
                DefaultRDFAxiomWriter.this.graph.add(entity.accept(DefaultRDFAxiomWriter.this.entityResourceWriter), RDFTerm.RDF_type, entity.accept(DefaultRDFAxiomWriter.this.declarationFinder));
            }
        }

        @Override
        public void visit(AxiomAnnotation annotation) {
        }

        @Override
        public void visit(EntityAnnotation annotation) {
            Object subj = annotation.getSubject().accept(DefaultRDFAxiomWriter.this.entityResourceWriter);
            Object pred = annotation.getProperty().accept(DefaultRDFAxiomWriter.this.entityResourceWriter);
            Object obj = annotation.getObject().accept(DefaultRDFAxiomWriter.this.entityNodeWriter);
            DefaultRDFAxiomWriter.this.graph.add(subj, pred, obj);
        }

        @Override
        public void visit(AnnotationPropertyDomain axiom) {
            DefaultRDFAxiomWriter.this.writeTriple(axiom.getProperty(), RDFTerm.RDFS_domain, axiom.getDomain());
        }

        @Override
        public void visit(AnnotationPropertyRange axiom) {
            DefaultRDFAxiomWriter.this.writeTriple(axiom.getProperty(), RDFTerm.RDFS_range, axiom.getRange());
        }

        @Override
        public void visit(SubAnnotationPropertyOf axiom) {
            DefaultRDFAxiomWriter.this.writeTriple(axiom.getSub(), RDFTerm.RDFS_subPropertyOf, axiom.getSuper());
        }

        @Override
        public void visit(HasKey axiom) {
            Object list = DefaultRDFAxiomWriter.this.writeList(axiom.getProperties());
            DefaultRDFAxiomWriter.this.graph.add(axiom.getKeyClass().accept(DefaultRDFAxiomWriter.this.entityResourceWriter), RDFTerm.OWL2_hasKey, list);
        }

        @Override
        public void visit(DirectSubClassOf query) {
            DefaultRDFAxiomWriter.this.writeTriple(query.getSub(), RDFTerm.SPARQL_directSubClassOf, query.getSuper());
        }

        @Override
        public void visit(StrictSubClassOf query) {
            DefaultRDFAxiomWriter.this.writeTriple(query.getSub(), RDFTerm.SPARQL_strictSubClassOf, query.getSuper());
        }

        @Override
        public void visit(DirectSubObjectPropertyOf query) {
            DefaultRDFAxiomWriter.this.writeTriple(query.getSub(), RDFTerm.SPARQL_directSubPropertyOf, query.getSuper());
        }

        @Override
        public void visit(StrictSubObjectPropertyOf query) {
            DefaultRDFAxiomWriter.this.writeTriple(query.getSub(), RDFTerm.SPARQL_strictSubPropertyOf, query.getSuper());
        }

        @Override
        public void visit(DirectSubDataPropertyOf query) {
            DefaultRDFAxiomWriter.this.writeTriple(query.getSub(), RDFTerm.SPARQL_directSubPropertyOf, query.getSuper());
        }

        @Override
        public void visit(StrictSubDataPropertyOf query) {
            DefaultRDFAxiomWriter.this.writeTriple(query.getSub(), RDFTerm.SPARQL_strictSubPropertyOf, query.getSuper());
        }

        @Override
        public void visit(DirectTypeAssertion query) {
            DefaultRDFAxiomWriter.this.writeTriple(query.getIndividual(), RDFTerm.SPARQL_directType, query.getType());
        }
    };
    TermVisitor<RDFTerm> declarationFinder = new BaseTermVisitor<RDFTerm>(){

        @Override
        public RDFTerm visit(AnonIndividual ind) {
            return DefaultRDFAxiomWriter.this.getIndividualDeclarationTerm();
        }

        @Override
        public RDFTerm visit(NamedAnnotationProperty p) {
            return RDFTerm.OWL_AnnotationProperty;
        }

        @Override
        public RDFTerm visit(NamedClass c) {
            return RDFTerm.OWL_Class;
        }

        @Override
        public RDFTerm visit(NamedDataProperty p) {
            return RDFTerm.OWL_DatatypeProperty;
        }

        @Override
        public RDFTerm visit(NamedDatatype d) {
            return RDFTerm.RDFS_Datatype;
        }

        @Override
        public RDFTerm visit(NamedIndividual ind) {
            return DefaultRDFAxiomWriter.this.getIndividualDeclarationTerm();
        }

        @Override
        public RDFTerm visit(NamedObjectProperty p) {
            return RDFTerm.OWL_ObjectProperty;
        }

        @Override
        public RDFTerm visit(AnnotationPropertyVariable p) {
            return RDFTerm.OWL_AnnotationProperty;
        }

        @Override
        public RDFTerm visit(IndividualVariable var) {
            return DefaultRDFAxiomWriter.this.getIndividualDeclarationTerm();
        }

        @Override
        public RDFTerm visit(ObjectPropertyVariable var) {
            return RDFTerm.OWL_ObjectProperty;
        }

        @Override
        public RDFTerm visit(DataPropertyVariable var) {
            return RDFTerm.OWL_DatatypeProperty;
        }

        @Override
        public RDFTerm visit(DatatypeVariable var) {
            return RDFTerm.RDFS_Datatype;
        }

        @Override
        public RDFTerm visit(ClassVariable var) {
            return RDFTerm.OWL_Class;
        }
    };
    TermVisitor<Node> entityNodeWriter = new BaseTermVisitor<Node>(){

        @Override
        protected Node defaultVisit(Term term) {
            return term.accept(DefaultRDFAxiomWriter.this.entityResourceWriter);
        }

        @Override
        public Node visit(Literal literal) {
            return literal.hasLanguage() ? DefaultRDFAxiomWriter.this.factory.createPlainLiteral(literal.getLexicalValue(), literal.getLanguage()) : DefaultRDFAxiomWriter.this.factory.createTypedLiteral(literal.getLexicalValue(), literal.getDatatype().getName());
        }

        @Override
        public Node visit(LiteralVariable var) {
            return DefaultRDFAxiomWriter.this.writeVar(var);
        }
    };
    TermVisitor<Resource> entityResourceWriter = new BaseTermVisitor<Resource>(){
        private Map<String, Resource> bnodes = Maps.newHashMap();

        @Override
        protected Resource defaultVisit(Term term) {
            throw new IllegalArgumentException(term.toString());
        }

        @Override
        public Resource visit(IndividualVariable var) {
            return DefaultRDFAxiomWriter.this.writeVar(var);
        }

        @Override
        public Resource visit(AnnotationPropertyVariable var) {
            return DefaultRDFAxiomWriter.this.writeVar(var);
        }

        @Override
        public Resource visit(AnnotationEntityVariable var) {
            return DefaultRDFAxiomWriter.this.writeVar(var);
        }

        @Override
        public Resource visit(ObjectPropertyVariable var) {
            return DefaultRDFAxiomWriter.this.writeVar(var);
        }

        @Override
        public Resource visit(DataPropertyVariable var) {
            return DefaultRDFAxiomWriter.this.writeVar(var);
        }

        @Override
        public Resource visit(DatatypeVariable var) {
            return DefaultRDFAxiomWriter.this.writeVar(var);
        }

        @Override
        public Resource visit(ClassVariable var) {
            return DefaultRDFAxiomWriter.this.writeVar(var);
        }

        @Override
        public Resource visit(ObjectAnd and) {
            return DefaultRDFAxiomWriter.this.writeNary(RDFTerm.OWL_Class, RDFTerm.OWL_intersectionOf, and);
        }

        @Override
        public Resource visit(ObjectNot not) {
            return DefaultRDFAxiomWriter.this.writeUnary(RDFTerm.OWL_Class, RDFTerm.OWL_complementOf, not.getArg());
        }

        @Override
        public Resource visit(ObjectOr or) {
            return DefaultRDFAxiomWriter.this.writeNary(RDFTerm.OWL_Class, RDFTerm.OWL_unionOf, or);
        }

        @Override
        public Resource visit(DataAll all) {
            return DefaultRDFAxiomWriter.this.writeRestriction(all, RDFTerm.OWL_allValuesFrom);
        }

        @Override
        public Resource visit(DataCardinality card) {
            return DefaultRDFAxiomWriter.this.writeRestriction(card, RDFTerm.OWL_cardinality, RDFTerm.OWL2_qualifiedCardinality, RDFTerm.OWL2_onDataRange);
        }

        @Override
        public Resource visit(DataHasValue value) {
            return DefaultRDFAxiomWriter.this.writeRestriction(value, RDFTerm.OWL_hasValue);
        }

        @Override
        public Resource visit(DataMax max) {
            return DefaultRDFAxiomWriter.this.writeRestriction(max, RDFTerm.OWL_maxCardinality, RDFTerm.OWL2_maxQualifiedCardinality, RDFTerm.OWL2_onDataRange);
        }

        @Override
        public Resource visit(DataMin min) {
            return DefaultRDFAxiomWriter.this.writeRestriction(min, RDFTerm.OWL_minCardinality, RDFTerm.OWL2_minQualifiedCardinality, RDFTerm.OWL2_onDataRange);
        }

        @Override
        public Resource visit(DataSome some) {
            return DefaultRDFAxiomWriter.this.writeRestriction(some, RDFTerm.OWL_someValuesFrom);
        }

        @Override
        public Resource visit(NamedClass c) {
            Object node = DefaultRDFAxiomWriter.this.factory.createResource(c.getName());
            if (DefaultRDFAxiomWriter.this.isDeclarationWriteAll()) {
                DefaultRDFAxiomWriter.this.graph.add(node, RDFTerm.RDF_type, RDFTerm.OWL_Class);
            }
            return node;
        }

        @Override
        public Resource visit(ObjectAll all) {
            return DefaultRDFAxiomWriter.this.writeRestriction(all, RDFTerm.OWL_allValuesFrom);
        }

        @Override
        public Resource visit(ObjectCardinality card) {
            return DefaultRDFAxiomWriter.this.writeRestriction(card, RDFTerm.OWL_cardinality, RDFTerm.OWL2_qualifiedCardinality, RDFTerm.OWL2_onClass);
        }

        @Override
        public Resource visit(ObjectHasValue value) {
            return DefaultRDFAxiomWriter.this.writeRestriction(value, RDFTerm.OWL_hasValue);
        }

        @Override
        public Resource visit(ObjectMax max) {
            return DefaultRDFAxiomWriter.this.writeRestriction(max, RDFTerm.OWL_maxCardinality, RDFTerm.OWL2_maxQualifiedCardinality, RDFTerm.OWL2_onClass);
        }

        @Override
        public Resource visit(ObjectMin min) {
            return DefaultRDFAxiomWriter.this.writeRestriction(min, RDFTerm.OWL_minCardinality, RDFTerm.OWL2_minQualifiedCardinality, RDFTerm.OWL2_onClass);
        }

        @Override
        public Resource visit(ObjectOneOf oneOf) {
            return DefaultRDFAxiomWriter.this.writeNary(RDFTerm.OWL_Class, RDFTerm.OWL_oneOf, oneOf);
        }

        @Override
        public Resource visit(ObjectSome some) {
            return DefaultRDFAxiomWriter.this.writeRestriction(some, RDFTerm.OWL_someValuesFrom);
        }

        @Override
        public Resource visit(ObjectSelf self) {
            Object restr = DefaultRDFAxiomWriter.this.writeRestriction(self);
            DefaultRDFAxiomWriter.this.graph.add(restr, RDFTerm.OWL2_hasSelf, Literals.TRUE.accept(DefaultRDFAxiomWriter.this.entityNodeWriter));
            return restr;
        }

        @Override
        public Resource visit(NamedAnnotationEntity entity) {
            return DefaultRDFAxiomWriter.this.factory.createResource(entity.getName());
        }

        @Override
        public Resource visit(AnonIndividual ind) {
            Object bnode = this.bnodes.get(ind.getName());
            if (bnode == null) {
                bnode = DefaultRDFAxiomWriter.this.factory.createResource();
                this.bnodes.put(ind.getName(), bnode);
            }
            return bnode;
        }

        @Override
        public Resource visit(NamedIndividual ind) {
            Object node = DefaultRDFAxiomWriter.this.factory.createResource(ind.getName());
            if (DefaultRDFAxiomWriter.this.isDeclarationWriteAll()) {
                DefaultRDFAxiomWriter.this.graph.add(node, RDFTerm.RDF_type, DefaultRDFAxiomWriter.this.getIndividualDeclarationTerm());
            }
            return node;
        }

        @Override
        public Resource visit(InverseObjectProperty p) {
            return DefaultRDFAxiomWriter.this.writeUnary(RDFTerm.OWL_Class, RDFTerm.OWL_inverseOf, p.getProperty());
        }

        @Override
        public Predicate visit(NamedAnnotationProperty p) {
            Object node = DefaultRDFAxiomWriter.this.factory.createPredicate(p.getName());
            if (DefaultRDFAxiomWriter.this.isDeclarationWriteAll()) {
                DefaultRDFAxiomWriter.this.graph.add(node, RDFTerm.RDF_type, RDFTerm.OWL_AnnotationProperty);
            }
            return node;
        }

        @Override
        public Predicate visit(NamedDataProperty p) {
            Object node = DefaultRDFAxiomWriter.this.factory.createPredicate(p.getName());
            if (DefaultRDFAxiomWriter.this.isDeclarationWriteAll()) {
                DefaultRDFAxiomWriter.this.graph.add(node, RDFTerm.RDF_type, RDFTerm.OWL_DatatypeProperty);
            }
            return node;
        }

        @Override
        public Predicate visit(NamedObjectProperty p) {
            Object node = DefaultRDFAxiomWriter.this.factory.createPredicate(p.getName());
            if (DefaultRDFAxiomWriter.this.isDeclarationWriteAll()) {
                DefaultRDFAxiomWriter.this.graph.add(node, RDFTerm.RDF_type, RDFTerm.OWL_ObjectProperty);
            }
            return node;
        }

        @Override
        public Resource visit(ObjectPropertyList p) {
            return DefaultRDFAxiomWriter.this.writeList(p);
        }

        @Override
        public Resource visit(DataAnd and) {
            return DefaultRDFAxiomWriter.this.writeNary(RDFTerm.RDFS_Datatype, RDFTerm.OWL_intersectionOf, and);
        }

        @Override
        public Resource visit(DataOneOf oneOf) {
            return DefaultRDFAxiomWriter.this.writeNary(RDFTerm.RDFS_Datatype, RDFTerm.OWL_oneOf, oneOf, DefaultRDFAxiomWriter.this.entityNodeWriter);
        }

        @Override
        public Resource visit(DataNot not) {
            return DefaultRDFAxiomWriter.this.writeUnary(RDFTerm.RDFS_Datatype, RDFTerm.OWL2_datatypeComplementOf, not.getArg());
        }

        @Override
        public Resource visit(DataOr or) {
            return DefaultRDFAxiomWriter.this.writeNary(RDFTerm.RDFS_Datatype, RDFTerm.OWL_unionOf, or);
        }

        @Override
        public Resource visit(NamedDatatype d) {
            Object node = DefaultRDFAxiomWriter.this.factory.createResource(d.getName());
            if (DefaultRDFAxiomWriter.this.isDeclarationWriteAll()) {
                DefaultRDFAxiomWriter.this.graph.add(node, RDFTerm.RDF_type, RDFTerm.RDFS_Datatype);
            }
            return node;
        }

        @Override
        public Resource visit(RestrictedDatatype d) {
            Object def = DefaultRDFAxiomWriter.this.factory.createResource();
            DefaultRDFAxiomWriter.this.graph.add(def, RDFTerm.RDF_type, RDFTerm.RDFS_Datatype);
            DefaultRDFAxiomWriter.this.graph.add(def, RDFTerm.OWL2_onDatatype, d.getDatatype().accept(DefaultRDFAxiomWriter.this.entityResourceWriter));
            Object list = DefaultRDFAxiomWriter.this.writeList(d.getRestrictions());
            DefaultRDFAxiomWriter.this.graph.add(def, RDFTerm.OWL2_withRestrictions, list);
            return def;
        }

        @Override
        public Resource visit(FacetRestriction fr) {
            Object result = DefaultRDFAxiomWriter.this.factory.createResource();
            DefaultRDFAxiomWriter.this.graph.add(result, DefaultRDFAxiomWriter.this.factory.createPredicate(fr.getFacet().getName()), fr.getValue().accept(DefaultRDFAxiomWriter.this.entityNodeWriter));
            return result;
        }
    };
    TermVisitor<Node> ruleAtomWriter = new BaseTermVisitor<Node>(){

        @Override
        protected Node defaultVisit(Term term) {
            throw new IllegalArgumentException(term.toString());
        }

        @Override
        public Node visit(DataPropertyAssertion axiom) {
            Object atom = DefaultRDFAxiomWriter.this.factory.createResource();
            DefaultRDFAxiomWriter.this.graph.add(atom, RDFTerm.RDF_type, RDFTerm.SWRL_DatavaluedPropertyAtom);
            DefaultRDFAxiomWriter.this.graph.add(atom, RDFTerm.SWRL_propertyPredicate, axiom.getProperty().accept(DefaultRDFAxiomWriter.this.entityResourceWriter));
            DefaultRDFAxiomWriter.this.graph.add(atom, RDFTerm.SWRL_argument1, axiom.getSubject().accept(DefaultRDFAxiomWriter.this.entityResourceWriter));
            DefaultRDFAxiomWriter.this.graph.add(atom, RDFTerm.SWRL_argument2, axiom.getObject().accept(DefaultRDFAxiomWriter.this.entityNodeWriter));
            return atom;
        }

        @Override
        public Node visit(TypeAssertion axiom) {
            Object atom = DefaultRDFAxiomWriter.this.factory.createResource();
            DefaultRDFAxiomWriter.this.graph.add(atom, RDFTerm.RDF_type, RDFTerm.SWRL_ClassAtom);
            DefaultRDFAxiomWriter.this.graph.add(atom, RDFTerm.SWRL_classPredicate, axiom.getType().accept(DefaultRDFAxiomWriter.this.entityResourceWriter));
            DefaultRDFAxiomWriter.this.graph.add(atom, RDFTerm.SWRL_argument1, axiom.getIndividual().accept(DefaultRDFAxiomWriter.this.entityResourceWriter));
            return atom;
        }

        @Override
        public Node visit(ObjectPropertyAssertion axiom) {
            Object atom = DefaultRDFAxiomWriter.this.factory.createResource();
            DefaultRDFAxiomWriter.this.graph.add(atom, RDFTerm.RDF_type, RDFTerm.SWRL_IndividualPropertyAtom);
            DefaultRDFAxiomWriter.this.graph.add(atom, RDFTerm.SWRL_propertyPredicate, axiom.getProperty().accept(DefaultRDFAxiomWriter.this.entityResourceWriter));
            DefaultRDFAxiomWriter.this.graph.add(atom, RDFTerm.SWRL_argument1, axiom.getSubject().accept(DefaultRDFAxiomWriter.this.entityResourceWriter));
            DefaultRDFAxiomWriter.this.graph.add(atom, RDFTerm.SWRL_argument2, axiom.getObject().accept(DefaultRDFAxiomWriter.this.entityResourceWriter));
            return atom;
        }

        @Override
        public Node visit(SameIndividual axiom) {
            if (axiom.size() != 2) {
                throw new IllegalArgumentException("Invalid rule atom: " + String.valueOf(axiom));
            }
            Iterator it = axiom.iterator();
            Object atom = DefaultRDFAxiomWriter.this.factory.createResource();
            DefaultRDFAxiomWriter.this.graph.add(atom, RDFTerm.RDF_type, RDFTerm.SWRL_SameIndividualAtom);
            DefaultRDFAxiomWriter.this.graph.add(atom, RDFTerm.SWRL_argument1, ((Individual)it.next()).accept(DefaultRDFAxiomWriter.this.entityResourceWriter));
            DefaultRDFAxiomWriter.this.graph.add(atom, RDFTerm.SWRL_argument2, ((Individual)it.next()).accept(DefaultRDFAxiomWriter.this.entityResourceWriter));
            return atom;
        }

        @Override
        public Node visit(DifferentIndividuals axiom) {
            if (axiom.size() != 2) {
                throw new IllegalArgumentException("Invalid rule atom: " + String.valueOf(axiom));
            }
            Iterator it = axiom.iterator();
            Object atom = DefaultRDFAxiomWriter.this.factory.createResource();
            DefaultRDFAxiomWriter.this.graph.add(atom, RDFTerm.RDF_type, RDFTerm.SWRL_DifferentIndividualsAtom);
            DefaultRDFAxiomWriter.this.graph.add(atom, RDFTerm.SWRL_argument1, ((Individual)it.next()).accept(DefaultRDFAxiomWriter.this.entityResourceWriter));
            DefaultRDFAxiomWriter.this.graph.add(atom, RDFTerm.SWRL_argument2, ((Individual)it.next()).accept(DefaultRDFAxiomWriter.this.entityResourceWriter));
            return atom;
        }

        @Override
        public Node visit(DatatypeAtom atom) {
            Object result = DefaultRDFAxiomWriter.this.factory.createResource();
            DefaultRDFAxiomWriter.this.graph.add(result, RDFTerm.RDF_type, RDFTerm.SWRL_DataRangeAtom);
            DefaultRDFAxiomWriter.this.graph.add(result, RDFTerm.SWRL_dataRange, atom.getDatatype().accept(DefaultRDFAxiomWriter.this.entityResourceWriter));
            DefaultRDFAxiomWriter.this.graph.add(result, RDFTerm.SWRL_argument1, atom.getLiteral().accept(DefaultRDFAxiomWriter.this.entityNodeWriter));
            return result;
        }

        @Override
        public Node visit(FilterAtom filterAtom) {
            return this.writeFunctionArg(filterAtom.getValue(), null);
        }

        @Override
        public Node visit(BindAtom bindAtom) {
            return this.writeFunctionArg(bindAtom.getValue(), bindAtom.getVar());
        }

        public Node writeFunctionArg(Expression theExpression, Expression var) {
            if (theExpression instanceof Entity) {
                return this.writeFunction(Functions.EQUAL, theExpression, Collections.singleton(var == null ? Literals.TRUE : var));
            }
            FunctionEval functionAtom = (FunctionEval)theExpression;
            return this.writeFunction(functionAtom.getFunction(), var, functionAtom);
        }

        public Node writeFunction(Function function, Expression var, Iterable<Expression> rest) {
            Object resource = DefaultRDFAxiomWriter.this.factory.createResource();
            Iterator args = rest.iterator();
            if (var != null) {
                args = Iterators.concat((Iterator)Iterators.singletonIterator((Object)var), args);
            }
            DefaultRDFAxiomWriter.this.graph.add(resource, RDFTerm.RDF_type, RDFTerm.SWRL_BuiltinAtom);
            DefaultRDFAxiomWriter.this.graph.add(resource, RDFTerm.SWRL_builtin, DefaultRDFAxiomWriter.this.factory.createResource(function.getName()));
            DefaultRDFAxiomWriter.this.graph.add(resource, RDFTerm.SWRL_arguments, DefaultRDFAxiomWriter.this.writeList(args, DefaultRDFAxiomWriter.this.entityNodeWriter));
            return resource;
        }
    };

    private Resource writeRestriction(Restriction term) {
        Resource restr = this.factory.createResource();
        Resource prop = term.getProperty().accept(this.entityResourceWriter);
        this.graph.add(restr, RDFTerm.RDF_type, RDFTerm.OWL_Restriction);
        this.graph.add(restr, RDFTerm.OWL_onProperty, prop);
        return restr;
    }

    private Resource writeRestriction(HasValue term, RDFTerm qualPred) {
        Resource restr = this.writeRestriction(term);
        Node qualification = term.getValue().accept(this.entityNodeWriter);
        this.graph.add(restr, qualPred, qualification);
        return restr;
    }

    private Resource writeRestriction(QualifiedRestriction term, RDFTerm qualPred) {
        Resource restr = this.writeRestriction(term);
        Resource qualification = term.getQualification().accept(this.entityResourceWriter);
        this.graph.add(restr, qualPred, qualification);
        return restr;
    }

    private Resource writeRestriction(QualifiedCardinalityRestriction term, RDFTerm unqualRestrPred, RDFTerm qualRestrPred, RDFTerm qualPred) {
        boolean qualified = !term.getQualification().equals(Classes.THING) && !term.getQualification().equals(Datatypes.LITERAL);
        Resource restr = qualified ? this.writeRestriction(term, qualPred) : this.writeRestriction(term);
        Node cardinality = this.factory.createTypedLiteral(String.valueOf(term.getCardinality()), Datatypes.NON_NEGATIVE_INTEGER.getName());
        this.graph.add(restr, qualified ? qualRestrPred : unqualRestrPred, cardinality);
        return restr;
    }

    private void writeUnary(RDFTerm type, Term subj) {
        this.graph.add(subj.accept(this.entityResourceWriter), RDFTerm.RDF_type, type);
    }

    private Resource writeUnary(RDFTerm type, RDFTerm pred, Term term) {
        Resource result = this.factory.createResource();
        this.graph.add(result, RDFTerm.RDF_type, type);
        this.graph.add(result, pred, term.accept(this.entityResourceWriter));
        return result;
    }

    private void writeTriple(Term subj, RDFTerm pred, Term obj) {
        this.graph.add(subj.accept(this.entityResourceWriter), pred, obj.accept(this.entityResourceWriter));
    }

    private void writeBinaryForEach(RDFTerm pred, Iterable<? extends Term> terms) {
        Iterator<? extends Term> it = terms.iterator();
        if (it.hasNext()) {
            Resource node = it.next().accept(this.entityResourceWriter);
            while (it.hasNext()) {
                this.graph.add(node, pred, it.next().accept(this.entityResourceWriter));
            }
        }
    }

    private void writeBinaryOrNary(RDFTerm type, RDFTerm naryPred, RDFTerm binaryPred, TermCollection<? extends Term> objList) {
        if (objList.size() == 2) {
            Iterator it = objList.iterator();
            this.writeTriple((Term)it.next(), binaryPred, (Term)it.next());
        } else {
            this.writeNary(type, naryPred, objList);
        }
    }

    private Resource writeNary(RDFTerm type, RDFTerm pred, Iterable<? extends Term> objList) {
        return this.writeNary(type, pred, objList, this.entityResourceWriter);
    }

    private Resource writeNary(RDFTerm type, RDFTerm pred, Iterable<? extends Term> objList, TermVisitor<? extends Node> entityWriter) {
        Resource result = this.factory.createResource();
        this.graph.add(result, RDFTerm.RDF_type, type);
        this.graph.add(result, pred, this.writeList(objList, entityWriter));
        return result;
    }

    private Resource writeList(Iterable<? extends Term> terms) {
        return this.writeList(terms, this.entityResourceWriter);
    }

    private Resource writeList(Iterable<? extends Term> terms, TermVisitor<? extends Node> entityWriter) {
        return this.writeList(terms.iterator(), entityWriter);
    }

    private Resource writeList(Iterator<? extends Term> it, TermVisitor<? extends Node> entityWriter) {
        Resource result;
        if (!it.hasNext()) {
            return this.factory.getResource(RDFTerm.RDF_nil);
        }
        Resource list = result = this.factory.createResource();
        while (it.hasNext()) {
            Node first = it.next().accept(entityWriter);
            this.graph.add(list, RDFTerm.RDF_first, first);
            if (it.hasNext()) {
                Resource rest = this.factory.createResource();
                this.graph.add(list, RDFTerm.RDF_rest, rest);
                list = rest;
                continue;
            }
            this.graph.add(list, RDFTerm.RDF_rest, RDFTerm.RDF_nil);
        }
        return result;
    }

    public DefaultRDFAxiomWriter(Options options) {
        this.options = options;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    private boolean isQueryMode() {
        return this.options.is(OntologyWriterOptions.QUERY_MODE);
    }

    private boolean isDeclarationWriteAll() {
        return !this.isQueryMode() && (this.options.get(OntologyWriterOptions.DECLARATION_HANDLING) == OntologyWriterOptions.DeclarationHandling.WRITE_ALL || this.options.get(OntologyWriterOptions.DECLARATION_HANDLING) == OntologyWriterOptions.DeclarationHandling.WRITE_ALL_OWL_THING);
    }

    private RDFTerm getIndividualDeclarationTerm() {
        if (this.isQueryMode()) {
            return null;
        }
        switch ((OntologyWriterOptions.DeclarationHandling)((Object)this.options.get(OntologyWriterOptions.DECLARATION_HANDLING))) {
            case WRITE_ALL: 
            case WRITE_ASSERTED: {
                return RDFTerm.OWL2_NamedIndividual;
            }
            case WRITE_ALL_OWL_THING: {
                return RDFTerm.OWL_Thing;
            }
        }
        return null;
    }

    private Resource writeVar(Variable var) {
        if (this.isQueryMode()) {
            return this.factory.createVariable(var.getName());
        }
        Resource node = null;
        try {
            node = this.factory.createResource(var.getName());
        }
        catch (Exception e) {
            node = this.factory.createResource("urn:var:" + var.getName());
        }
        this.graph.add(node, RDFTerm.RDF_type, RDFTerm.SWRL_Variable);
        return node;
    }

    @Override
    public <N, R extends N, P extends R> void write(Iterable<? extends Term> axioms, RDFOutput<N, R, P> output) {
        this.writeInternal(axioms, output);
    }

    public void writeInternal(Iterable<? extends Term> axioms, RDFOutput<Node, Resource, Predicate> output) {
        this.graph = output;
        this.factory = this.graph.getFactory();
        for (Term term : axioms) {
            term.accept(this.axiomWriter);
        }
    }

    private static List<RuleAtom> flattenRuleAtoms(Iterable<RuleAtom> atoms) {
        FunctionFlattener flattener = new FunctionFlattener();
        for (RuleAtom atom : atoms) {
            atom.accept(flattener);
        }
        return flattener.getAtoms();
    }

    private static class FunctionFlattener
    extends BaseTermVisitorVoid {
        private List<RuleAtom> atoms = Lists.newArrayList();
        private int varCount;

        private FunctionFlattener() {
        }

        public List<RuleAtom> getAtoms() {
            return this.atoms;
        }

        @Override
        protected void defaultVisit(Term term) {
            this.atoms.add((RuleAtom)term);
        }

        @Override
        public void visit(FilterAtom filterAtom) {
            if (filterAtom.getValue() instanceof FunctionEval) {
                FunctionEval functionEval = (FunctionEval)filterAtom.getValue();
                if (functionEval.getFunction().equals(Functions.AND)) {
                    for (Expression aExpression : functionEval.getArgs()) {
                        this.flattenFunction((FunctionEval)aExpression);
                    }
                    return;
                }
                this.flattenFunction(functionEval);
            }
        }

        @Override
        public void visit(BindAtom bindAtom) {
            if (bindAtom.getValue() instanceof FunctionEval) {
                FunctionEval eval = (FunctionEval)bindAtom.getValue();
                this.flattenFunction(TermFactory.functionEval(eval.getFunction(), Iterables.concat(Collections.singleton(bindAtom.getVar()), (Iterable)eval.getArgs())));
            }
        }

        public void flattenFunction(FunctionEval functionAtom) {
            ArrayList args = Lists.newArrayList();
            for (Expression aExpression : functionAtom) {
                if (aExpression instanceof FunctionEval) {
                    FunctionEval eval = (FunctionEval)aExpression;
                    DatatypeVariable newVar = TermFactory.datatypeVariable("auto" + this.varCount++);
                    args.add(newVar);
                    this.flattenFunction(TermFactory.functionEval(eval.getFunction(), Iterables.concat(Collections.singleton(newVar), (Iterable)eval.getArgs())));
                    continue;
                }
                args.add(aExpression);
            }
            this.atoms.add(TermFactory.filter(TermFactory.functionEval(functionAtom.getFunction(), (Expression[])Iterables.toArray((Iterable)args, Expression.class))));
        }
    }
}

