/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rdf;

import com.clarkparsia.pellet.api.io.OntologyReaderOptions;
import com.clarkparsia.pellet.api.kb.KnowledgeBase;
import com.clarkparsia.pellet.api.term.Term;
import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.axiom.AnnotationEntity;
import com.clarkparsia.pellet.api.term.axiom.AnnotationValue;
import com.clarkparsia.pellet.api.term.axiom.Axiom;
import com.clarkparsia.pellet.api.term.axiom.Declaration;
import com.clarkparsia.pellet.api.term.axiom.NegativePropertyAssertion;
import com.clarkparsia.pellet.api.term.axiom.UnaryPropertyAxiom;
import com.clarkparsia.pellet.api.term.builtins.AnnotationProperties;
import com.clarkparsia.pellet.api.term.builtins.Classes;
import com.clarkparsia.pellet.api.term.builtins.DataProperties;
import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.api.term.builtins.Facets;
import com.clarkparsia.pellet.api.term.builtins.Functions;
import com.clarkparsia.pellet.api.term.builtins.Literals;
import com.clarkparsia.pellet.api.term.builtins.ObjectProperties;
import com.clarkparsia.pellet.api.term.builtins.SWRLFunctions;
import com.clarkparsia.pellet.api.term.entity.AnnotationProperty;
import com.clarkparsia.pellet.api.term.entity.AnonIndividual;
import com.clarkparsia.pellet.api.term.entity.ClassExpression;
import com.clarkparsia.pellet.api.term.entity.ClassVariable;
import com.clarkparsia.pellet.api.term.entity.DataProperty;
import com.clarkparsia.pellet.api.term.entity.Datatype;
import com.clarkparsia.pellet.api.term.entity.Entity;
import com.clarkparsia.pellet.api.term.entity.FacetRestriction;
import com.clarkparsia.pellet.api.term.entity.Individual;
import com.clarkparsia.pellet.api.term.entity.LiteralValue;
import com.clarkparsia.pellet.api.term.entity.NamedAnnotationProperty;
import com.clarkparsia.pellet.api.term.entity.NamedClass;
import com.clarkparsia.pellet.api.term.entity.NamedDataProperty;
import com.clarkparsia.pellet.api.term.entity.NamedDatatype;
import com.clarkparsia.pellet.api.term.entity.NamedEntity;
import com.clarkparsia.pellet.api.term.entity.NamedObjectProperty;
import com.clarkparsia.pellet.api.term.entity.ObjectProperty;
import com.clarkparsia.pellet.api.term.entity.Property;
import com.clarkparsia.pellet.api.term.entity.Type;
import com.clarkparsia.pellet.api.term.entity.Variable;
import com.clarkparsia.pellet.api.term.rule.Rule;
import com.clarkparsia.pellet.api.term.rule.RuleAtom;
import com.clarkparsia.pellet.rdf.RDFAxiomHandler;
import com.clarkparsia.pellet.rdf.RDFAxiomReader;
import com.clarkparsia.pellet.rdf.RDFAxiomReaderOptions;
import com.clarkparsia.pellet.rdf.RDFFactory;
import com.clarkparsia.pellet.rdf.RDFInput;
import com.clarkparsia.pellet.rdf.RDFParseException;
import com.clarkparsia.pellet.rdf.RDFTerm;
import com.clarkparsia.pellet.rdf.RDFTerms;
import com.clarkparsia.pellet.util.progress.ProgressMonitor;
import com.complexible.common.base.Bool;
import com.complexible.common.base.Options;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRDFAxiomReader<Graph, Triple, Node, Resource extends Node, Predicate extends Resource, ClosableIterator extends Iterator<Triple>>
implements RDFAxiomReader {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DefaultRDFAxiomReader.class);
    protected RDFFactory<Triple, Node, Resource, Predicate> factory;
    protected RDFInput<Triple, Node, Resource, Predicate, ClosableIterator> graph;
    protected RDFAxiomHandler handler;
    protected Set<Resource> ontologies;
    protected Set<Resource> anonDatatypes;
    protected Set<Resource> functionalProperties;
    protected Set<Resource> inverseFunctionalProperties;
    protected Map<Node, RDFTerm> naryDisjoints;
    protected ProgressMonitor monitor;
    CachingTermCreator<Individual> individuals = new CachingTermCreator<Individual>(){

        @Override
        public Individual createTerm(Node node) {
            if (DefaultRDFAxiomReader.this.factory.isLiteral(node)) {
                throw new RDFParseException("Expecting an individual, but found literal: " + String.valueOf(node));
            }
            if (DefaultRDFAxiomReader.this.factory.isBlank(node)) {
                return TermFactory.anonymousIndividual(DefaultRDFAxiomReader.this.factory.getLabel(node));
            }
            return TermFactory.namedIndividual(DefaultRDFAxiomReader.this.factory.getLabel(node));
        }

        @Override
        public Individual createVar(Node node) {
            return TermFactory.individualVariable(DefaultRDFAxiomReader.this.factory.getLabel(node));
        }
    };
    CachingTermCreator<ObjectProperty> objectProperties = new CachingTermCreator<ObjectProperty>(){

        @Override
        public Set<NamedObjectProperty> getBuiltIns() {
            return ObjectProperties.getBuiltIns();
        }

        @Override
        protected Function<ObjectProperty, Node> getBuiltInMapper() {
            return new Function<ObjectProperty, Node>(){

                public Node apply(ObjectProperty p) {
                    return DefaultRDFAxiomReader.this.factory.createPredicate(((NamedObjectProperty)p).getName());
                }
            };
        }

        @Override
        public ObjectProperty createTerm(Node n) {
            Object node = DefaultRDFAxiomReader.this.mustBeResource(n);
            if (!DefaultRDFAxiomReader.this.factory.isBlank(node)) {
                return TermFactory.namedObjectProperty(DefaultRDFAxiomReader.this.factory.getLabel(node));
            }
            Object expr = DefaultRDFAxiomReader.this.getExpression(node);
            if (expr != null) {
                Object exprType = DefaultRDFAxiomReader.this.factory.getTriplePredicate(expr);
                Object exprValue = DefaultRDFAxiomReader.this.factory.getTripleObject(expr);
                if (exprType.equals(DefaultRDFAxiomReader.this.factory.getResource(RDFTerm.OWL_inverseOf))) {
                    ObjectProperty p = (ObjectProperty)this.assume(exprValue);
                    return p.inverse();
                }
            }
            throw new UnsupportedOperationException("Expecting an object property, found:" + String.valueOf(node));
        }

        @Override
        public ObjectProperty createVar(Node node) {
            return TermFactory.objectPropertyVariable(DefaultRDFAxiomReader.this.factory.getLabel(node));
        }
    };
    CachingTermCreator<DataProperty> dataProperties = new CachingTermCreator<DataProperty>(){

        @Override
        public Set<NamedDataProperty> getBuiltIns() {
            return DataProperties.getBuiltIns();
        }

        @Override
        protected Function<DataProperty, Node> getBuiltInMapper() {
            return new Function<DataProperty, Node>(){

                public Node apply(DataProperty p) {
                    return DefaultRDFAxiomReader.this.factory.createPredicate(((NamedDataProperty)p).getName());
                }
            };
        }

        @Override
        public DataProperty createTerm(Node node) {
            if (DefaultRDFAxiomReader.this.factory.isURI(node)) {
                return TermFactory.namedDataProperty(DefaultRDFAxiomReader.this.factory.getLabel(node));
            }
            throw new UnsupportedOperationException("Expecting a data property, found:" + String.valueOf(node));
        }

        @Override
        public DataProperty createVar(Node node) {
            return TermFactory.dataPropertyVariable(DefaultRDFAxiomReader.this.factory.getLabel(node));
        }
    };
    CachingTermCreator<AnnotationProperty> annotationProperties = new CachingTermCreator<AnnotationProperty>(){

        @Override
        public Set<NamedAnnotationProperty> getBuiltIns() {
            return AnnotationProperties.getBuiltIns();
        }

        @Override
        protected Function<AnnotationProperty, Node> getBuiltInMapper() {
            return new Function<AnnotationProperty, Node>(){

                public Node apply(AnnotationProperty p) {
                    return DefaultRDFAxiomReader.this.factory.createPredicate(((NamedAnnotationProperty)p).getName());
                }
            };
        }

        @Override
        public AnnotationProperty createTerm(Node node) {
            if (DefaultRDFAxiomReader.this.factory.isBlank(node) || DefaultRDFAxiomReader.this.factory.isLiteral(node)) {
                throw new UnsupportedOperationException("Expecting an annotation property, found:" + String.valueOf(node));
            }
            return TermFactory.namedAnnotationProperty(DefaultRDFAxiomReader.this.factory.getLabel(node));
        }

        @Override
        public AnnotationProperty createVar(Node node) {
            return TermFactory.annotationPropertyVariable(DefaultRDFAxiomReader.this.factory.getLabel(node));
        }
    };
    TermCreator<LiteralValue> literals = new TermCreator<LiteralValue>(){

        @Override
        public LiteralValue createSWRL(Node node) {
            if (!DefaultRDFAxiomReader.this.factory.isLiteral(node)) {
                return this.createVar(node);
            }
            return (LiteralValue)this.create(node);
        }

        @Override
        public LiteralValue createTerm(Node node) {
            if (DefaultRDFAxiomReader.this.factory.isLiteral(node)) {
                String lexicalForm = DefaultRDFAxiomReader.this.factory.getLabel(node);
                String language = DefaultRDFAxiomReader.this.factory.getLiteralLanguage(node);
                String datatypeURI = DefaultRDFAxiomReader.this.factory.getLiteralDatatype(node);
                if (language != null) {
                    return TermFactory.literal(lexicalForm, language);
                }
                if (datatypeURI != null) {
                    NamedDatatype datatype = Datatypes.get(datatypeURI);
                    if (datatype == null) {
                        datatype = TermFactory.namedDatatype(datatypeURI);
                    } else if (datatype.equals(Datatypes.NORMALIZED_STRING)) {
                        lexicalForm = lexicalForm.replaceAll("\\t|\\n|\\r", " ");
                    } else if (!datatype.equals(Datatypes.STRING)) {
                        lexicalForm = lexicalForm.trim();
                    }
                    return TermFactory.literal(lexicalForm, datatype);
                }
                return TermFactory.literal(lexicalForm);
            }
            throw new UnsupportedOperationException("Expecting a literal, found:" + String.valueOf(node));
        }

        @Override
        public LiteralValue createVar(Node node) {
            return TermFactory.literalVariable(DefaultRDFAxiomReader.this.factory.getLabel(node));
        }
    };
    CachingTermCreator<ClassExpression> classes = new CachingTermCreator<ClassExpression>(){

        @Override
        public Set<NamedClass> getBuiltIns() {
            return Classes.getBuiltIns();
        }

        @Override
        protected Function<ClassExpression, Node> getBuiltInMapper() {
            return new Function<ClassExpression, Node>(){

                public Node apply(ClassExpression p) {
                    return DefaultRDFAxiomReader.this.factory.createResource(((NamedClass)p).getName());
                }
            };
        }

        @Override
        public ClassExpression createTerm(Node n) {
            Object node = DefaultRDFAxiomReader.this.mustBeResource(n);
            if (DefaultRDFAxiomReader.this.isRestriction(node)) {
                return DefaultRDFAxiomReader.this.createRestriction(node);
            }
            if (DefaultRDFAxiomReader.this.factory.isBlank(node)) {
                Object expr = DefaultRDFAxiomReader.this.getExpression(node);
                if (expr != null) {
                    Object exprPred = DefaultRDFAxiomReader.this.factory.getTriplePredicate(expr);
                    Object exprValue = DefaultRDFAxiomReader.this.mustBeResource(DefaultRDFAxiomReader.this.factory.getTripleObject(expr));
                    RDFTerm builtin = DefaultRDFAxiomReader.this.factory.getTerm(exprPred);
                    switch (builtin) {
                        case OWL_intersectionOf: {
                            Set classes = this.createSet(exprValue);
                            return TermFactory.and(classes);
                        }
                        case OWL_unionOf: {
                            Set classes = this.createSet(exprValue);
                            return TermFactory.or(classes);
                        }
                        case OWL_complementOf: {
                            ClassExpression complement = (ClassExpression)this.create(exprValue);
                            return TermFactory.not(complement);
                        }
                        case OWL_oneOf: {
                            Set inds = DefaultRDFAxiomReader.this.individuals.createSet(exprValue);
                            return TermFactory.oneOf(inds);
                        }
                    }
                }
                throw new RDFParseException("Not a valid class expression:  " + String.valueOf(node));
            }
            return TermFactory.namedClass(DefaultRDFAxiomReader.this.factory.getLabel(node));
        }

        @Override
        public ClassVariable createVar(Node node) {
            return TermFactory.classVariable(DefaultRDFAxiomReader.this.factory.getLabel(node));
        }
    };
    TermCreator<FacetRestriction> facetRestrictionCreator = new TermCreator<FacetRestriction>(){

        @Override
        public FacetRestriction createTerm(Node n) {
            Object node = DefaultRDFAxiomReader.this.mustBeResource(n);
            for (RDFTerm facet : RDFTerms.FACETS) {
                Object facetValue = DefaultRDFAxiomReader.this.graph.getObject(node, facet);
                if (facetValue == null) continue;
                LiteralValue literal = DefaultRDFAxiomReader.this.literals.create(facetValue);
                return TermFactory.facetRestriction(Facets.get(facet.getURI()), literal);
            }
            throw new RDFParseException("Expecting facet, but found:  " + String.valueOf(node));
        }
    };
    CachingTermCreator<Datatype> datatypes = new CachingTermCreator<Datatype>(){

        @Override
        public Datatype get(Node node) {
            NamedDatatype datatype = Datatypes.get(DefaultRDFAxiomReader.this.factory.getLabel(node));
            return datatype != null ? datatype : (Datatype)super.get(node);
        }

        @Override
        public Datatype createTerm(Node n) {
            Object node = DefaultRDFAxiomReader.this.mustBeResource(n);
            if (DefaultRDFAxiomReader.this.factory.isBlank(node)) {
                Object expr = DefaultRDFAxiomReader.this.getExpression(node);
                if (expr != null) {
                    Object exprPred = DefaultRDFAxiomReader.this.factory.getTriplePredicate(expr);
                    Object exprValue = DefaultRDFAxiomReader.this.mustBeResource(DefaultRDFAxiomReader.this.factory.getTripleObject(expr));
                    RDFTerm builtin = DefaultRDFAxiomReader.this.factory.getTerm(exprPred);
                    switch (builtin) {
                        case OWL_intersectionOf: {
                            Set classes = this.createSet(exprValue);
                            return TermFactory.dataAnd(classes);
                        }
                        case OWL_unionOf: {
                            Set classes = this.createSet(exprValue);
                            return TermFactory.dataOr(classes);
                        }
                        case OWL2_datatypeComplementOf: {
                            Datatype complement = (Datatype)this.create(exprValue);
                            return TermFactory.dataNot(complement);
                        }
                        case OWL_oneOf: {
                            Set<LiteralValue> individuals = DefaultRDFAxiomReader.this.literals.createSet(exprValue);
                            return TermFactory.dataOneOf(individuals);
                        }
                        case OWL2_onDatatype: {
                            if (!DefaultRDFAxiomReader.this.factory.isURI(exprValue)) {
                                throw new RDFParseException("Invalid datatype definition, expected URI but found " + String.valueOf(exprValue));
                            }
                            NamedDatatype baseDatatype = TermFactory.namedDatatype(DefaultRDFAxiomReader.this.factory.getLabel(exprValue));
                            Object list = DefaultRDFAxiomReader.this.mustBeResource(DefaultRDFAxiomReader.this.graph.getObject(node, RDFTerm.OWL2_withRestrictions));
                            List<FacetRestriction> restrictions = DefaultRDFAxiomReader.this.facetRestrictionCreator.createList(list);
                            if (restrictions.isEmpty()) {
                                throw new RDFParseException("A data range is defined without facet restrictions " + String.valueOf(node));
                            }
                            return TermFactory.restrict(baseDatatype, restrictions);
                        }
                    }
                    throw new RDFParseException("Unrecognized datatype expression:  " + String.valueOf(expr));
                }
                throw new RDFParseException("Blank node is not a valid datatype expression:  " + String.valueOf(node));
            }
            return TermFactory.namedDatatype(DefaultRDFAxiomReader.this.factory.getLabel(node));
        }

        @Override
        public Datatype createVar(Node node) {
            return TermFactory.datatypeVariable(DefaultRDFAxiomReader.this.factory.getLabel(node));
        }
    };
    TermCreator<Rule> rules = new TermCreator<Rule>(){

        @Override
        public Rule createTerm(Node n) {
            Object node = DefaultRDFAxiomReader.this.mustBeResource(n);
            Object headNode = DefaultRDFAxiomReader.this.graph.getRequiredObject(node, RDFTerm.SWRL_head);
            Set<RuleAtom> head = DefaultRDFAxiomReader.this.ruleAtomCreator.createSet(DefaultRDFAxiomReader.this.mustBeResource(headNode));
            Object bodyNode = DefaultRDFAxiomReader.this.graph.getRequiredObject(node, RDFTerm.SWRL_body);
            Set<RuleAtom> body = DefaultRDFAxiomReader.this.ruleAtomCreator.createSet(DefaultRDFAxiomReader.this.mustBeResource(bodyNode));
            return TermFactory.rule(TermFactory.termSet(head), TermFactory.ruleAtoms(body));
        }
    };
    TermCreator<RuleAtom> ruleAtomCreator = new TermCreator<RuleAtom>(){

        @Override
        public RuleAtom createTerm(Node n) {
            Object node = DefaultRDFAxiomReader.this.mustBeResource(n);
            Object type = DefaultRDFAxiomReader.this.graph.getObject(node, RDFTerm.RDF_type);
            RDFTerm term = DefaultRDFAxiomReader.this.factory.getTerm(type);
            switch (term) {
                case SWRL_ClassAtom: {
                    Object classNode = DefaultRDFAxiomReader.this.graph.getRequiredObject(node, RDFTerm.SWRL_classPredicate);
                    ClassExpression ce = DefaultRDFAxiomReader.this.classes.create(classNode);
                    Object argNode = DefaultRDFAxiomReader.this.graph.getRequiredObject(node, RDFTerm.SWRL_argument1);
                    Individual ind = (Individual)DefaultRDFAxiomReader.this.individuals.createSWRL(argNode);
                    return ind.type(ce);
                }
                case SWRL_IndividualPropertyAtom: {
                    Object predNode = DefaultRDFAxiomReader.this.graph.getRequiredObject(node, RDFTerm.SWRL_propertyPredicate);
                    ObjectProperty p = DefaultRDFAxiomReader.this.objectProperties.create(predNode);
                    Object argNode1 = DefaultRDFAxiomReader.this.graph.getRequiredObject(node, RDFTerm.SWRL_argument1);
                    Individual ind1 = (Individual)DefaultRDFAxiomReader.this.individuals.createSWRL(argNode1);
                    Object argNode2 = DefaultRDFAxiomReader.this.graph.getRequiredObject(node, RDFTerm.SWRL_argument2);
                    Individual ind2 = (Individual)DefaultRDFAxiomReader.this.individuals.createSWRL(argNode2);
                    return ind1.fact(p, ind2);
                }
                case SWRL_DifferentIndividualsAtom: {
                    Object argNode1 = DefaultRDFAxiomReader.this.graph.getRequiredObject(node, RDFTerm.SWRL_argument1);
                    Individual ind1 = (Individual)DefaultRDFAxiomReader.this.individuals.createSWRL(argNode1);
                    Object argNode2 = DefaultRDFAxiomReader.this.graph.getRequiredObject(node, RDFTerm.SWRL_argument2);
                    Individual ind2 = (Individual)DefaultRDFAxiomReader.this.individuals.createSWRL(argNode2);
                    return ind1.differentFrom(ind2);
                }
                case SWRL_SameIndividualAtom: {
                    Object argNode1 = DefaultRDFAxiomReader.this.graph.getRequiredObject(node, RDFTerm.SWRL_argument1);
                    Individual ind1 = (Individual)DefaultRDFAxiomReader.this.individuals.createSWRL(argNode1);
                    Object argNode2 = DefaultRDFAxiomReader.this.graph.getRequiredObject(node, RDFTerm.SWRL_argument2);
                    Individual ind2 = (Individual)DefaultRDFAxiomReader.this.individuals.createSWRL(argNode2);
                    return ind1.sameAs(ind2);
                }
                case SWRL_DatavaluedPropertyAtom: {
                    Object predNode = DefaultRDFAxiomReader.this.graph.getRequiredObject(node, RDFTerm.SWRL_propertyPredicate);
                    DataProperty p = DefaultRDFAxiomReader.this.dataProperties.create(predNode);
                    Object argNode1 = DefaultRDFAxiomReader.this.graph.getRequiredObject(node, RDFTerm.SWRL_argument1);
                    Individual ind1 = (Individual)DefaultRDFAxiomReader.this.individuals.createSWRL(argNode1);
                    Object argNode2 = DefaultRDFAxiomReader.this.graph.getRequiredObject(node, RDFTerm.SWRL_argument2);
                    LiteralValue ind2 = DefaultRDFAxiomReader.this.literals.createSWRL(argNode2);
                    return ind1.fact(p, ind2);
                }
                case SWRL_BuiltinAtom: {
                    Object functionNode = DefaultRDFAxiomReader.this.graph.getRequiredObject(node, RDFTerm.SWRL_builtin);
                    String functionName = DefaultRDFAxiomReader.this.factory.getLabel(functionNode);
                    com.clarkparsia.pellet.api.term.function.Function function = Functions.get(functionName);
                    boolean booleanFunction = SWRLFunctions.BOOLEAN_FUNCTIONS.contains(function);
                    Entity bindVar = null;
                    Object argsNode = DefaultRDFAxiomReader.this.graph.getRequiredObject(node, RDFTerm.SWRL_arguments);
                    ArrayList args = Lists.newArrayList();
                    RDFListIterator list = new RDFListIterator(DefaultRDFAxiomReader.this.mustBeResource(argsNode));
                    if (!booleanFunction && list.hasNext()) {
                        bindVar = DefaultRDFAxiomReader.this.literals.createSWRL(list.next());
                    }
                    while (list.hasNext()) {
                        args.add(DefaultRDFAxiomReader.this.literals.createSWRL(list.next()));
                    }
                    if (function == null) {
                        function = TermFactory.function(functionName, args.size());
                    }
                    return bindVar == null ? TermFactory.filter(TermFactory.functionEval(function, args)) : (bindVar.isVariable() ? TermFactory.bind(function.eval(args), (Variable)bindVar) : TermFactory.filter(Functions.EQUAL.eval(bindVar, function.eval(args))));
                }
                case SWRL_DataRangeAtom: {
                    Object datatypeNode = DefaultRDFAxiomReader.this.graph.getRequiredObject(node, RDFTerm.SWRL_dataRange);
                    Datatype dt = DefaultRDFAxiomReader.this.datatypes.create(datatypeNode);
                    Object argNode1 = DefaultRDFAxiomReader.this.graph.getRequiredObject(node, RDFTerm.SWRL_argument1);
                    LiteralValue lit = DefaultRDFAxiomReader.this.literals.createSWRL(argNode1);
                    return TermFactory.datatypeAtom(dt, lit);
                }
            }
            throw new RDFParseException("Invalid SWRL atom " + String.valueOf(node));
        }
    };
    TermCreator<NegativePropertyAssertion> negativePropertyAssertions = new TermCreator<NegativePropertyAssertion>(){

        @Override
        public NegativePropertyAssertion createTerm(Node n) {
            Object node = DefaultRDFAxiomReader.this.mustBeResource(n);
            Object s = DefaultRDFAxiomReader.this.graph.getRequiredObject(node, RDFTerm.OWL2_sourceIndividual);
            Object p = DefaultRDFAxiomReader.this.graph.getRequiredObject(node, RDFTerm.OWL2_assertionProperty);
            Object oi = DefaultRDFAxiomReader.this.graph.getObject(node, RDFTerm.OWL2_targetIndividual);
            Object ov = DefaultRDFAxiomReader.this.graph.getObject(node, RDFTerm.OWL2_targetValue);
            Individual subj = (Individual)DefaultRDFAxiomReader.this.individuals.assume(s);
            if (oi != null) {
                if (ov != null) {
                    throw new RDFParseException("Negated property value must not have both owl:targetIndividual and owl:targetValue value");
                }
                ObjectProperty pred = (ObjectProperty)DefaultRDFAxiomReader.this.objectProperties.assume(p);
                Individual obj = (Individual)DefaultRDFAxiomReader.this.individuals.assume(oi);
                return subj.notFact(pred, obj);
            }
            if (ov != null) {
                DataProperty pred = (DataProperty)DefaultRDFAxiomReader.this.dataProperties.assume(p);
                LiteralValue obj = DefaultRDFAxiomReader.this.literals.create(ov);
                return subj.notFact(pred, obj);
            }
            throw new RDFParseException("Negated property value is missing owl:targetIndividual or owl:targetValue value");
        }
    };
    TermCreator<AnnotationEntity> annotationEntities = new TermCreator<AnnotationEntity>(){

        @Override
        public AnnotationEntity createTerm(Node node) {
            if (DefaultRDFAxiomReader.this.factory.isLiteral(node)) {
                return (AnnotationEntity)((Object)DefaultRDFAxiomReader.this.literals.create(node));
            }
            if (DefaultRDFAxiomReader.this.factory.isBlank(node)) {
                return TermFactory.anonymousIndividual(DefaultRDFAxiomReader.this.factory.getLabel(node));
            }
            if (DefaultRDFAxiomReader.this.factory.isVariable(node)) {
                return TermFactory.annotationEntityVariable(DefaultRDFAxiomReader.this.factory.getLabel(node));
            }
            return TermFactory.namedAnnotationEntity(DefaultRDFAxiomReader.this.factory.getLabel(node));
        }
    };
    private final Options options;
    private final List<CachingTermCreator<? extends Property>> propertyCreators = ImmutableList.of(this.objectProperties, this.dataProperties, this.annotationProperties);
    private final List<CachingTermCreator<?>> entityCreators = ImmutableList.of(this.individuals, this.classes, this.objectProperties, this.dataProperties, this.annotationProperties, this.datatypes);
    private final KnowledgeBase kb;

    public DefaultRDFAxiomReader(Options options, KnowledgeBase kb) {
        this.options = options;
        this.kb = kb;
    }

    protected ClassExpression createRestriction(Resource node) {
        RDFTerm restrictionType = null;
        Node p = null;
        Node filler = null;
        Node qualification = null;
        Bool isObjectRestriction = Bool.UNKNOWN;
        ClosableIterator i = this.graph.find(node, (Object)null, (Object)null);
        while (i.hasNext()) {
            this.monitor.incrementProgress();
            Object t = i.next();
            Predicate pred = this.factory.getTriplePredicate(t);
            RDFTerm builtinTerm = this.factory.getTerm(pred);
            if (builtinTerm == null) continue;
            switch (builtinTerm) {
                case OWL_someValuesFrom: 
                case OWL_allValuesFrom: 
                case OWL_cardinality: 
                case OWL_minCardinality: 
                case OWL_maxCardinality: 
                case OWL_hasValue: 
                case OWL2_hasSelf: 
                case OWL2_qualifiedCardinality: 
                case OWL2_minQualifiedCardinality: 
                case OWL2_maxQualifiedCardinality: {
                    restrictionType = builtinTerm;
                    filler = this.factory.getTripleObject(t);
                    break;
                }
                case OWL_onProperty: {
                    if (p != null) {
                        LOGGER.warn("Multiple owl:onProperty values for {} [{}, {}]", new Object[]{node, this.factory.getTripleObject(t), p});
                    }
                    p = this.factory.getTripleObject(t);
                    break;
                }
                case RDF_type: {
                    break;
                }
                case OWL2_onClass: {
                    isObjectRestriction = Bool.TRUE;
                    qualification = this.factory.getTripleObject(t);
                    break;
                }
                case OWL2_onDataRange: {
                    isObjectRestriction = Bool.FALSE;
                    qualification = this.factory.getTripleObject(t);
                    break;
                }
            }
        }
        this.graph.close(i);
        return this.createRestriction(restrictionType, p, filler, qualification, isObjectRestriction);
    }

    protected ClassExpression createRestriction(RDFTerm restrictionType, Node p, Node filler, Node qualification, Bool isObjectRestriction) {
        if (restrictionType == null || filler == null) {
            throw new RDFParseException("Invalid restriction on property " + String.valueOf(p));
        }
        Property prop = this.getProperty(p);
        switch (restrictionType) {
            case OWL2_hasSelf: {
                LiteralValue ot = this.literals.create(filler);
                if (!ot.equals(Literals.TRUE)) {
                    throw new RDFParseException("Invalid value for hasSelf restriction: " + String.valueOf(filler));
                }
                if (prop == null) {
                    return ((ObjectProperty)this.objectProperties.assume(p)).self();
                }
                if (prop instanceof ObjectProperty) {
                    return ((ObjectProperty)prop).self();
                }
                if (prop instanceof DataProperty) {
                    throw new RDFParseException("HasSelf restriction not allowed for data properties " + String.valueOf(p));
                }
                throw new RDFParseException("HasSelf restriction not allowed for annotation properties " + String.valueOf(p));
            }
            case OWL_hasValue: {
                if (prop == null) {
                    if (this.factory.isLiteral(filler)) {
                        DataProperty pt = (DataProperty)this.dataProperties.assume(p);
                        LiteralValue ot = this.literals.create(filler);
                        return pt.value(ot);
                    }
                    ObjectProperty pt = (ObjectProperty)this.objectProperties.assume(p);
                    Individual ot = (Individual)this.individuals.assume(filler);
                    return pt.value(ot);
                }
                if (prop instanceof ObjectProperty) {
                    return ((ObjectProperty)prop).value((Individual)this.individuals.assume(filler));
                }
                if (prop instanceof DataProperty) {
                    return ((DataProperty)prop).value(this.literals.create(filler));
                }
                throw new RDFParseException("HasValue restriction not allowed for annotation properties " + String.valueOf(p));
            }
            case OWL_allValuesFrom: {
                if (prop == null) {
                    Datatype dt = this.datatypes.get(filler);
                    if (dt != null) {
                        return ((DataProperty)this.dataProperties.assume(p)).only(dt);
                    }
                    return ((ObjectProperty)this.objectProperties.assume(p)).only((ClassExpression)this.classes.assume(filler));
                }
                if (prop instanceof ObjectProperty) {
                    return ((ObjectProperty)prop).only((ClassExpression)this.classes.assume(filler));
                }
                if (prop instanceof DataProperty) {
                    return ((DataProperty)prop).only((Datatype)this.datatypes.assume(filler));
                }
                throw new RDFParseException("AllValuesFrom restriction not allowed for annotation properties " + String.valueOf(p));
            }
            case OWL_someValuesFrom: {
                if (prop == null) {
                    Datatype dt = this.datatypes.get(filler);
                    if (dt != null) {
                        return ((DataProperty)this.dataProperties.assume(p)).some(dt);
                    }
                    return ((ObjectProperty)this.objectProperties.assume(p)).some((ClassExpression)this.classes.assume(filler));
                }
                if (prop instanceof ObjectProperty) {
                    return ((ObjectProperty)prop).some((ClassExpression)this.classes.assume(filler));
                }
                if (prop instanceof DataProperty) {
                    return ((DataProperty)prop).some((Datatype)this.datatypes.assume(filler));
                }
                throw new RDFParseException("SomeValuesFrom restriction not allowed for annotation properties " + String.valueOf(p));
            }
            case OWL_minCardinality: {
                int cardinality = this.parseCardinality(filler);
                if (prop == null) {
                    return ((ObjectProperty)this.objectProperties.assume(p)).min(cardinality);
                }
                if (prop instanceof ObjectProperty) {
                    return ((ObjectProperty)prop).min(cardinality);
                }
                if (prop instanceof DataProperty) {
                    return ((DataProperty)prop).min(cardinality);
                }
                throw new RDFParseException("Cardinality axiom not allowed for annotation properties " + String.valueOf(p));
            }
            case OWL_maxCardinality: {
                int cardinality = this.parseCardinality(filler);
                if (prop == null) {
                    return ((ObjectProperty)this.objectProperties.assume(p)).max(cardinality);
                }
                if (prop instanceof ObjectProperty) {
                    return ((ObjectProperty)prop).max(cardinality);
                }
                if (prop instanceof DataProperty) {
                    return ((DataProperty)prop).max(cardinality);
                }
                throw new RDFParseException("Cardinality axiom not allowed for annotation properties " + String.valueOf(p));
            }
            case OWL_cardinality: {
                int cardinality = this.parseCardinality(filler);
                if (prop == null) {
                    return ((ObjectProperty)this.objectProperties.assume(p)).exactly(cardinality);
                }
                if (prop instanceof ObjectProperty) {
                    return ((ObjectProperty)prop).exactly(cardinality);
                }
                if (prop instanceof DataProperty) {
                    return ((DataProperty)prop).exactly(cardinality);
                }
                throw new RDFParseException("Cardinality axiom not allowed for annotation properties " + String.valueOf(p));
            }
            case OWL2_minQualifiedCardinality: {
                int cardinality = this.parseCardinality(filler);
                if (isObjectRestriction.isTrue()) {
                    return ((ObjectProperty)this.objectProperties.assume(p)).min(cardinality, (ClassExpression)this.classes.assume(qualification));
                }
                if (isObjectRestriction.isFalse()) {
                    return ((DataProperty)this.dataProperties.assume(p)).min(cardinality, (Datatype)this.datatypes.assume(qualification));
                }
                throw new RDFParseException("Invalid qualified cardinality restriction");
            }
            case OWL2_maxQualifiedCardinality: {
                int cardinality = this.parseCardinality(filler);
                if (isObjectRestriction.isTrue()) {
                    return ((ObjectProperty)this.objectProperties.assume(p)).max(cardinality, (ClassExpression)this.classes.assume(qualification));
                }
                if (isObjectRestriction.isFalse()) {
                    return ((DataProperty)this.dataProperties.assume(p)).max(cardinality, (Datatype)this.datatypes.assume(qualification));
                }
                throw new RDFParseException("Invalid qualified cardinality restriction");
            }
            case OWL2_qualifiedCardinality: {
                int cardinality = this.parseCardinality(filler);
                if (isObjectRestriction.isTrue()) {
                    return ((ObjectProperty)this.objectProperties.assume(p)).exactly(cardinality, (ClassExpression)this.classes.assume(qualification));
                }
                if (isObjectRestriction.isFalse()) {
                    return ((DataProperty)this.dataProperties.assume(p)).exactly(cardinality, (Datatype)this.datatypes.assume(qualification));
                }
                throw new RDFParseException("Invalid qualified cardinality restriction");
            }
        }
        throw new RDFParseException("Invalid restriction on property " + String.valueOf(p));
    }

    Resource mustBeResource(Node node) {
        try {
            return (Resource)node;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected literal: " + String.valueOf(node));
        }
    }

    int parseCardinality(Node node) {
        if (!this.factory.isLiteral(node)) {
            throw new RDFParseException("Expecting cardinality value but found: " + String.valueOf(node));
        }
        try {
            int cardinality = Integer.parseInt(this.factory.getLabel(node).trim());
            if (cardinality < 0) {
                throw new RDFParseException("Negative cardinality value is invalid: " + cardinality);
            }
            return cardinality;
        }
        catch (NumberFormatException e) {
            throw new RDFParseException("Expecting cardinality value but found: " + String.valueOf(node));
        }
    }

    protected Entity getEntity(Node node) {
        for (CachingTermCreator<?> entityCreator : this.entityCreators) {
            Object obj = entityCreator.get(node);
            if (obj == null) continue;
            if (!(obj instanceof Entity)) {
                throw new RDFParseException("Expecting an entity but found: " + String.valueOf(obj.getClass()) + " " + String.valueOf(obj));
            }
            return (Entity)obj;
        }
        return null;
    }

    protected Triple getExpression(Resource node) {
        for (RDFTerm expressionPredicate : RDFTerms.EXPRESSIONS) {
            ClosableIterator i = this.graph.find(node, expressionPredicate, null);
            if (!i.hasNext()) continue;
            this.monitor.incrementProgress();
            Object t = i.next();
            this.graph.close(i);
            return (Triple)t;
        }
        return null;
    }

    protected Node getFirst(Resource list) {
        return this.graph.getObject(list, RDFTerm.RDF_first);
    }

    protected Property getProperty(Node node) {
        if (this.kb != null) {
            String name = this.factory.getLabel(node);
            NamedObjectProperty op = TermFactory.namedObjectProperty(name);
            if (this.kb.contains(op)) {
                return op;
            }
            NamedDataProperty dp = TermFactory.namedDataProperty(name);
            if (this.kb.contains(dp)) {
                return dp;
            }
            NamedAnnotationProperty ap = TermFactory.namedAnnotationProperty(name);
            if (this.kb.contains(ap)) {
                return ap;
            }
        }
        for (CachingTermCreator<? extends Property> propertyCreator : this.propertyCreators) {
            Property prop = propertyCreator.get(node);
            if (prop == null) continue;
            return prop;
        }
        return null;
    }

    protected Node getRest(Resource list) {
        return this.graph.getObject(list, RDFTerm.RDF_rest);
    }

    protected void handleAxiom(Axiom axiom) {
        if (axiom != null) {
            this.handler.handle(axiom);
        }
    }

    protected boolean isRestriction(Resource node) {
        return this.graph.getObject(node, RDFTerm.OWL_onProperty) != null;
    }

    @Override
    public <T, N, R extends N, P extends R, C extends Iterator<T>> void read(RDFInput<T, N, R, P, C> graph, RDFAxiomHandler handler) {
        this.readInternal(graph, handler);
    }

    private void readInternal(RDFInput<Triple, Node, Resource, Predicate, ClosableIterator> graph, RDFAxiomHandler handler) {
        this.handler = handler;
        this.graph = graph;
        this.factory = graph.getFactory();
        this.monitor = (ProgressMonitor)this.options.get(OntologyReaderOptions.PROGRESS_MONITOR);
        this.monitor.setProgressTitle("Loading");
        this.monitor.setProgressLength(graph.size());
        this.monitor.taskStarted();
        LOGGER.debug("preprocess");
        this.reset();
        this.processTypes();
        this.processTriples();
        this.processDeferredAxioms();
        if (this.declarationHandling() == OntologyReaderOptions.DeclarationHandling.CREATE_ALL) {
            this.createDeclarations(handler);
        }
        this.monitor.taskFinished();
    }

    protected void createDeclarations(RDFAxiomHandler handler) {
        for (CachingTermCreator<?> entityCreator : this.entityCreators) {
            Set<?> builtIns = entityCreator.getBuiltIns();
            for (Term term : entityCreator.getCachedTerms()) {
                if (!(term instanceof NamedEntity) || builtIns.contains(term)) continue;
                handler.handle(this.declaration(term));
            }
        }
    }

    protected void processDeferredAxioms() {
        UnaryPropertyAxiom axiom;
        Property prop;
        OntologyReaderOptions.Scope scope = (OntologyReaderOptions.Scope)((Object)this.options.get(OntologyReaderOptions.SCOPE));
        if (scope == OntologyReaderOptions.Scope.INSTANCE) {
            return;
        }
        for (Resource s : this.functionalProperties) {
            prop = this.getProperty(s);
            axiom = null;
            if (prop == null) {
                axiom = ((ObjectProperty)this.objectProperties.assume(s)).functional();
            } else if (prop instanceof ObjectProperty) {
                axiom = ((ObjectProperty)prop).functional();
            } else if (prop instanceof DataProperty) {
                axiom = ((DataProperty)prop).functional();
            } else if (prop instanceof AnnotationProperty) {
                throw new RDFParseException("Functionality not allowed for annotation proeprties: " + String.valueOf(prop));
            }
            this.handleAxiom(axiom);
        }
        for (Resource s : this.inverseFunctionalProperties) {
            prop = this.getProperty(s);
            axiom = null;
            if (prop == null) {
                axiom = ((ObjectProperty)this.objectProperties.assume(s)).inverseFunctional();
            } else if (prop instanceof ObjectProperty) {
                axiom = ((ObjectProperty)prop).inverseFunctional();
            } else if (prop instanceof DataProperty) {
                axiom = ((DataProperty)prop).inverseFunctional();
            } else if (prop instanceof AnnotationProperty) {
                throw new RDFParseException("Functionality not allowed for annotation proeprties: " + String.valueOf(prop));
            }
            this.handleAxiom(axiom);
        }
    }

    protected Axiom processTriple(Triple triple) {
        Predicate p = this.factory.getTriplePredicate(triple);
        Resource s = this.factory.getTripleSubject(triple);
        Node o = this.factory.getTripleObject(triple);
        OntologyReaderOptions.Scope scope = (OntologyReaderOptions.Scope)((Object)this.options.get(OntologyReaderOptions.SCOPE));
        if (this.ontologies.contains(s)) {
            return null;
        }
        RDFTerm builtinTerm = this.factory.getTerm(p);
        if (builtinTerm != null) {
            if (builtinTerm.isSyntax()) {
                return null;
            }
            if (builtinTerm.equals((Object)RDFTerm.RDF_type)) {
                RDFTerm resource;
                if (scope != OntologyReaderOptions.Scope.SCHEMA && ((resource = this.factory.getTerm(o)) == null || resource.equals((Object)RDFTerm.OWL_Thing) || resource.equals((Object)RDFTerm.OWL_Nothing))) {
                    Individual st = (Individual)this.individuals.assume(s);
                    ClassExpression ot = (ClassExpression)this.classes.assume(o);
                    return st.type(ot);
                }
                return null;
            }
        }
        this.monitor.incrementProgress();
        if (builtinTerm == null || builtinTerm.isPredefined()) {
            Property pt = this.getProperty(p);
            Entity entity = this.getEntity(s);
            if (this.factory.isLiteral(o) || pt instanceof DataProperty) {
                LiteralValue lit;
                LiteralValue literalValue = lit = this.factory.isVariable(o) ? this.literals.createVar(o) : this.literals.create(o);
                if (pt == null) {
                    if (entity == null) {
                        DataProperty dp = (DataProperty)this.dataProperties.assume(p);
                        return ((Individual)this.individuals.assume(s)).fact(dp, lit);
                    }
                    if (entity instanceof Individual) {
                        DataProperty dp = (DataProperty)this.dataProperties.assume(p);
                        return ((Individual)entity).fact(dp, lit);
                    }
                    if (entity instanceof NamedEntity) {
                        AnnotationProperty ap = (AnnotationProperty)this.annotationProperties.assume(p);
                        if (scope == OntologyReaderOptions.Scope.INSTANCE) {
                            return null;
                        }
                        return TermFactory.namedAnnotationEntity(((NamedEntity)entity).getName()).annotation(ap, lit);
                    }
                    if (entity instanceof AnonIndividual) {
                        AnnotationProperty ap = (AnnotationProperty)this.annotationProperties.assume(p);
                        if (scope == OntologyReaderOptions.Scope.INSTANCE) {
                            return null;
                        }
                        return ((AnonIndividual)entity).annotation(ap, lit);
                    }
                    throw new RDFParseException("Ignoring triple with untyped subject and predicate: " + String.valueOf(triple));
                }
                if (pt instanceof AnnotationProperty) {
                    if (scope == OntologyReaderOptions.Scope.INSTANCE) {
                        return null;
                    }
                    return TermFactory.annotation(this.annotationEntities.create(s), (AnnotationProperty)pt, (AnnotationValue)lit);
                }
                if (pt instanceof DataProperty) {
                    Individual ind = (Individual)this.individuals.assume(s);
                    return ind.fact((DataProperty)pt, lit);
                }
                throw new RDFParseException("Ignoring literal value used with object property: " + String.valueOf(triple));
            }
            if (pt == null) {
                if (entity == null) {
                    ObjectProperty op = (ObjectProperty)this.objectProperties.assume(p);
                    Individual ind = (Individual)this.individuals.assume(s);
                    Individual val = (Individual)this.individuals.assume(o);
                    return ind.fact(op, val);
                }
                if (entity instanceof Individual) {
                    ObjectProperty op = (ObjectProperty)this.objectProperties.assume(p);
                    Individual val = (Individual)this.individuals.assume(o);
                    return ((Individual)entity).fact(op, val);
                }
                AnnotationProperty ap = (AnnotationProperty)this.annotationProperties.assume(p);
                AnnotationEntity subj = this.annotationEntities.create(s);
                AnnotationEntity obj = this.annotationEntities.create(o);
                return TermFactory.annotation(subj, ap, (AnnotationValue)obj);
            }
            if (pt instanceof AnnotationProperty) {
                AnnotationEntity subj = this.annotationEntities.create(s);
                AnnotationEntity obj = this.annotationEntities.create(o);
                return TermFactory.annotation(subj, (AnnotationProperty)pt, (AnnotationValue)obj);
            }
            if (pt instanceof ObjectProperty) {
                Individual ind = (Individual)this.individuals.assume(s);
                Individual val = (Individual)this.individuals.assume(o);
                return ind.fact((ObjectProperty)pt, val);
            }
            throw new RDFParseException("Ignoring object value used with data property : " + String.valueOf(triple));
        }
        if (scope == OntologyReaderOptions.Scope.INSTANCE && !builtinTerm.isABox() && builtinTerm != RDFTerm.OWL_members) {
            return null;
        }
        switch (builtinTerm) {
            case RDFS_subClassOf: {
                ClassExpression st = (ClassExpression)this.classes.assume(s);
                ClassExpression ot = (ClassExpression)this.classes.assume(o);
                return st.subClassOf(ot);
            }
            case RDFS_subPropertyOf: {
                Property sub = this.getProperty(s);
                Property sup = this.getProperty(o);
                if (sub == null) {
                    if (sup == null) {
                        return ((ObjectProperty)this.objectProperties.assume(s)).subPropertyOf((ObjectProperty)this.objectProperties.assume(o));
                    }
                    if (sup instanceof ObjectProperty) {
                        return ((ObjectProperty)this.objectProperties.assume(s)).subPropertyOf((ObjectProperty)sup);
                    }
                    if (sup instanceof DataProperty) {
                        return ((DataProperty)this.dataProperties.assume(s)).subPropertyOf((DataProperty)sup);
                    }
                    if (sup instanceof AnnotationProperty) {
                        return ((AnnotationProperty)this.annotationProperties.assume(s)).subPropertyOf((AnnotationProperty)sup);
                    }
                } else {
                    if (sub instanceof ObjectProperty) {
                        return ((ObjectProperty)sub).subPropertyOf((ObjectProperty)this.objectProperties.assume(o));
                    }
                    if (sub instanceof DataProperty) {
                        return ((DataProperty)sub).subPropertyOf((DataProperty)this.dataProperties.assume(o));
                    }
                    if (sub instanceof AnnotationProperty) {
                        return ((AnnotationProperty)sub).subPropertyOf((AnnotationProperty)this.annotationProperties.assume(o));
                    }
                }
                throw new AssertionError();
            }
            case RDFS_domain: {
                ClassExpression cls = (ClassExpression)this.classes.assume(o);
                Property prop = this.getProperty(s);
                if (prop == null) {
                    return ((ObjectProperty)this.objectProperties.assume(s)).domain(cls);
                }
                if (prop instanceof ObjectProperty) {
                    return ((ObjectProperty)prop).domain(cls);
                }
                if (prop instanceof DataProperty) {
                    return ((DataProperty)prop).domain(cls);
                }
                if (prop instanceof AnnotationProperty) {
                    return ((AnnotationProperty)prop).domain(cls);
                }
                throw new AssertionError();
            }
            case RDFS_range: {
                Property prop = this.getProperty(s);
                if (prop == null) {
                    Datatype dt = this.datatypes.get(o);
                    if (dt != null) {
                        return ((DataProperty)this.dataProperties.assume(s)).range(dt);
                    }
                    return ((ObjectProperty)this.objectProperties.assume(s)).range((ClassExpression)this.classes.assume(o));
                }
                if (prop instanceof ObjectProperty) {
                    ClassExpression cls = (ClassExpression)this.classes.assume(o);
                    return ((ObjectProperty)prop).range(cls);
                }
                if (prop instanceof DataProperty) {
                    Datatype dt = (Datatype)this.datatypes.assume(o);
                    return ((DataProperty)prop).range(dt);
                }
                if (prop instanceof AnnotationProperty) {
                    Datatype dt = this.datatypes.get(o);
                    if (dt != null) {
                        return ((AnnotationProperty)prop).range(dt);
                    }
                    return ((AnnotationProperty)prop).range((Type)this.classes.assume(o));
                }
                throw new AssertionError();
            }
            case OWL_intersectionOf: {
                if (!this.factory.isBlank(s)) {
                    ClassExpression st = (ClassExpression)this.classes.assume(s);
                    Set set = this.classes.createSet(this.mustBeResource(o));
                    return st.equivalentTo(TermFactory.and(set));
                }
                return null;
            }
            case OWL_unionOf: {
                if (!this.factory.isBlank(s)) {
                    ClassExpression st = (ClassExpression)this.classes.assume(s);
                    Set set = this.classes.createSet(this.mustBeResource(o));
                    return st.equivalentTo(TermFactory.or(set));
                }
                return null;
            }
            case OWL2_disjointUnionOf: {
                if (!this.factory.isBlank(s)) {
                    NamedClass st = (NamedClass)this.classes.assume(s);
                    Set set = this.classes.createSet(this.mustBeResource(o));
                    return TermFactory.disjointUnion(st, set);
                }
                return null;
            }
            case OWL_complementOf: {
                if (!this.factory.isBlank(s)) {
                    ClassExpression st = (ClassExpression)this.classes.assume(s);
                    ClassExpression ot = (ClassExpression)this.classes.assume(o);
                    return st.equivalentTo(TermFactory.not(ot));
                }
                return null;
            }
            case OWL_equivalentClass: {
                Datatype d1 = this.datatypes.get(s);
                Datatype d2 = this.datatypes.get(o);
                if (d1 != null) {
                    if (!(d1 instanceof NamedDatatype)) {
                        throw new RDFParseException("Expecting named datatype, found: " + String.valueOf(d1));
                    }
                    if (d2 == null) {
                        throw new RDFParseException("Expecting datatype, found: " + String.valueOf(d2));
                    }
                    NamedDatatype nd = (NamedDatatype)d1;
                    return nd.equivalentTo(d2);
                }
                if (d2 != null) {
                    d1 = (Datatype)this.datatypes.assume(s);
                    if (!(d1 instanceof NamedDatatype)) {
                        throw new RDFParseException("Expecting named datatype, found: " + String.valueOf(d1));
                    }
                    NamedDatatype nd = (NamedDatatype)d1;
                    return nd.equivalentTo(d2);
                }
                ClassExpression st = (ClassExpression)this.classes.assume(s);
                ClassExpression ot = (ClassExpression)this.classes.assume(o);
                return st.equivalentTo(ot);
            }
            case OWL_disjointWith: {
                ClassExpression st = (ClassExpression)this.classes.assume(s);
                ClassExpression ot = (ClassExpression)this.classes.assume(o);
                return st.disjointWith(ot);
            }
            case OWL2_propertyDisjointWith: {
                Property p1 = this.getProperty(s);
                Property p2 = this.getProperty(o);
                if (p1 == null) {
                    if (p2 == null) {
                        return ((ObjectProperty)this.objectProperties.assume(s)).disjointWith((ObjectProperty)this.objectProperties.assume(o));
                    }
                    if (p2 instanceof ObjectProperty) {
                        return ((ObjectProperty)this.objectProperties.assume(s)).disjointWith((ObjectProperty)p2);
                    }
                    if (p2 instanceof DataProperty) {
                        return ((DataProperty)this.dataProperties.assume(s)).disjointWith((DataProperty)p2);
                    }
                    if (p2 instanceof AnnotationProperty) {
                        throw new RDFParseException("Disjoints are not allowed for annotation properties");
                    }
                } else {
                    if (p1 instanceof ObjectProperty) {
                        return ((ObjectProperty)p1).disjointWith((ObjectProperty)this.objectProperties.assume(o));
                    }
                    if (p1 instanceof DataProperty) {
                        return ((DataProperty)p1).disjointWith((DataProperty)this.dataProperties.assume(o));
                    }
                    if (p1 instanceof AnnotationProperty) {
                        throw new RDFParseException("Disjoints are not allowed for annotation properties");
                    }
                }
                throw new AssertionError();
            }
            case OWL2_propertyChainAxiom: {
                ObjectProperty st = (ObjectProperty)this.objectProperties.assume(s);
                List<ObjectProperty> properties = this.objectProperties.createList(this.mustBeResource(o));
                return TermFactory.propertyList(properties).subPropertyOf(st);
            }
            case OWL_equivalentProperty: {
                Property p1 = this.getProperty(s);
                Property p2 = this.getProperty(o);
                if (p1 == null) {
                    if (p2 == null) {
                        return ((ObjectProperty)this.objectProperties.assume(s)).equivalentTo((ObjectProperty)this.objectProperties.assume(o));
                    }
                    if (p2 instanceof ObjectProperty) {
                        return ((ObjectProperty)this.objectProperties.assume(s)).equivalentTo((ObjectProperty)p2);
                    }
                    if (p2 instanceof DataProperty) {
                        return ((DataProperty)this.dataProperties.assume(s)).equivalentTo((DataProperty)p2);
                    }
                    if (p2 instanceof AnnotationProperty) {
                        throw new RDFParseException("Equivalents are not allowed for annotation properties");
                    }
                } else {
                    if (p1 instanceof ObjectProperty) {
                        return ((ObjectProperty)p1).equivalentTo((ObjectProperty)this.objectProperties.assume(o));
                    }
                    if (p1 instanceof DataProperty) {
                        return ((DataProperty)p1).equivalentTo((DataProperty)this.dataProperties.assume(o));
                    }
                    if (p1 instanceof AnnotationProperty) {
                        throw new RDFParseException("Equivalents are not allowed for annotation properties");
                    }
                }
                throw new AssertionError();
            }
            case OWL_inverseOf: {
                if (!this.factory.isBlank(s)) {
                    ObjectProperty st = (ObjectProperty)this.objectProperties.assume(s);
                    ObjectProperty ot = (ObjectProperty)this.objectProperties.assume(o);
                    return st.inverseOf(ot);
                }
                return null;
            }
            case OWL_sameAs: {
                Individual st = (Individual)this.individuals.assume(s);
                Individual ot = (Individual)this.individuals.assume(o);
                return st.sameAs(ot);
            }
            case OWL_differentFrom: {
                Individual st = (Individual)this.individuals.assume(s);
                Individual ot = (Individual)this.individuals.assume(o);
                return st.differentFrom(ot);
            }
            case OWL_distinctMembers: {
                Set inds = this.individuals.createSet(this.mustBeResource(o));
                return TermFactory.differentIndividuals(inds);
            }
            case OWL_members: {
                RDFTerm entityType = this.naryDisjoints.get(s);
                if (entityType == null) {
                    throw new RDFParseException("There is no valid rdf:type for an owl:members assertion: " + String.valueOf(s));
                }
                switch (entityType) {
                    case OWL_AllDifferent: {
                        Set inds = this.individuals.createSet(this.mustBeResource(o));
                        return TermFactory.differentIndividuals(inds);
                    }
                    case OWL2_AllDisjointClasses: {
                        if (scope == OntologyReaderOptions.Scope.INSTANCE) {
                            return null;
                        }
                        Set set = this.classes.createSet(this.mustBeResource(o));
                        return TermFactory.disjointClasses(set);
                    }
                    case OWL2_AllDisjointProperties: {
                        if (scope == OntologyReaderOptions.Scope.INSTANCE) {
                            return null;
                        }
                        HashSet objProps = Sets.newHashSet();
                        HashSet dataProps = Sets.newHashSet();
                        HashSet untypedProps = Sets.newHashSet();
                        RDFListIterator list = new RDFListIterator(this.mustBeResource(o));
                        while (list.hasNext()) {
                            Object node = list.next();
                            Property prop = this.getProperty(node);
                            if (prop instanceof ObjectProperty) {
                                objProps.add((ObjectProperty)prop);
                                continue;
                            }
                            if (prop instanceof DataProperty) {
                                dataProps.add((DataProperty)prop);
                                continue;
                            }
                            if (prop instanceof AnnotationProperty) {
                                throw new RDFParseException("Disjointness not allowed for annotation properties: " + String.valueOf(node));
                            }
                            untypedProps.add(node);
                        }
                        if (!objProps.isEmpty() || dataProps.isEmpty() && !untypedProps.isEmpty()) {
                            for (Object node : untypedProps) {
                                objProps.add((ObjectProperty)this.objectProperties.assume(node));
                            }
                            return TermFactory.disjointProperties(objProps);
                        }
                        if (dataProps.isEmpty()) break;
                        for (Object node : untypedProps) {
                            dataProps.add((DataProperty)this.dataProperties.assume(node));
                        }
                        return TermFactory.disjointDataProperties(dataProps);
                    }
                }
                throw new RDFParseException("The rdf:type for an owl:members assertion is not recognized: " + String.valueOf((Object)entityType));
            }
            case OWL_oneOf: {
                if (!this.datatypes.contains(s) && !this.factory.isBlank(s)) {
                    ClassExpression st = (ClassExpression)this.classes.assume(s);
                    Set inds = this.individuals.createSet(this.mustBeResource(o));
                    return st.equivalentTo(TermFactory.oneOf(inds));
                }
                return null;
            }
            case OWL2_hasKey: {
                ClassExpression st = (ClassExpression)this.classes.assume(s);
                HashSet objProps = Sets.newHashSet();
                HashSet dataProps = Sets.newHashSet();
                boolean dataPropertySeen = false;
                RDFListIterator list = new RDFListIterator(this.mustBeResource(o));
                while (list.hasNext()) {
                    Object node = list.next();
                    Property prop = this.getProperty(node);
                    if (prop instanceof ObjectProperty) {
                        objProps.add((ObjectProperty)prop);
                        continue;
                    }
                    if (prop instanceof DataProperty) {
                        dataProps.add((DataProperty)prop);
                        dataPropertySeen = true;
                        continue;
                    }
                    if (prop instanceof AnnotationProperty) {
                        throw new RDFParseException("HasKey axioms not allowed for annotation properties: " + String.valueOf(node));
                    }
                    if (dataPropertySeen) {
                        dataProps.add((DataProperty)this.dataProperties.assume(node));
                        continue;
                    }
                    objProps.add((ObjectProperty)this.objectProperties.assume(node));
                }
                return st.hasKey(objProps, dataProps);
            }
        }
        throw new RDFParseException("Unexpected built-in property: " + String.valueOf(p));
    }

    protected void processTriples() {
        LOGGER.debug("processTriples");
        OntologyReaderOptions.Scope scope = (OntologyReaderOptions.Scope)((Object)this.options.get(OntologyReaderOptions.SCOPE));
        if (scope != OntologyReaderOptions.Scope.SCHEMA) {
            this.processTriples(null);
        } else {
            for (RDFTerm predicate : RDFTerms.TBOX_PREDICATES) {
                this.processTriples(this.factory.getPredicate(predicate));
            }
        }
    }

    protected void processTriples(Predicate predicate) {
        ClosableIterator i = this.graph.find(null, predicate, null);
        while (i.hasNext()) {
            Object triple = i.next();
            try {
                Axiom axiom = this.processTriple(triple);
                this.handleAxiom(axiom);
            }
            catch (RuntimeException e) {
                this.handleException(e);
            }
        }
        this.graph.close(i);
    }

    protected void handleException(RuntimeException e) {
        if (!this.options.is(RDFAxiomReaderOptions.IGNORE_UNSUPPORTED_AXIOMS)) {
            throw e;
        }
        LOGGER.warn("Ignoring axiom exception", (Throwable)e);
    }

    private OntologyReaderOptions.DeclarationHandling declarationHandling() {
        return (OntologyReaderOptions.DeclarationHandling)((Object)this.options.get(OntologyReaderOptions.DECLARATION_HANDLING));
    }

    private Declaration declaration(Term t) {
        return ((NamedEntity)t).declaration();
    }

    private Declaration declarationMaybe(Term t) {
        if (this.declarationHandling() == OntologyReaderOptions.DeclarationHandling.CREATE_NONE) {
            return null;
        }
        OntologyReaderOptions.Scope scope = (OntologyReaderOptions.Scope)((Object)this.options.get(OntologyReaderOptions.SCOPE));
        if (scope != OntologyReaderOptions.Scope.ALL && scope == OntologyReaderOptions.Scope.INSTANCE != t instanceof Individual) {
            return null;
        }
        return this.declaration(t);
    }

    protected Axiom processType(Triple triple) {
        Resource s = this.factory.getTripleSubject(triple);
        Node o = this.factory.getTripleObject(triple);
        if (this.factory.isLiteral(o)) {
            throw new RDFParseException("Expecting a resource but found literal: " + String.valueOf(o));
        }
        RDFTerm builtinTerm = this.factory.getTerm(o);
        if (builtinTerm != null) {
            if (builtinTerm.isSyntax()) {
                if (builtinTerm == RDFTerm.OWL_Ontology) {
                    this.ontologies.add(s);
                }
                return null;
            }
            if (this.factory.isBlank(s) && builtinTerm.equals((Object)RDFTerm.OWL_Class)) {
                return null;
            }
        }
        this.monitor.incrementProgress();
        if (builtinTerm == null || builtinTerm.isPredefined()) {
            return null;
        }
        OntologyReaderOptions.Scope scope = (OntologyReaderOptions.Scope)((Object)this.options.get(OntologyReaderOptions.SCOPE));
        switch (builtinTerm) {
            case OWL_Class: 
            case RDFS_Class: {
                ClassExpression cls = this.classes.create(s);
                if (cls.isNamed()) {
                    return this.declarationMaybe(cls);
                }
                return null;
            }
            case RDFS_Datatype: 
            case OWL_DataRange: {
                Datatype dt = this.datatypes.create(s);
                if (dt.isNamed()) {
                    return this.declarationMaybe(dt);
                }
                this.anonDatatypes.add(s);
                return null;
            }
            case OWL2_NamedIndividual: {
                Individual ind = this.individuals.create(s);
                if (ind.isNamed() && !ind.isAnon()) {
                    return this.declarationMaybe(ind);
                }
                return null;
            }
            case OWL_ObjectProperty: {
                ObjectProperty p = this.objectProperties.create(s);
                if (p.isNamed()) {
                    return this.declarationMaybe(p);
                }
                return null;
            }
            case OWL_DatatypeProperty: {
                DataProperty p = this.dataProperties.create(s);
                if (p.isNamed()) {
                    return this.declarationMaybe(p);
                }
                return null;
            }
            case OWL_FunctionalProperty: {
                if (scope == OntologyReaderOptions.Scope.INSTANCE) {
                    return null;
                }
                Property p = this.getProperty(s);
                if (p == null) {
                    this.functionalProperties.add(s);
                    return null;
                }
                if (p instanceof ObjectProperty) {
                    return ((ObjectProperty)p).functional();
                }
                if (p instanceof DataProperty) {
                    return ((DataProperty)p).functional();
                }
                throw new RDFParseException("Ignoring FunctionalProperty axiom for annotation property " + String.valueOf(s));
            }
            case OWL_InverseFunctionalProperty: {
                if (scope == OntologyReaderOptions.Scope.INSTANCE) {
                    return null;
                }
                Property p = this.getProperty(s);
                if (p == null) {
                    this.inverseFunctionalProperties.add(s);
                    return null;
                }
                if (p instanceof ObjectProperty) {
                    return ((ObjectProperty)p).inverseFunctional();
                }
                if (p instanceof DataProperty) {
                    return ((DataProperty)p).inverseFunctional();
                }
                throw new RDFParseException("Ignoring inverse functional property axiom for annotation property " + String.valueOf(s));
            }
            case OWL_TransitiveProperty: {
                if (scope == OntologyReaderOptions.Scope.INSTANCE) {
                    return null;
                }
                ObjectProperty p = this.objectProperties.create(s);
                return p.transitive();
            }
            case OWL_SymmetricProperty: {
                if (scope == OntologyReaderOptions.Scope.INSTANCE) {
                    return null;
                }
                ObjectProperty p = this.objectProperties.create(s);
                return p.symmetric();
            }
            case OWL_AnnotationProperty: {
                if (scope == OntologyReaderOptions.Scope.INSTANCE) {
                    return null;
                }
                AnnotationProperty p = this.annotationProperties.create(s);
                if (p.isNamed()) {
                    return this.declarationMaybe(p);
                }
                return null;
            }
            case OWL2_ReflexiveProperty: {
                if (scope == OntologyReaderOptions.Scope.INSTANCE) {
                    return null;
                }
                ObjectProperty p = this.objectProperties.create(s);
                return p.reflexive();
            }
            case OWL2_IrreflexiveProperty: {
                if (scope == OntologyReaderOptions.Scope.INSTANCE) {
                    return null;
                }
                ObjectProperty p = this.objectProperties.create(s);
                return p.irreflexive();
            }
            case OWL2_AsymmetricProperty: {
                if (scope == OntologyReaderOptions.Scope.INSTANCE) {
                    return null;
                }
                ObjectProperty p = this.objectProperties.create(s);
                return p.asymmetric();
            }
            case OWL2_NegativePropertyAssertion: {
                return this.negativePropertyAssertions.create(s);
            }
            case SWRL_Imp: {
                if (scope == OntologyReaderOptions.Scope.INSTANCE) {
                    return null;
                }
                return this.rules.create(s);
            }
            case OWL_AllDifferent: 
            case OWL2_AllDisjointClasses: 
            case OWL2_AllDisjointProperties: {
                this.naryDisjoints.put(s, builtinTerm);
                return null;
            }
        }
        throw new RDFParseException("Unexpected built-in type: " + String.valueOf(o));
    }

    protected void processTypes() {
        LOGGER.debug("processTypes");
        OntologyReaderOptions.Scope scope = (OntologyReaderOptions.Scope)((Object)this.options.get(OntologyReaderOptions.SCOPE));
        if (scope != OntologyReaderOptions.Scope.SCHEMA) {
            this.processTypes(null);
        } else {
            for (RDFTerm type : RDFTerms.TBOX_TYPES) {
                this.processTypes(this.factory.getResource(type));
            }
        }
    }

    protected void processTypes(Node type) {
        ClosableIterator i = this.graph.find(null, this.factory.getPredicate(RDFTerm.RDF_type), type);
        while (i.hasNext()) {
            Object stmt = i.next();
            try {
                Axiom axiom = this.processType(stmt);
                this.handleAxiom(axiom);
            }
            catch (RuntimeException e) {
                this.handleException(e);
            }
        }
        this.graph.close(i);
    }

    public void reset() {
        this.classes.reset();
        this.individuals.reset();
        this.annotationProperties.reset();
        this.dataProperties.reset();
        this.objectProperties.reset();
        this.datatypes.reset();
        this.ontologies = Sets.newHashSet();
        this.anonDatatypes = Sets.newHashSet();
        this.naryDisjoints = Maps.newHashMap();
        this.functionalProperties = Sets.newHashSet();
        this.inverseFunctionalProperties = Sets.newHashSet();
    }

    public void setAxiomHandler(RDFAxiomHandler handler) {
        this.handler = handler;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    private abstract class CachingTermCreator<T extends Term>
    extends TermCreator<T> {
        protected Map<Node, T> cache;

        private CachingTermCreator() {
            this.cache = Maps.newHashMap();
        }

        @Override
        public T create(Node node) {
            Term term = (Term)this.cache.get(node);
            if (term == null) {
                term = DefaultRDFAxiomReader.this.factory.isVariable(node) ? this.createVar(node) : this.createTerm(node);
                this.cache.put(node, term);
            }
            return (T)term;
        }

        public boolean contains(Node node) {
            return this.cache.containsKey(node);
        }

        public T get(Node node) {
            return (T)((Term)this.cache.get(node));
        }

        public final void reset() {
            this.cache.clear();
            Function builtinMapper = this.getBuiltInMapper();
            for (Term builtin : this.getBuiltIns()) {
                this.cache.put(builtinMapper.apply((Object)builtin), builtin);
            }
        }

        public Iterable<T> getCachedTerms() {
            return this.cache.values();
        }

        public Set<? extends T> getBuiltIns() {
            return ImmutableSet.of();
        }

        protected Function<T, Node> getBuiltInMapper() {
            return null;
        }
    }

    private abstract class TermCreator<T extends Term> {
        private TermCreator() {
        }

        public T assume(Node node) {
            return this.create(node);
        }

        public T create(Node node) {
            return this.createTerm(node);
        }

        protected <C extends Collection<T>> C createCollection(Resource rdfList, C collection) {
            RDFListIterator list = new RDFListIterator(rdfList);
            while (list.hasNext()) {
                collection.add(this.create(list.next()));
            }
            return collection;
        }

        protected List<T> createList(Resource rdfList) {
            return this.createCollection(rdfList, Lists.newArrayList());
        }

        protected Set<T> createSet(Resource rdfList) {
            return this.createCollection(rdfList, Sets.newLinkedHashSet());
        }

        public T createSWRL(Node node) {
            if (!DefaultRDFAxiomReader.this.factory.isLiteral(node) && DefaultRDFAxiomReader.this.graph.contains(DefaultRDFAxiomReader.this.mustBeResource(node), RDFTerm.RDF_type, RDFTerm.SWRL_Variable)) {
                return this.createVar(node);
            }
            return this.create(node);
        }

        public abstract T createTerm(Node var1);

        public T createVar(Node node) {
            throw new UnsupportedOperationException("Cannot create a variable");
        }
    }

    private class RDFListIterator
    implements Iterator<Node> {
        private Resource list;

        public RDFListIterator(Resource list) {
            this.list = list;
        }

        @Override
        public boolean hasNext() {
            return !this.list.equals(DefaultRDFAxiomReader.this.factory.getResource(RDFTerm.RDF_nil));
        }

        @Override
        public Node next() {
            Object first = DefaultRDFAxiomReader.this.getFirst(this.list);
            DefaultRDFAxiomReader.this.monitor.incrementProgress();
            Object rest = DefaultRDFAxiomReader.this.mustBeResource(DefaultRDFAxiomReader.this.getRest(this.list));
            DefaultRDFAxiomReader.this.monitor.incrementProgress();
            if (first == null || rest == null) {
                throw new RDFParseException("Invalid list structure: List " + String.valueOf(this.list) + " does not have a " + (first == null ? "first" : "rest") + " property.");
            }
            this.list = rest;
            return first;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

