/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rdf;

import com.clarkparsia.pellet.rdf.RDFFactory;
import com.clarkparsia.pellet.rdf.RDFTerm;
import com.clarkparsia.pellet.rdf.RDFTerms;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.EnumMap;

public abstract class AbstractRDFFactory<Triple, Node, Resource extends Node, Predicate extends Resource>
implements RDFFactory<Triple, Node, Resource, Predicate> {
    private final EnumMap<RDFTerm, Resource> terms = Maps.newEnumMap(RDFTerm.class);

    @Override
    public Resource getResource(RDFTerm term) {
        Resource resource = this.terms.get((Object)term);
        if (resource == null) {
            resource = this.createResource(term.getURI());
            this.terms.put(term, resource);
        }
        return resource;
    }

    @Override
    public Predicate getPredicate(RDFTerm term) {
        Preconditions.checkArgument((boolean)term.isPredicate());
        Object predicate = this.terms.get((Object)term);
        if (predicate == null) {
            predicate = this.createPredicate(term.getURI());
            this.terms.put(term, predicate);
        }
        return (Predicate)predicate;
    }

    @Override
    public RDFTerm getTerm(Node term) {
        return !this.isURI(term) ? null : RDFTerms.get(this.getLabel(term));
    }
}

