/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.hierarchy;

import com.clarkparsia.pellet.hierarchy.Hierarchy;
import com.clarkparsia.pellet.hierarchy.HierarchyNode;
import com.clarkparsia.pellet.hierarchy.impl.IndentedHierarchyWriter;
import com.clarkparsia.pellet.util.collections.ArraySet;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class HierarchyUtils {
    public static <T> List<Set<HierarchyNode<T>>> computeCycles(Hierarchy<T> hierarchy) {
        return HierarchyUtils.computeCycles(ImmutableList.of(hierarchy.getTop()));
    }

    private static <T> List<Set<HierarchyNode<T>>> computeCycles(Iterable<HierarchyNode<T>> startNodes) {
        ArrayList result = Lists.newArrayList();
        ArrayList stack = Lists.newArrayList();
        HashMap nodeInfos = Maps.newHashMap();
        for (HierarchyNode<T> startNode : startNodes) {
            HierarchyUtils.stronglyConnectedComponents(startNode, nodeInfos, stack, result);
        }
        return result;
    }

    private static <T> SCCInfo stronglyConnectedComponents(HierarchyNode<T> node, Map<HierarchyNode<T>, SCCInfo> nodeInfos, ArrayList<HierarchyNode<T>> stack, List<Set<HierarchyNode<T>>> result) {
        int index = nodeInfos.size();
        SCCInfo nodeInfo = new SCCInfo(index);
        nodeInfos.put(node, nodeInfo);
        stack.add(node);
        for (HierarchyNode<T> out : node.getSubs()) {
            SCCInfo outInfo = nodeInfos.get(out);
            if (outInfo == null) {
                outInfo = HierarchyUtils.stronglyConnectedComponents(out, nodeInfos, stack, result);
                nodeInfo.lowlink = Math.min(nodeInfo.lowlink, outInfo.lowlink);
                continue;
            }
            if (!outInfo.onStack) continue;
            nodeInfo.lowlink = Math.min(nodeInfo.lowlink, outInfo.index);
        }
        if (nodeInfo.lowlink == nodeInfo.index) {
            HashSet connectedComponent = Sets.newHashSet();
            int i = stack.size() - 1;
            SCCInfo info = null;
            while (info != nodeInfo) {
                HierarchyNode<T> other = stack.get(i);
                info = nodeInfos.get(other);
                info.onStack = false;
                connectedComponent.add(other);
                --i;
            }
            if (connectedComponent.size() > 1) {
                result.add(connectedComponent);
            }
            stack.subList(i + 1, stack.size()).clear();
        }
        return nodeInfo;
    }

    public static <T> List<Set<HierarchyNode<T>>> removeCycles(Hierarchy<T> hierarchy) {
        List<Set<HierarchyNode<T>>> components = HierarchyUtils.computeCycles(hierarchy);
        Iterator<Set<HierarchyNode<T>>> i = components.iterator();
        while (i.hasNext()) {
            Set<HierarchyNode<T>> component = i.next();
            if (component.size() <= 1) {
                i.remove();
                continue;
            }
            HierarchyUtils.mergeDirect(hierarchy, component);
        }
        return components;
    }

    public static <T> HierarchyNode<T> merge(Hierarchy<T> hierarchy, HierarchyNode ... nodes) {
        return HierarchyUtils.merge(hierarchy, Arrays.asList(nodes));
    }

    public static <T> HierarchyNode<T> merge(Hierarchy<T> hierarchy, Iterable<HierarchyNode<T>> nodes) {
        int size;
        Set<Object> mergeList = null;
        if (Iterables.contains(nodes, hierarchy.getTop())) {
            mergeList = Sets.newHashSet();
            for (HierarchyNode<T> node : nodes) {
                Iterators.addAll((Collection)mergeList, node.nodeIterator().bottomUp().build());
            }
        } else if (Iterables.contains(nodes, hierarchy.getBottom())) {
            mergeList = Sets.newHashSet();
            for (HierarchyNode<T> node : nodes) {
                Iterators.addAll((Collection)mergeList, node.nodeIterator().topDown().build());
            }
        } else {
            int size2 = 0;
            for (HierarchyNode<T> node : nodes) {
                ++size2;
                for (HierarchyNode<T> other : nodes) {
                    if (node == other) continue;
                    node.addSub(other);
                    other.addSub(node);
                }
            }
            if (size2 == 0) {
                throw new IllegalArgumentException("No nodes to merge");
            }
            if (size2 == 1) {
                return (HierarchyNode)Iterables.getFirst(nodes, null);
            }
            List<Set<HierarchyNode<T>>> components = HierarchyUtils.computeCycles(nodes);
            for (Set<HierarchyNode<T>> component : components) {
                if (component.size() <= 1 || !Iterables.any(nodes, (Predicate)Predicates.in(component))) continue;
                mergeList = component;
                break;
            }
        }
        if ((size = mergeList.size()) == 1) {
            return (HierarchyNode)Iterables.getFirst(nodes, null);
        }
        return HierarchyUtils.mergeDirect(hierarchy, mergeList);
    }

    private static <T> HierarchyNode<T> mergeDirect(Hierarchy<T> hierarchy, Iterable<HierarchyNode<T>> nodes) {
        ArraySet nodesToMerge = new ArraySet();
        Iterables.addAll(nodesToMerge, nodes);
        HierarchyNode<T> top = hierarchy.getTop();
        HierarchyNode<T> bottom = hierarchy.getBottom();
        HierarchyNode<T> node = (HierarchyNode<T>)Iterables.getFirst(nodesToMerge, null);
        if (node == null) {
            throw new IllegalArgumentException("No nodes to merge");
        }
        if (nodesToMerge.size() == 1) {
            return node;
        }
        if (nodesToMerge.contains(top)) {
            if (nodesToMerge.contains(bottom)) {
                throw new IllegalArgumentException("Cannot merge top and bottom nodes");
            }
            node = top;
        } else if (nodesToMerge.contains(bottom)) {
            node = bottom;
        }
        for (HierarchyNode other : nodesToMerge) {
            if (node == other) continue;
            for (HierarchyNode sub : other.getSubs()) {
                if (sub.isBottom() || nodesToMerge.contains(sub)) continue;
                node.addSub(sub);
            }
            for (HierarchyNode<T> sup : other.getSupers()) {
                if (sup.isTop() || nodesToMerge.contains(sup)) continue;
                sup.addSub(node);
            }
            hierarchy.remove(other);
            for (HierarchyNode e : other.getElements()) {
                node.addElement(e);
            }
        }
        if (!node.isTop()) {
            top.removeSub(node);
            if (node.getSupers().isEmpty()) {
                top.addSub(node);
            }
        }
        if (!node.isBottom()) {
            node.removeSub(bottom);
            if (node.getSubs().isEmpty()) {
                node.addSub(bottom);
            }
        }
        return node;
    }

    public static <T> Collection<HierarchyNode<T>> lowestCommonAncestors(Hierarchy<T> hierarchy, Iterable<? extends T> elements) {
        Iterator<T> i = elements.iterator();
        if (i.hasNext()) {
            return Collections.emptyList();
        }
        T element = i.next();
        HashSet ancestors = Sets.newHashSet(hierarchy.getSupers(element));
        while (i.hasNext() && !ancestors.isEmpty()) {
            element = i.next();
            ancestors.retainAll(Sets.newHashSet(hierarchy.getSupers(element)));
        }
        HashSet toBeRemoved = Sets.newHashSet();
        for (HierarchyNode ancestor : ancestors) {
            if (toBeRemoved.contains(ancestor)) continue;
            HashSet supers = Sets.newHashSet(hierarchy.getSupers(ancestor.getElement()));
            toBeRemoved.addAll(supers);
        }
        ancestors.removeAll(toBeRemoved);
        return ancestors;
    }

    public static <T> void printHierarchy(Hierarchy<T> hierarchy) {
        HierarchyUtils.printHierarchy(hierarchy.getTop(), (OutputStream)System.out);
    }

    public static <T> void printHierarchy(Hierarchy<T> hierarchy, OutputStream out) {
        HierarchyUtils.printHierarchy(hierarchy.getTop(), out);
    }

    public static <T> void printHierarchy(HierarchyNode<T> node, OutputStream out) {
        new IndentedHierarchyWriter<T>().write(node, out);
    }

    public static <T> List<T> topologocialSort(Hierarchy<T> hierarchy, boolean includeEquivalents, Comparator<? super T> comparator) {
        HashMap degrees = new HashMap();
        AbstractMap nodesPending = comparator == null ? new HashMap() : new TreeMap(comparator);
        HashSet<HierarchyNode<T>> nodesLeft = new HashSet<HierarchyNode<T>>();
        ArrayList nodesSorted = new ArrayList();
        for (HierarchyNode<T> node : hierarchy) {
            nodesLeft.add(node);
            int degree = node.getSupers().size();
            if (degree == 0) {
                nodesPending.put(node.getElement(), node);
                degrees.put(node, 0);
                continue;
            }
            degrees.put(node, degree);
        }
        int size = nodesLeft.size();
        for (int i = 0; i < size; ++i) {
            if (nodesPending.isEmpty()) {
                throw new RuntimeException("Cycle detected in the Hierarchy!");
            }
            HierarchyNode node = (HierarchyNode)nodesPending.values().iterator().next();
            int deg = (Integer)degrees.get(node);
            if (deg != 0) {
                throw new RuntimeException("Cycle detected in the Hierarchy " + String.valueOf(node) + " " + deg + " " + nodesSorted.size() + " " + hierarchy.size());
            }
            nodesPending.remove(node.getElement());
            nodesLeft.remove(node);
            if (includeEquivalents) {
                nodesSorted.addAll(node.getElements());
            } else {
                nodesSorted.add(node.getElement());
            }
            for (HierarchyNode sub : node.getSubs()) {
                int degree = (Integer)degrees.get(sub);
                if (degree == 1) {
                    nodesPending.put(sub.getElement(), sub);
                    degrees.put(sub, 0);
                    continue;
                }
                degrees.put(sub, degree - 1);
            }
        }
        if (!nodesLeft.isEmpty()) {
            throw new RuntimeException("Failed to sort elements: " + String.valueOf(nodesLeft));
        }
        return nodesSorted;
    }

    private static class SCCInfo {
        private int index;
        private int lowlink;
        private boolean onStack;

        private SCCInfo(int index) {
            this.index = index;
            this.lowlink = index;
            this.onStack = true;
        }
    }
}

