/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.hierarchy;

import com.clarkparsia.pellet.api.term.builtins.Classes;
import com.clarkparsia.pellet.api.term.builtins.DataProperties;
import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.api.term.builtins.ObjectProperties;
import com.clarkparsia.pellet.api.term.entity.NamedClass;
import com.clarkparsia.pellet.api.term.entity.NamedDataProperty;
import com.clarkparsia.pellet.api.term.entity.NamedDatatype;
import com.clarkparsia.pellet.api.term.entity.NamedObjectProperty;
import com.clarkparsia.pellet.hierarchy.Hierarchy;
import com.clarkparsia.pellet.hierarchy.impl.HierarchyImpl;

public class HierarchyFactory {
    private HierarchyFactory() {
    }

    public static Hierarchy<NamedClass> createClassHierachy() {
        return HierarchyFactory.createHierachy(Classes.THING, Classes.NOTHING);
    }

    public static Hierarchy<NamedObjectProperty> createObjectPropertyHierachy() {
        return HierarchyFactory.createHierachy(ObjectProperties.TOP, ObjectProperties.BOTTOM);
    }

    public static Hierarchy<NamedDataProperty> createDataPropertyHierachy() {
        return HierarchyFactory.createHierachy(DataProperties.TOP, DataProperties.BOTTOM);
    }

    public static Hierarchy<NamedDatatype> createDatatypeHierachy() {
        return HierarchyFactory.createHierachy(Datatypes.TOP, null);
    }

    public static <T> Hierarchy<T> createHierachy() {
        return HierarchyFactory.createHierachy(null, null);
    }

    public static <T> Hierarchy<T> createHierachy(T top, T bottom) {
        return new HierarchyImpl<T>(top, bottom);
    }
}

