/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.function;

import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.builtins.Functions;
import com.clarkparsia.pellet.api.term.entity.Entity;
import com.clarkparsia.pellet.api.term.function.Function;
import com.clarkparsia.pellet.function.FunctionArgs;
import com.clarkparsia.pellet.function.FunctionEvaluator;
import com.clarkparsia.pellet.function.ValueFunction;
import java.net.URI;
import java.net.URISyntaxException;

public class URIFunctions {
    public static final FunctionEvaluator RESOLVE_URI = new ResolveURI();
    public static final FunctionEvaluator ANY_URI = new AnyURI();

    private static class ResolveURI
    extends ValueFunction {
        private ResolveURI() {
        }

        @Override
        public Function getFunction() {
            return Functions.RESOLVE_URI;
        }

        @Override
        protected Entity internalEval(FunctionArgs args) {
            URI baseURI;
            URI relativeURI;
            String relative = args.getString(0);
            String base = args.getString(1);
            if (relative.length() == 0) {
                return TermFactory.literal(relative);
            }
            try {
                relativeURI = new URI(relative);
                if (relativeURI.isAbsolute()) {
                    return TermFactory.literal(relative);
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Relative URI reference is not a valid URI");
            }
            try {
                baseURI = new URI(base);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Base URI reference is not a valid URI");
            }
            try {
                URI ret = new URI(baseURI.toASCIIString() + relativeURI.toASCIIString());
                return TermFactory.literal(ret.toASCIIString());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Evaluation of base and relative URI is not a URI");
            }
        }
    }

    private static class AnyURI
    extends ValueFunction {
        private AnyURI() {
        }

        @Override
        public Function getFunction() {
            return Functions.ANY_URI;
        }

        @Override
        protected Entity internalEval(FunctionArgs args) {
            Object schema = args.getString(0);
            Object host = args.getString(1);
            Object port = args.getString(2);
            Object path = args.getString(3);
            Object query = args.getString(4);
            Object fragment = args.getString(5);
            if (!((String)schema).endsWith(":")) {
                schema = (String)schema + ":";
            }
            if (!((String)host).startsWith("//")) {
                host = "//" + (String)host;
            }
            if (((String)port).length() > 0 && !((String)port).startsWith(":")) {
                port = ":" + (String)port;
            }
            if (((String)path).length() > 0 && !((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            if (((String)query).length() > 0 && !((String)query).startsWith("?")) {
                query = "?" + (String)query;
            }
            if (((String)fragment).length() > 0 && !((String)fragment).startsWith("#")) {
                fragment = "#" + (String)fragment;
            }
            try {
                URI uri = new URI((String)schema + (String)host + (String)port + (String)path + (String)query + (String)fragment);
                return TermFactory.literal(uri.toASCIIString());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Returned string is not a URI");
            }
        }
    }
}

