/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.function;

import com.clarkparsia.pellet.api.term.builtins.Functions;
import com.clarkparsia.pellet.api.term.function.Function;
import com.clarkparsia.pellet.function.NumericFunction;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

public class NumericFunctions {
    public static final NumericFunction ABS = new Abs();
    public static final NumericFunction ADD = new Add();
    public static final NumericFunction CEILING = new Ceiling();
    public static final NumericFunction COS = new Cos();
    public static final NumericFunction DIVIDE = new Divide();
    public static final NumericFunction FLOOR = new Floor();
    public static final NumericFunction INTEGER_DIVIDE = new IntegerDivide();
    public static final NumericFunction MOD = new Mod();
    public static final NumericFunction MULTIPLY = new Multiply();
    public static final NumericFunction POW = new Pow();
    public static final NumericFunction ROUND = new Round();
    public static final NumericFunction ROUND_HALF_TO_EVEN = new RoundHalfToEven();
    public static final NumericFunction SIN = new Sin();
    public static final NumericFunction SUBTRACT = new Subtract();
    public static final NumericFunction TAN = new Tan();
    public static final NumericFunction UNARY_MINUS = new UnaryMinus();
    public static final NumericFunction UNARY_PLUS = new UnaryPlus();
    private static final BigInteger BIGINTMAX = new BigInteger("2147483647");
    private static final BigInteger BIGINTMIN = new BigInteger("-2147483648");

    private static class Abs
    extends NumericFunction {
        private Abs() {
        }

        @Override
        public Function getFunction() {
            return Functions.ABS;
        }

        @Override
        public BigDecimal apply(BigDecimal ... args) {
            if (args.length != 1) {
                return null;
            }
            return args[0].abs();
        }

        @Override
        public BigInteger apply(BigInteger ... args) {
            if (args.length != 1) {
                return null;
            }
            return args[0].abs();
        }

        @Override
        public Double apply(Double ... args) {
            if (args.length != 1) {
                return null;
            }
            return Math.abs(args[0]);
        }

        @Override
        public Float apply(Float ... args) {
            if (args.length != 1) {
                return null;
            }
            return Float.valueOf(Math.abs(args[0].floatValue()));
        }
    }

    private static class Add
    extends NumericFunction {
        private Add() {
        }

        @Override
        public Function getFunction() {
            return Functions.ADD;
        }

        @Override
        public BigDecimal apply(BigDecimal ... args) {
            if (args.length < 1) {
                return null;
            }
            BigDecimal sum = args[0];
            for (int i = 1; i < args.length; ++i) {
                sum = sum.add(args[i]);
            }
            return sum;
        }

        @Override
        public BigInteger apply(BigInteger ... args) {
            if (args.length < 1) {
                return null;
            }
            BigInteger sum = args[0];
            for (int i = 1; i < args.length; ++i) {
                sum = sum.add(args[i]);
            }
            return sum;
        }

        @Override
        public Double apply(Double ... args) {
            if (args.length < 1) {
                return null;
            }
            double sum = args[0];
            for (int i = 1; i < args.length; ++i) {
                sum += args[i].doubleValue();
            }
            return sum;
        }

        @Override
        public Float apply(Float ... args) {
            if (args.length < 1) {
                return null;
            }
            float sum = args[0].floatValue();
            for (int i = 1; i < args.length; ++i) {
                sum += args[i].floatValue();
            }
            return Float.valueOf(sum);
        }
    }

    private static class Ceiling
    extends NumericFunction {
        private Ceiling() {
        }

        @Override
        public Function getFunction() {
            return Functions.CEILING;
        }

        @Override
        public BigDecimal apply(BigDecimal ... args) {
            if (args.length != 1) {
                return null;
            }
            return args[0].setScale(0, 2).stripTrailingZeros();
        }

        @Override
        public BigInteger apply(BigInteger ... args) {
            if (args.length != 1) {
                return null;
            }
            return args[0];
        }

        @Override
        public Double apply(Double ... args) {
            if (args.length != 1) {
                return null;
            }
            return Math.ceil(args[0]);
        }

        @Override
        public Float apply(Float ... args) {
            if (args.length != 1) {
                return null;
            }
            return Float.valueOf((float)Math.ceil(args[0].floatValue()));
        }
    }

    private static class Cos
    extends NumericFunction {
        private Cos() {
        }

        @Override
        public Function getFunction() {
            return Functions.COS;
        }

        @Override
        public Double apply(BigDecimal ... args) {
            if (args.length != 1) {
                return null;
            }
            return this.apply(args[0].doubleValue());
        }

        @Override
        public Double apply(BigInteger ... args) {
            if (args.length != 1) {
                return null;
            }
            return this.apply(args[0].doubleValue());
        }

        @Override
        public Double apply(Double ... args) {
            if (args.length != 1) {
                return null;
            }
            return Math.cos(args[0]);
        }

        @Override
        public Double apply(Float ... args) {
            if (args.length != 1) {
                return null;
            }
            return this.apply(args[0].doubleValue());
        }
    }

    private static class Divide
    extends NumericFunction {
        private Divide() {
        }

        @Override
        public Function getFunction() {
            return Functions.DIVIDE;
        }

        @Override
        public BigDecimal apply(BigDecimal ... args) {
            if (args.length != 2) {
                return null;
            }
            if (args[1].equals(BigDecimal.ZERO)) {
                return null;
            }
            BigDecimal result = args[0].divide(args[1], MathContext.DECIMAL128);
            return result;
        }

        @Override
        public BigDecimal apply(BigInteger ... args) {
            if (args.length != 2) {
                return null;
            }
            if (args[1].equals(BigInteger.ZERO)) {
                return null;
            }
            BigDecimal first = new BigDecimal(args[0]);
            BigDecimal second = new BigDecimal(args[1]);
            return first.divide(second, MathContext.DECIMAL128);
        }

        @Override
        public Double apply(Double ... args) {
            if (args.length != 2) {
                return null;
            }
            return args[0] / args[1];
        }

        @Override
        public Float apply(Float ... args) {
            if (args.length != 2) {
                return null;
            }
            return Float.valueOf(args[0].floatValue() / args[1].floatValue());
        }
    }

    private static class Floor
    extends NumericFunction {
        private Floor() {
        }

        @Override
        public Function getFunction() {
            return Functions.FLOOR;
        }

        @Override
        public BigDecimal apply(BigDecimal ... args) {
            if (args.length != 1) {
                return null;
            }
            return args[0].setScale(0, 3).stripTrailingZeros();
        }

        @Override
        public BigInteger apply(BigInteger ... args) {
            if (args.length != 1) {
                return null;
            }
            return args[0];
        }

        @Override
        public Double apply(Double ... args) {
            if (args.length != 1) {
                return null;
            }
            return Math.floor(args[0]);
        }

        @Override
        public Float apply(Float ... args) {
            if (args.length != 1) {
                return null;
            }
            return Float.valueOf((float)Math.floor(args[0].floatValue()));
        }
    }

    private static class IntegerDivide
    extends NumericFunction {
        private IntegerDivide() {
        }

        @Override
        public Function getFunction() {
            return Functions.INTEGER_DIVIDE;
        }

        @Override
        public BigInteger apply(BigDecimal ... args) {
            if (args.length != 2) {
                return null;
            }
            if (args[1].equals(BigDecimal.ZERO)) {
                return null;
            }
            return args[0].divideToIntegralValue(args[1], MathContext.DECIMAL128).toBigIntegerExact();
        }

        @Override
        public BigInteger apply(BigInteger ... args) {
            if (args.length != 2) {
                return null;
            }
            if (args[1].equals(BigInteger.ZERO)) {
                return null;
            }
            return args[0].divide(args[1]);
        }

        @Override
        public BigInteger apply(Double ... args) {
            if (args.length != 2) {
                return null;
            }
            double result = args[0] / args[1];
            if (Double.isInfinite(result) || Double.isNaN(result)) {
                return null;
            }
            return new BigDecimal(result).toBigInteger();
        }

        @Override
        public BigInteger apply(Float ... args) {
            if (args.length != 2) {
                return null;
            }
            float result = args[0].floatValue() / args[1].floatValue();
            if (Float.isInfinite(result) || Float.isNaN(result)) {
                return null;
            }
            return new BigDecimal(result).toBigInteger();
        }
    }

    private static class Mod
    extends NumericFunction {
        private Mod() {
        }

        @Override
        public Function getFunction() {
            return Functions.MOD;
        }

        @Override
        public BigDecimal apply(BigDecimal ... args) {
            if (args.length != 2) {
                return null;
            }
            if (args[1].equals(BigDecimal.ZERO)) {
                return null;
            }
            return args[0].remainder(args[1], MathContext.DECIMAL128);
        }

        @Override
        public BigInteger apply(BigInteger ... args) {
            if (args.length != 2) {
                return null;
            }
            if (args[1].equals(BigInteger.ZERO)) {
                return null;
            }
            return args[0].remainder(args[1]);
        }

        @Override
        public Double apply(Double ... args) {
            if (args.length != 2) {
                return null;
            }
            return args[0] % args[1];
        }

        @Override
        public Float apply(Float ... args) {
            if (args.length != 2) {
                return null;
            }
            return Float.valueOf(args[0].floatValue() % args[1].floatValue());
        }
    }

    private static class Multiply
    extends NumericFunction {
        private Multiply() {
        }

        @Override
        public Function getFunction() {
            return Functions.MULTIPLY;
        }

        @Override
        public BigDecimal apply(BigDecimal ... args) {
            if (args.length < 1) {
                return null;
            }
            BigDecimal result = args[0];
            for (int i = 1; i < args.length; ++i) {
                result = result.multiply(args[i]);
            }
            return result;
        }

        @Override
        public BigInteger apply(BigInteger ... args) {
            if (args.length < 1) {
                return null;
            }
            BigInteger result = args[0];
            for (int i = 1; i < args.length; ++i) {
                result = result.multiply(args[i]);
            }
            return result;
        }

        @Override
        public Double apply(Double ... args) {
            if (args.length < 1) {
                return null;
            }
            double result = args[0];
            for (int i = 1; i < args.length; ++i) {
                result *= args[i].doubleValue();
            }
            return result;
        }

        @Override
        public Float apply(Float ... args) {
            if (args.length < 1) {
                return null;
            }
            float result = args[0].floatValue();
            for (int i = 1; i < args.length; ++i) {
                result *= args[i].floatValue();
            }
            return Float.valueOf(result);
        }
    }

    private static class Pow
    extends NumericFunction {
        private Pow() {
        }

        @Override
        public Function getFunction() {
            return Functions.POW;
        }

        @Override
        public BigDecimal apply(BigDecimal ... args) {
            if (args.length != 2) {
                return null;
            }
            try {
                BigDecimal result = args[0].pow(args[1].intValueExact(), MathContext.DECIMAL128);
                return result;
            }
            catch (ArithmeticException e) {
                return null;
            }
        }

        @Override
        public BigInteger apply(BigInteger ... args) {
            if (args.length != 2) {
                return null;
            }
            if (args[1].compareTo(BIGINTMAX) > 0 || args[1].compareTo(BigInteger.ZERO) < 0) {
                return null;
            }
            return args[0].pow(args[1].intValue());
        }

        @Override
        public Double apply(Double ... args) {
            if (args.length != 2) {
                return null;
            }
            return Math.pow(args[0], args[1]);
        }

        @Override
        public Float apply(Float ... args) {
            if (args.length != 2) {
                return null;
            }
            return Float.valueOf((float)Math.pow(args[0].floatValue(), args[1].floatValue()));
        }
    }

    private static class Round
    extends NumericFunction {
        BigDecimal HALF = new BigDecimal("0.5");

        private Round() {
        }

        @Override
        public Function getFunction() {
            return Functions.ROUND;
        }

        @Override
        public BigDecimal apply(BigDecimal ... args) {
            if (args.length != 1) {
                return null;
            }
            return args[0].add(this.HALF).setScale(0, 3).stripTrailingZeros();
        }

        @Override
        public BigInteger apply(BigInteger ... args) {
            if (args.length != 1) {
                return null;
            }
            return args[0];
        }

        @Override
        public Double apply(Double ... args) {
            if (args.length != 1) {
                return null;
            }
            return Math.round(args[0]);
        }

        @Override
        public Float apply(Float ... args) {
            if (args.length != 1) {
                return null;
            }
            return Float.valueOf(Math.round(args[0].floatValue()));
        }
    }

    private static class RoundHalfToEven
    extends NumericFunction {
        private RoundHalfToEven() {
        }

        @Override
        public Function getFunction() {
            return Functions.ROUND_HALF_TO_EVEN;
        }

        @Override
        public BigDecimal apply(BigDecimal ... args) {
            if (args.length < 1 || args.length > 2) {
                return null;
            }
            int scale = 0;
            if (args.length == 2) {
                if (args[1].stripTrailingZeros().scale() > 0) {
                    return null;
                }
                BigInteger bigScale = args[1].toBigInteger();
                if (bigScale.compareTo(BIGINTMAX) > 0 || bigScale.compareTo(BIGINTMIN) < 0) {
                    return null;
                }
                scale = bigScale.intValue();
            }
            return args[0].setScale(scale, 6).stripTrailingZeros();
        }

        @Override
        public BigInteger apply(BigInteger ... args) {
            if (args.length < 1 || args.length > 2) {
                return null;
            }
            return args[0];
        }

        @Override
        public Double apply(Double ... args) {
            if (args.length < 1 || args.length > 2) {
                return null;
            }
            BigDecimal[] decs = new BigDecimal[args.length];
            for (int i = 0; i < args.length; ++i) {
                decs[i] = new BigDecimal(args[i].toString());
            }
            return this.apply(decs).doubleValue();
        }

        @Override
        public Float apply(Float ... args) {
            if (args.length < 1 || args.length > 2) {
                return null;
            }
            BigDecimal[] decs = new BigDecimal[args.length];
            for (int i = 0; i < args.length; ++i) {
                decs[i] = new BigDecimal(args[i].toString());
            }
            return Float.valueOf(this.apply(decs).floatValue());
        }
    }

    private static class Sin
    extends NumericFunction {
        private Sin() {
        }

        @Override
        public Function getFunction() {
            return Functions.SIN;
        }

        @Override
        public Double apply(BigDecimal ... args) {
            if (args.length != 1) {
                return null;
            }
            return this.apply(args[0].doubleValue());
        }

        @Override
        public Double apply(BigInteger ... args) {
            if (args.length != 1) {
                return null;
            }
            return this.apply(args[0].doubleValue());
        }

        @Override
        public Double apply(Double ... args) {
            if (args.length != 1) {
                return null;
            }
            return Math.sin(args[0]);
        }

        @Override
        public Double apply(Float ... args) {
            if (args.length != 1) {
                return null;
            }
            return this.apply(args[0].doubleValue());
        }
    }

    private static class Subtract
    extends NumericFunction {
        private Subtract() {
        }

        @Override
        public Function getFunction() {
            return Functions.SUBTRACT;
        }

        @Override
        public BigDecimal apply(BigDecimal ... args) {
            if (args.length != 2) {
                return null;
            }
            BigDecimal result = args[0].subtract(args[1]);
            return result;
        }

        @Override
        public BigInteger apply(BigInteger ... args) {
            if (args.length != 2) {
                return null;
            }
            BigInteger result = args[0].subtract(args[1]);
            return result;
        }

        @Override
        public Double apply(Double ... args) {
            if (args.length != 2) {
                return null;
            }
            return args[0] - args[1];
        }

        @Override
        public Float apply(Float ... args) {
            if (args.length != 2) {
                return null;
            }
            return Float.valueOf(args[0].floatValue() - args[1].floatValue());
        }
    }

    private static class Tan
    extends NumericFunction {
        private Tan() {
        }

        @Override
        public Function getFunction() {
            return Functions.TAN;
        }

        @Override
        public Double apply(BigDecimal ... args) {
            if (args.length != 1) {
                return null;
            }
            return this.apply(args[0].doubleValue());
        }

        @Override
        public Double apply(BigInteger ... args) {
            if (args.length != 1) {
                return null;
            }
            return this.apply(args[0].doubleValue());
        }

        @Override
        public Double apply(Double ... args) {
            if (args.length != 1) {
                return null;
            }
            return Math.tan(args[0]);
        }

        @Override
        public Double apply(Float ... args) {
            if (args.length != 1) {
                return null;
            }
            return this.apply(args[0].doubleValue());
        }
    }

    private static class UnaryMinus
    extends NumericFunction {
        private UnaryMinus() {
        }

        @Override
        public Function getFunction() {
            return Functions.UNARY_MINUS;
        }

        @Override
        public BigDecimal apply(BigDecimal ... args) {
            if (args.length != 1) {
                return null;
            }
            return args[0].negate();
        }

        @Override
        public BigInteger apply(BigInteger ... args) {
            if (args.length != 1) {
                return null;
            }
            return args[0].negate();
        }

        @Override
        public Double apply(Double ... args) {
            if (args.length != 1) {
                return null;
            }
            return 0.0 - args[0];
        }

        @Override
        public Float apply(Float ... args) {
            if (args.length != 1) {
                return null;
            }
            return Float.valueOf(0.0f - args[0].floatValue());
        }
    }

    private static class UnaryPlus
    extends NumericFunction {
        private UnaryPlus() {
        }

        @Override
        public Function getFunction() {
            return Functions.UNARY_PLUS;
        }

        @Override
        public BigDecimal apply(BigDecimal ... args) {
            if (args.length != 1) {
                return null;
            }
            return args[0];
        }

        @Override
        public BigInteger apply(BigInteger ... args) {
            if (args.length != 1) {
                return null;
            }
            return args[0];
        }

        @Override
        public Double apply(Double ... args) {
            if (args.length != 1) {
                return null;
            }
            return args[0];
        }

        @Override
        public Float apply(Float ... args) {
            if (args.length != 1) {
                return null;
            }
            return args[0];
        }
    }
}

