/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.function;

import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.api.term.entity.LiteralValue;
import com.clarkparsia.pellet.function.NumericVisitor;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberToLiteralVisitor
implements NumericVisitor<LiteralValue> {
    private void argCheck(Number ... args) {
        if (args.length != 1) {
            throw new RuntimeException("Wrong number of arguments to visitor.");
        }
    }

    @Override
    public LiteralValue apply(BigDecimal ... args) {
        this.argCheck(args);
        return TermFactory.literal(args[0].toString(), Datatypes.DECIMAL);
    }

    @Override
    public LiteralValue apply(BigInteger ... args) {
        this.argCheck(args);
        return TermFactory.literal(args[0].toString(), Datatypes.INTEGER);
    }

    @Override
    public LiteralValue apply(Double ... args) {
        this.argCheck(args);
        return TermFactory.literal(args[0].toString(), Datatypes.DOUBLE);
    }

    @Override
    public LiteralValue apply(Float ... args) {
        this.argCheck(args);
        return TermFactory.literal(args[0].toString(), Datatypes.FLOAT);
    }
}

