/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.function;

import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.api.term.builtins.Functions;
import com.clarkparsia.pellet.api.term.entity.Entity;
import com.clarkparsia.pellet.api.term.entity.NamedDatatype;
import com.clarkparsia.pellet.api.term.function.Function;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.DatatypeReasoner;
import com.clarkparsia.pellet.datatypes.DatatypeReasonerImpl;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.exceptions.UnrecognizedDatatypeException;
import com.clarkparsia.pellet.datatypes.types.duration.XSDDuration;
import com.clarkparsia.pellet.function.FunctionArgs;
import com.clarkparsia.pellet.function.FunctionEvaluator;
import com.clarkparsia.pellet.function.StringFunction;
import com.clarkparsia.pellet.function.ValueFunction;
import javax.xml.datatype.Duration;

public class DateTimeFunctions {
    public static final FunctionEvaluator DATE = new Date();
    public static final FunctionEvaluator DATE_TIME = new DateTime();
    public static final FunctionEvaluator DAY_TIME_DURATION = new DayTimeDuration();
    public static final FunctionEvaluator TIME = new Time();
    public static final FunctionEvaluator YEAR_MONTH_DURATION = new YearTimeDuration();
    private static DatatypeReasoner dr = new DatatypeReasonerImpl();

    private static boolean checkValue(String val, NamedDatatype name) {
        try {
            Object obj = dr.getValue(TermFactory.literal(val, name));
            if (obj == null) {
                return false;
            }
        }
        catch (InvalidLiteralException e) {
            return false;
        }
        catch (UnrecognizedDatatypeException e) {
            return false;
        }
        return true;
    }

    private static String pad(int p, String s) {
        while (((String)s).length() < p) {
            s = "0" + (String)s;
        }
        return s;
    }

    private static String toDate(String year, String month, String day) {
        return DateTimeFunctions.pad(4, year) + "-" + DateTimeFunctions.pad(2, month) + "-" + DateTimeFunctions.pad(2, day);
    }

    private static String toTime(String hour, String minute, String second) {
        String millis = "";
        int point = second.indexOf(46);
        if (point >= 0) {
            millis = second.substring(point);
            second = second.substring(0, point);
        }
        return DateTimeFunctions.pad(2, hour) + ":" + DateTimeFunctions.pad(2, minute) + ":" + DateTimeFunctions.pad(2, second) + millis;
    }

    private static class Date
    extends StringFunction {
        public Date() {
            super(Datatypes.DATE);
        }

        @Override
        public Function getFunction() {
            return Functions.DATE;
        }

        @Override
        public String internalEvalString(FunctionArgs args) {
            String dateString;
            String tz = "";
            if (args.size() == 4) {
                tz = args.getString(3);
            }
            if (!DateTimeFunctions.checkValue(dateString = DateTimeFunctions.toDate(args.getString(0), args.getString(1), args.getString(2)) + tz, Datatypes.DATE)) {
                return null;
            }
            return dateString;
        }
    }

    private static class DateTime
    extends StringFunction {
        public DateTime() {
            super(Datatypes.DATE_TIME);
        }

        @Override
        public Function getFunction() {
            return Functions.DATE_TIME;
        }

        @Override
        public String internalEvalString(FunctionArgs args) {
            String dateTimeString;
            String tz = "";
            if (args.size() == 7) {
                tz = args.getString(6);
            }
            if (!DateTimeFunctions.checkValue(dateTimeString = DateTimeFunctions.toDate(args.getString(0), args.getString(1), args.getString(2)) + "T" + DateTimeFunctions.toTime(args.getString(3), args.getString(4), args.getString(5)) + tz, Datatypes.DATE_TIME)) {
                return null;
            }
            return dateTimeString;
        }
    }

    private static class DayTimeDuration
    extends ValueFunction {
        private DayTimeDuration() {
        }

        @Override
        public Function getFunction() {
            return Functions.DAY_TIME_DURATION;
        }

        @Override
        public Entity internalEval(FunctionArgs args) {
            int days = Integer.parseInt(args.getString(0));
            int hours = Integer.parseInt(args.getString(1));
            int mins = Integer.parseInt(args.getString(2));
            int secs = Integer.parseInt(args.getString(3));
            Duration dur = Datatype.FACTORY.newDurationDayTime(days > 0, Math.abs(days), hours, mins, secs);
            return XSDDuration.getInstance().getLiteral(dur);
        }
    }

    private static class Time
    extends StringFunction {
        public Time() {
            super(Datatypes.TIME);
        }

        @Override
        public Function getFunction() {
            return Functions.TIME;
        }

        @Override
        public String internalEvalString(FunctionArgs args) {
            String timeString;
            String tz = "";
            if (args.size() == 4) {
                tz = args.getString(3);
            }
            if (!DateTimeFunctions.checkValue(timeString = DateTimeFunctions.toTime(args.getString(0), args.getString(1), args.getString(2)) + tz, Datatypes.TIME)) {
                return null;
            }
            return timeString;
        }
    }

    private static class YearTimeDuration
    extends ValueFunction {
        private YearTimeDuration() {
        }

        @Override
        public Function getFunction() {
            return Functions.YEAR_MONTH_DURATION;
        }

        @Override
        public Entity internalEval(FunctionArgs args) {
            int years = Integer.parseInt(args.getString(0));
            int months = Integer.parseInt(args.getString(1));
            Duration dur = Datatype.FACTORY.newDurationYearMonth(years > 0, Math.abs(years), months);
            return XSDDuration.getInstance().getLiteral(dur);
        }
    }
}

