/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.uri;

import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.api.term.entity.Literal;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDataRange;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.uri.RestrictedURIDataRange;
import java.net.URI;
import java.net.URISyntaxException;

public class XSDAnyURI
extends AbstractBaseDatatype<Literal> {
    private static final XSDAnyURI instance = new XSDAnyURI();
    private final RestrictedDataRange<Literal> dataRange = new RestrictedURIDataRange(this);

    public static XSDAnyURI getInstance() {
        return instance;
    }

    private XSDAnyURI() {
        super(Datatypes.ANY_URI);
    }

    @Override
    public RestrictedDataRange<Literal> asDataRange() {
        return this.dataRange;
    }

    @Override
    public Literal getCanonicalRepresentation(Literal input) throws InvalidLiteralException {
        return this.getValue(input);
    }

    @Override
    public Literal getLiteral(Object value) {
        return (Literal)value;
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Literal getValue(Literal literal) throws InvalidLiteralException {
        String lexicalForm = literal.getLexicalValue().trim();
        try {
            return TermFactory.literal(new URI(lexicalForm).normalize().toString(), Datatypes.ANY_URI);
        }
        catch (URISyntaxException e) {
            throw new InvalidLiteralException(this.getName(), literal);
        }
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }
}

