/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.text;

import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.entity.Literal;
import com.clarkparsia.pellet.api.term.entity.NamedDatatype;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDataRange;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.text.RestrictedTextDataRange;
import com.clarkparsia.pellet.datatypes.types.text.XSDString;

public class AbstractTextDatatype
extends AbstractBaseDatatype<Literal> {
    private static final XSDString RDF_PLAIN_LITERAL = XSDString.getInstance();
    private final RestrictedDataRange<Literal> dataRange;

    protected AbstractTextDatatype(NamedDatatype name, String pattern) {
        super(name);
        this.dataRange = new RestrictedTextDataRange((Datatype<Literal>)this, pattern);
    }

    @Override
    public RestrictedDataRange<Literal> asDataRange() {
        return this.dataRange;
    }

    @Override
    public Literal getCanonicalRepresentation(Literal input) throws InvalidLiteralException {
        return this.getValue(input);
    }

    @Override
    public Literal getLiteral(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return RDF_PLAIN_LITERAL;
    }

    @Override
    public Literal getValue(Literal literal) throws InvalidLiteralException {
        String lexicalForm = literal.getLexicalValue();
        return RDF_PLAIN_LITERAL.getCanonicalRepresentation(TermFactory.literal(lexicalForm));
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }
}

