/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.AbstractDerivedIntegerType;
import jakarta.xml.bind.DatatypeConverter;

public class XSDUnsignedShort
extends AbstractDerivedIntegerType {
    private static final XSDUnsignedShort instance;
    public static final int MAX_VALUE;

    public static XSDUnsignedShort getInstance() {
        return instance;
    }

    private XSDUnsignedShort() {
        super(Datatypes.UNSIGNED_SHORT, 0, MAX_VALUE);
    }

    @Override
    protected Number fromLexicalForm(String lexicalForm) throws InvalidLiteralException {
        try {
            int i = DatatypeConverter.parseInt((String)lexicalForm);
            if (i < 0) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            if (i > MAX_VALUE) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            return i;
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.getName(), lexicalForm);
        }
    }

    static {
        MAX_VALUE = 65535;
        instance = new XSDUnsignedShort();
    }
}

