/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.AbstractDerivedIntegerType;
import jakarta.xml.bind.DatatypeConverter;
import java.math.BigInteger;

public class XSDUnsignedLong
extends AbstractDerivedIntegerType {
    private static final XSDUnsignedLong instance;
    public static final BigInteger MAX_VALUE;

    public static XSDUnsignedLong getInstance() {
        return instance;
    }

    private XSDUnsignedLong() {
        super(Datatypes.UNSIGNED_LONG, 0, MAX_VALUE);
    }

    @Override
    protected Number fromLexicalForm(String lexicalForm) throws InvalidLiteralException {
        try {
            BigInteger n = DatatypeConverter.parseInteger((String)lexicalForm);
            if (BigInteger.ZERO.compareTo(n) > 0) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            if (MAX_VALUE.compareTo(n) < 0) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            return n;
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.getName(), lexicalForm);
        }
    }

    static {
        MAX_VALUE = new BigInteger("18446744073709551615");
        instance = new XSDUnsignedLong();
    }
}

