/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.AbstractDerivedIntegerType;
import jakarta.xml.bind.DatatypeConverter;

public class XSDUnsignedInt
extends AbstractDerivedIntegerType {
    private static final XSDUnsignedInt instance;
    public static final long MAX_VALUE;

    public static XSDUnsignedInt getInstance() {
        return instance;
    }

    private XSDUnsignedInt() {
        super(Datatypes.UNSIGNED_INT, 0, MAX_VALUE);
    }

    @Override
    protected Number fromLexicalForm(String lexicalForm) throws InvalidLiteralException {
        try {
            long l = DatatypeConverter.parseLong((String)lexicalForm);
            if (l < 0L) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            if (l > MAX_VALUE) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            return l;
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.getName(), lexicalForm);
        }
    }

    static {
        MAX_VALUE = 0xFFFFFFFFL;
        instance = new XSDUnsignedInt();
    }
}

