/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.AbstractDerivedIntegerType;
import jakarta.xml.bind.DatatypeConverter;

public class XSDShort
extends AbstractDerivedIntegerType {
    private static final XSDShort instance = new XSDShort();

    public static XSDShort getInstance() {
        return instance;
    }

    private XSDShort() {
        super(Datatypes.SHORT, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE);
    }

    @Override
    protected Number fromLexicalForm(String lexicalForm) throws InvalidLiteralException {
        try {
            int n = DatatypeConverter.parseInt((String)lexicalForm);
            if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            return (short)n;
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.getName(), lexicalForm);
        }
    }
}

