/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.AbstractDerivedIntegerType;
import jakarta.xml.bind.DatatypeConverter;
import java.math.BigInteger;

public class XSDPositiveInteger
extends AbstractDerivedIntegerType {
    private static final XSDPositiveInteger instance = new XSDPositiveInteger();

    public static XSDPositiveInteger getInstance() {
        return instance;
    }

    private XSDPositiveInteger() {
        super(Datatypes.POSITIVE_INTEGER, 1, null);
    }

    @Override
    protected Number fromLexicalForm(String lexicalForm) throws InvalidLiteralException {
        try {
            BigInteger n = DatatypeConverter.parseInteger((String)lexicalForm);
            if (BigInteger.ZERO.compareTo(n) >= 0) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            return n;
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.getName(), lexicalForm);
        }
    }
}

