/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.AbstractDerivedIntegerType;
import jakarta.xml.bind.DatatypeConverter;
import java.math.BigInteger;

public class XSDNonNegativeInteger
extends AbstractDerivedIntegerType {
    private static final XSDNonNegativeInteger instance = new XSDNonNegativeInteger();

    public static XSDNonNegativeInteger getInstance() {
        return instance;
    }

    private XSDNonNegativeInteger() {
        super(Datatypes.NON_NEGATIVE_INTEGER, 0, null);
    }

    @Override
    protected Number fromLexicalForm(String lexicalForm) throws InvalidLiteralException {
        try {
            BigInteger n = DatatypeConverter.parseInteger((String)lexicalForm);
            if (BigInteger.ZERO.compareTo(n) > 0) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            return n;
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.getName(), lexicalForm);
        }
    }
}

