/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.api.term.entity.Literal;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import com.clarkparsia.pellet.datatypes.RestrictedDataRange;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.ContinuousRealInterval;
import com.clarkparsia.pellet.datatypes.types.real.IntegerInterval;
import com.clarkparsia.pellet.datatypes.types.real.RestrictedRealDataRange;
import jakarta.xml.bind.DatatypeConverter;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XSDDecimal
extends AbstractBaseDatatype<Number> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XSDDecimal.class);
    private static final XSDDecimal instance = new XSDDecimal();
    private final RestrictedRealDataRange dataRange = new RestrictedRealDataRange(this, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), null);

    public static XSDDecimal getInstance() {
        return instance;
    }

    private XSDDecimal() {
        super(Datatypes.DECIMAL);
    }

    @Override
    public RestrictedDataRange<Number> asDataRange() {
        return this.dataRange;
    }

    @Override
    public Literal getCanonicalRepresentation(Literal input) throws InvalidLiteralException {
        String lexicalForm = input.getLexicalValue();
        try {
            BigDecimal d = DatatypeConverter.parseDecimal((String)lexicalForm);
            String canonicalForm = DatatypeConverter.printDecimal((BigDecimal)d);
            if (canonicalForm.equals(lexicalForm)) {
                return input;
            }
            return TermFactory.literal(canonicalForm, this.getName());
        }
        catch (NumberFormatException e) {
            LOGGER.error("Number format exception ({}) cause while parsing decimal {}", (Object)e.getMessage(), (Object)lexicalForm);
            throw new InvalidLiteralException(this.getName(), lexicalForm);
        }
    }

    @Override
    public Literal getLiteral(Object value) {
        if (this.dataRange.contains(value)) {
            return TermFactory.literal(OWLRealUtils.print((Number)value), this.getName());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Number getValue(Literal literal) throws InvalidLiteralException {
        String lexicalForm = literal.getLexicalValue();
        try {
            return OWLRealUtils.getCanonicalObject(DatatypeConverter.parseDecimal((String)lexicalForm));
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.getName(), lexicalForm);
        }
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }
}

