/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.api.term.entity.Literal;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDataRange;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.ContinuousRealInterval;
import com.clarkparsia.pellet.datatypes.types.real.IntegerInterval;
import com.clarkparsia.pellet.datatypes.types.real.OWLRational;
import com.clarkparsia.pellet.datatypes.types.real.Rational;
import com.clarkparsia.pellet.datatypes.types.real.RestrictedRealDataRange;
import com.clarkparsia.pellet.datatypes.types.real.XSDDecimal;

public class OWLReal
extends AbstractBaseDatatype<Number> {
    private static final OWLReal instance = new OWLReal();
    private final RestrictedRealDataRange dataRange = new RestrictedRealDataRange(this, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), ContinuousRealInterval.allReals());

    public static OWLReal getInstance() {
        return instance;
    }

    private OWLReal() {
        super(Datatypes.REAL);
    }

    @Override
    public RestrictedDataRange<Number> asDataRange() {
        return this.dataRange;
    }

    @Override
    public Literal getCanonicalRepresentation(Literal input) throws InvalidLiteralException {
        throw new InvalidLiteralException(this.getName(), input);
    }

    @Override
    public Literal getLiteral(Object value) {
        if (value instanceof Rational) {
            return OWLRational.getInstance().getLiteral(value);
        }
        if (value instanceof Number) {
            try {
                return XSDDecimal.getInstance().getLiteral(value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Number getValue(Literal literal) throws InvalidLiteralException {
        throw new InvalidLiteralException(this.getName(), literal);
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }
}

