/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.api.term.entity.Literal;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import com.clarkparsia.pellet.datatypes.RestrictedDataRange;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.ContinuousRealInterval;
import com.clarkparsia.pellet.datatypes.types.real.IntegerInterval;
import com.clarkparsia.pellet.datatypes.types.real.OWLReal;
import com.clarkparsia.pellet.datatypes.types.real.Rational;
import com.clarkparsia.pellet.datatypes.types.real.RestrictedRealDataRange;

public class OWLRational
extends AbstractBaseDatatype<Number> {
    private static final OWLRational instance = new OWLRational();
    private final RestrictedRealDataRange dataRange = new RestrictedRealDataRange(this, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), ContinuousRealInterval.allReals());

    public static OWLRational getInstance() {
        return instance;
    }

    private OWLRational() {
        super(Datatypes.RATIONAL);
    }

    @Override
    public RestrictedDataRange<Number> asDataRange() {
        return this.dataRange;
    }

    @Override
    public Literal getCanonicalRepresentation(Literal input) throws InvalidLiteralException {
        Number n = this.getValue(input);
        if (n instanceof Rational) {
            String canonicalForm = Rational.simplify((Rational)n).toString();
            if (canonicalForm.equals(input.getLexicalValue())) {
                return input;
            }
            return TermFactory.literal(canonicalForm, this.getName());
        }
        return OWLReal.getInstance().getLiteral(OWLRealUtils.getCanonicalObject(n));
    }

    @Override
    public Literal getLiteral(Object value) {
        if (value instanceof Rational) {
            Rational r = (Rational)value;
            String lexicalForm = r.toString();
            return TermFactory.literal(lexicalForm, this.getName());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return OWLReal.getInstance();
    }

    @Override
    public Number getValue(Literal literal) throws InvalidLiteralException {
        String lexicalForm = literal.getLexicalValue();
        try {
            return OWLRealUtils.getCanonicalObject(Rational.valueOf(lexicalForm));
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.getName(), literal);
        }
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }
}

