/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.floating;

import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.api.term.entity.Literal;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDataRange;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.floating.IEEEFloatType;
import com.clarkparsia.pellet.datatypes.types.floating.RestrictedFloatingPointDataRange;
import jakarta.xml.bind.DatatypeConverter;

public class XSDFloat
extends AbstractBaseDatatype<Float> {
    private static final XSDFloat instance = new XSDFloat();
    private final RestrictedFloatingPointDataRange<Float> dataRange = new RestrictedFloatingPointDataRange<Float>(this, IEEEFloatType.getInstance());

    public static XSDFloat getInstance() {
        return instance;
    }

    private XSDFloat() {
        super(Datatypes.FLOAT);
    }

    @Override
    public RestrictedDataRange<Float> asDataRange() {
        return this.dataRange;
    }

    @Override
    public Literal getCanonicalRepresentation(Literal input) throws InvalidLiteralException {
        Float f = this.getValue(input);
        String canonicalForm = DatatypeConverter.printFloat((float)f.floatValue());
        if (canonicalForm.equals(input.getLexicalValue())) {
            return input;
        }
        return TermFactory.literal(canonicalForm, this.getName());
    }

    @Override
    public Literal getLiteral(Object value) {
        if (value instanceof Float) {
            return TermFactory.literal(DatatypeConverter.printFloat((float)((Float)value).floatValue()), this.getName());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Float getValue(Literal literal) throws InvalidLiteralException {
        String lexicalForm = literal.getLexicalValue();
        try {
            return Float.valueOf(DatatypeConverter.parseFloat((String)lexicalForm));
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.getName(), literal);
        }
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }
}

