/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.duration;

import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.api.term.entity.Literal;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDataRange;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.datetime.RestrictedTimelineDataRange;
import com.clarkparsia.pellet.datatypes.types.duration.RestrictedDurationDatatype;
import javax.xml.datatype.Duration;

public class XSDDuration
extends AbstractBaseDatatype<Duration> {
    private static final XSDDuration instance = new XSDDuration();
    private final RestrictedDataRange<Duration> dataRange = new RestrictedDurationDatatype(this);

    public static XSDDuration getInstance() {
        return instance;
    }

    private XSDDuration() {
        super(Datatypes.DURATION);
    }

    @Override
    public RestrictedDataRange<Duration> asDataRange() {
        return this.dataRange;
    }

    @Override
    public Literal getCanonicalRepresentation(Literal input) throws InvalidLiteralException {
        return TermFactory.literal(this.getValue(input).toString(), Datatypes.DURATION);
    }

    @Override
    public Literal getLiteral(Object value) {
        if (value instanceof Duration) {
            return TermFactory.literal(((Duration)value).toString(), Datatypes.DURATION);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Duration getValue(Literal literal) throws InvalidLiteralException {
        String lexicalForm = literal.getLexicalValue();
        try {
            Duration c = RestrictedTimelineDataRange.getDatatypeFactory().newDuration(lexicalForm);
            return c;
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLiteralException(this.getName(), literal);
        }
        catch (IllegalStateException e) {
            throw new InvalidLiteralException(this.getName(), literal);
        }
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }
}

