/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.datetime;

import com.clarkparsia.pellet.api.term.builtins.Facets;
import com.clarkparsia.pellet.api.term.entity.Facet;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.EmptyRestrictedDatatype;
import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import com.clarkparsia.pellet.datatypes.RestrictedDataRange;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidConstrainingFacetException;
import com.clarkparsia.pellet.datatypes.types.real.ContinuousRealInterval;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestrictedTimelineDataRange
implements RestrictedDataRange<XMLGregorianCalendar> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestrictedTimelineDataRange.class);
    private static final BigInteger SEC_PER_DAY = BigInteger.valueOf(86400L);
    private static final BigInteger SEC_PER_YEAR = BigInteger.valueOf(31536000L);
    private static final int TZ_SHIFT = 50400;
    protected final Datatype<? extends XMLGregorianCalendar> datatype;
    protected final RestrictedDataRange<XMLGregorianCalendar> empty;
    protected final boolean enumerable;
    protected final boolean finite;
    protected final List<ContinuousRealInterval> nzIntervals;
    protected final QName schemaType;
    protected final List<ContinuousRealInterval> wzIntervals;

    private static Number calendarToReal(XMLGregorianCalendar c) {
        BigInteger y;
        BigInteger yrPlusOne = c.getEonAndYear();
        BigInteger bigInteger = y = yrPlusOne == null ? BigInteger.valueOf(1971L) : yrPlusOne.subtract(BigInteger.ONE);
        if (yrPlusOne == null) {
            yrPlusOne = BigInteger.valueOf(1972L);
        }
        int month = c.getMonth() == Integer.MIN_VALUE ? 12 : c.getMonth();
        int day = c.getDay() == Integer.MIN_VALUE ? RestrictedTimelineDataRange.daysInMonth(yrPlusOne, month) - 1 : c.getDay() - 1;
        int hour = c.getHour() == Integer.MIN_VALUE ? 0 : c.getHour();
        int minute = c.getMinute() == Integer.MIN_VALUE ? 0 : c.getMinute();
        int second = c.getSecond() == Integer.MIN_VALUE ? 0 : c.getSecond();
        BigDecimal fractionalSecond = c.getFractionalSecond();
        int tz = c.getTimezone();
        if (tz != Integer.MIN_VALUE) {
            minute -= tz;
        }
        BigInteger toTi = SEC_PER_YEAR.multiply(y);
        toTi = toTi.add(SEC_PER_DAY.multiply(y.divide(BigInteger.valueOf(400L)).subtract(y.divide(BigInteger.valueOf(100L))).add(y.divide(BigInteger.valueOf(4L)))));
        int daySum = day;
        for (int m = 1; m < month; ++m) {
            daySum += RestrictedTimelineDataRange.daysInMonth(yrPlusOne, m);
        }
        toTi = toTi.add(BigInteger.valueOf(86400L * (long)daySum));
        toTi = toTi.add(BigInteger.valueOf(3600L * (long)hour + 60L * (long)minute + (long)second));
        if (fractionalSecond == null || BigDecimal.ZERO.equals(fractionalSecond)) {
            return OWLRealUtils.getCanonicalObject(toTi);
        }
        return new BigDecimal(toTi).add(fractionalSecond);
    }

    private static int daysInMonth(BigInteger year, int month) {
        if (month == 2) {
            if (year.remainder(BigInteger.valueOf(4L)).equals(BigInteger.ZERO)) {
                if (year.remainder(BigInteger.valueOf(100L)).equals(BigInteger.ZERO)) {
                    if (year.remainder(BigInteger.valueOf(400L)).equals(BigInteger.ZERO)) {
                        return 29;
                    }
                    return 28;
                }
                return 29;
            }
            return 28;
        }
        switch (month) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
        }
        throw new IllegalArgumentException();
    }

    public static DatatypeFactory getDatatypeFactory() {
        return Datatype.FACTORY;
    }

    private static ContinuousRealInterval zoneShrink(ContinuousRealInterval i) {
        Number upper;
        Number lower = i.boundLower() ? (Number)OWLRealUtils.sum(i.getLower(), 50400) : (Number)null;
        Number number = upper = i.boundUpper() ? (Number)OWLRealUtils.sum(i.getUpper(), -50400) : (Number)null;
        if (lower != null && upper != null) {
            int cmp = OWLRealUtils.compare(lower, upper);
            if (cmp > 0) {
                return null;
            }
            if (cmp == 0) {
                if (!i.inclusiveLower() && !i.inclusiveUpper()) {
                    return null;
                }
                return new ContinuousRealInterval(lower);
            }
        }
        return new ContinuousRealInterval(lower, upper, i.inclusiveLower(), i.inclusiveUpper());
    }

    public RestrictedTimelineDataRange(Datatype<? extends XMLGregorianCalendar> datatype, QName schemaType, boolean requireTz) {
        this.datatype = datatype;
        this.schemaType = schemaType;
        this.empty = new EmptyRestrictedDatatype<XMLGregorianCalendar>(datatype);
        this.wzIntervals = Collections.singletonList(ContinuousRealInterval.allReals());
        this.nzIntervals = requireTz ? Collections.emptyList() : Collections.singletonList(ContinuousRealInterval.allReals());
        this.finite = false;
        this.enumerable = false;
    }

    private RestrictedTimelineDataRange(RestrictedTimelineDataRange other, List<ContinuousRealInterval> wzIntervals, List<ContinuousRealInterval> nzIntervals) {
        this.datatype = other.datatype;
        this.empty = other.empty;
        this.schemaType = other.schemaType;
        this.wzIntervals = Collections.unmodifiableList(wzIntervals);
        this.nzIntervals = Collections.unmodifiableList(nzIntervals);
        if (other.finite) {
            this.finite = true;
        } else {
            boolean allFinite = true;
            for (ContinuousRealInterval i : wzIntervals) {
                if (i.isPoint()) continue;
                allFinite = false;
                break;
            }
            if (allFinite) {
                for (ContinuousRealInterval i : wzIntervals) {
                    if (i.isPoint()) continue;
                    allFinite = false;
                    break;
                }
            }
            this.finite = allFinite;
        }
        if (other.enumerable) {
            this.enumerable = true;
        } else {
            boolean allEnumerable = nzIntervals.isEmpty();
            if (allEnumerable) {
                for (ContinuousRealInterval i : wzIntervals) {
                    if (i.isPoint()) continue;
                    allEnumerable = false;
                    break;
                }
            }
            this.enumerable = allEnumerable;
        }
    }

    @Override
    public RestrictedDataRange<XMLGregorianCalendar> applyConstrainingFacet(Facet facet, Object value) throws InvalidConstrainingFacetException {
        ContinuousRealInterval wzRestriction;
        ContinuousRealInterval nzRestriction;
        boolean inclusiveUpper;
        Number upper;
        boolean inclusiveLower;
        Number lower;
        if (facet == null) {
            String msg = String.format("Attempt to constrain datatype (%s) with unsupported constraining facet ('%s' , '%s')", this.getDatatype(), facet, value);
            LOGGER.error(msg);
            throw new InvalidConstrainingFacetException(msg, facet, value);
        }
        XMLGregorianCalendar c = null;
        if (value instanceof XMLGregorianCalendar) {
            c = (XMLGregorianCalendar)value;
        }
        if (c == null || !this.isValidValue(c)) {
            String msg = String.format("Attempt to constrain datatype (%s) using constraining facet ('%s') with an unsupported value ('%s')", this.getDatatype(), facet, value);
            LOGGER.error(msg);
            throw new InvalidConstrainingFacetException(msg, facet, value);
        }
        if (Facets.MAX_EXCLUSIVE.equals(facet)) {
            lower = null;
            inclusiveLower = false;
            upper = RestrictedTimelineDataRange.calendarToReal(c);
            inclusiveUpper = false;
        } else if (Facets.MAX_INCLUSIVE.equals(facet)) {
            lower = null;
            inclusiveLower = false;
            upper = RestrictedTimelineDataRange.calendarToReal(c);
            inclusiveUpper = true;
        } else if (Facets.MIN_EXCLUSIVE.equals(facet)) {
            lower = RestrictedTimelineDataRange.calendarToReal(c);
            inclusiveLower = false;
            upper = null;
            inclusiveUpper = false;
        } else if (Facets.MIN_INCLUSIVE.equals(facet)) {
            lower = RestrictedTimelineDataRange.calendarToReal(c);
            inclusiveLower = true;
            upper = null;
            inclusiveUpper = false;
        } else {
            throw new IllegalStateException();
        }
        ContinuousRealInterval restriction = new ContinuousRealInterval(lower, upper, inclusiveLower, inclusiveUpper);
        if (c.getTimezone() == Integer.MIN_VALUE) {
            nzRestriction = restriction;
            wzRestriction = RestrictedTimelineDataRange.zoneShrink(nzRestriction);
        } else {
            wzRestriction = restriction;
            nzRestriction = RestrictedTimelineDataRange.zoneShrink(wzRestriction);
        }
        boolean changes = false;
        ArrayList<ContinuousRealInterval> revisedWz = new ArrayList<ContinuousRealInterval>();
        if (wzRestriction == null) {
            changes = this.wzIntervals.isEmpty();
        } else {
            for (ContinuousRealInterval i : this.wzIntervals) {
                ContinuousRealInterval j = i.intersection(wzRestriction);
                if (j != null) {
                    revisedWz.add(j);
                    if (i == j) continue;
                    changes = true;
                    continue;
                }
                changes = true;
            }
        }
        ArrayList<ContinuousRealInterval> revisedNz = new ArrayList<ContinuousRealInterval>();
        if (nzRestriction == null) {
            changes |= this.nzIntervals.isEmpty();
        } else {
            for (ContinuousRealInterval i : this.nzIntervals) {
                ContinuousRealInterval j = i.intersection(nzRestriction);
                if (j != null) {
                    revisedNz.add(j);
                    if (i == j) continue;
                    changes = true;
                    continue;
                }
                changes = true;
            }
        }
        if (changes) {
            if (revisedWz.isEmpty() && revisedNz.isEmpty()) {
                return this.empty;
            }
            return this.create(this, revisedWz, revisedNz);
        }
        return this;
    }

    @Override
    public boolean contains(Object value) {
        if (value instanceof XMLGregorianCalendar) {
            XMLGregorianCalendar c = (XMLGregorianCalendar)value;
            if (this.isValidValue(c)) {
                Number n = RestrictedTimelineDataRange.calendarToReal(c);
                for (ContinuousRealInterval i : c.getTimezone() == Integer.MIN_VALUE ? this.nzIntervals : this.wzIntervals) {
                    if (!i.contains(n)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(int n) {
        if (!this.finite || n <= 0) {
            return true;
        }
        Number sum = 0;
        for (int i = 0; i < this.wzIntervals.size(); ++i) {
            sum = OWLRealUtils.integerSum(sum, 1681);
            if (OWLRealUtils.compare(n, sum) > 0) continue;
            return true;
        }
        return false;
    }

    protected RestrictedTimelineDataRange create(RestrictedTimelineDataRange other, List<ContinuousRealInterval> wzIntervals, List<ContinuousRealInterval> nzIntervals) {
        return new RestrictedTimelineDataRange(other, wzIntervals, nzIntervals);
    }

    @Override
    public RestrictedDataRange<XMLGregorianCalendar> exclude(Collection<?> values) {
        boolean changes = false;
        ArrayList<ContinuousRealInterval> revisedNz = new ArrayList<ContinuousRealInterval>(this.nzIntervals);
        block0: for (Object o : values) {
            if (!(o instanceof XMLGregorianCalendar)) continue;
            XMLGregorianCalendar c = (XMLGregorianCalendar)o;
            if (c.getTimezone() == Integer.MIN_VALUE) {
                Number n = RestrictedTimelineDataRange.calendarToReal(c);
                Iterator it = revisedNz.iterator();
                while (it.hasNext()) {
                    ContinuousRealInterval greater;
                    ContinuousRealInterval i = (ContinuousRealInterval)it.next();
                    if (!i.contains(n)) continue;
                    changes = true;
                    it.remove();
                    ContinuousRealInterval less = i.less(n);
                    if (less != null) {
                        revisedNz.add(less);
                    }
                    if ((greater = i.greater(n)) == null) continue block0;
                    revisedNz.add(greater);
                    continue block0;
                }
                continue;
            }
            LOGGER.warn("Exclusion of time zoned constants is not supported");
        }
        if (changes) {
            if (revisedNz.isEmpty() && this.wzIntervals.isEmpty()) {
                return this.empty;
            }
            return this.create(this, this.wzIntervals, revisedNz);
        }
        return this;
    }

    @Override
    public Datatype<? extends XMLGregorianCalendar> getDatatype() {
        return this.datatype;
    }

    @Override
    public XMLGregorianCalendar getValue(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RestrictedDataRange<XMLGregorianCalendar> intersect(RestrictedDataRange<?> other, boolean negated) {
        if (other instanceof RestrictedTimelineDataRange) {
            List<ContinuousRealInterval> intersectWithNz;
            List<ContinuousRealInterval> intersectWithWz;
            RestrictedTimelineDataRange otherRRD = (RestrictedTimelineDataRange)other;
            ArrayList<ContinuousRealInterval> revisedWz = new ArrayList<ContinuousRealInterval>();
            if (negated) {
                intersectWithWz = new ArrayList<ContinuousRealInterval>(Arrays.asList(ContinuousRealInterval.allReals()));
                for (ContinuousRealInterval i : otherRRD.wzIntervals) {
                    ArrayList<ContinuousRealInterval> tmp = new ArrayList<ContinuousRealInterval>();
                    for (ContinuousRealInterval j : intersectWithWz) {
                        tmp.addAll(j.remove(i));
                    }
                    intersectWithWz = tmp;
                }
            } else {
                intersectWithWz = otherRRD.wzIntervals;
            }
            for (ContinuousRealInterval i : this.wzIntervals) {
                for (ContinuousRealInterval j : intersectWithWz) {
                    ContinuousRealInterval k = i.intersection(j);
                    if (k == null) continue;
                    revisedWz.add(k);
                }
            }
            ArrayList<ContinuousRealInterval> revisedNz = new ArrayList<ContinuousRealInterval>();
            if (negated) {
                intersectWithNz = new ArrayList<ContinuousRealInterval>(Arrays.asList(ContinuousRealInterval.allReals()));
                for (ContinuousRealInterval i : otherRRD.nzIntervals) {
                    ArrayList<ContinuousRealInterval> tmp = new ArrayList<ContinuousRealInterval>();
                    for (ContinuousRealInterval j : intersectWithNz) {
                        tmp.addAll(j.remove(i));
                    }
                    intersectWithNz = tmp;
                }
            } else {
                intersectWithNz = otherRRD.nzIntervals;
            }
            for (ContinuousRealInterval i : this.nzIntervals) {
                for (ContinuousRealInterval j : intersectWithNz) {
                    ContinuousRealInterval k = i.intersection(j);
                    if (k == null) continue;
                    revisedNz.add(k);
                }
            }
            if (revisedWz.equals(this.wzIntervals) && revisedNz.equals(this.nzIntervals)) {
                return this;
            }
            if (revisedWz.isEmpty() && revisedNz.isEmpty()) {
                return this.empty;
            }
            return this.create(this, revisedWz, revisedNz);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isEnumerable() {
        return this.enumerable;
    }

    @Override
    public boolean isFinite() {
        return this.finite;
    }

    protected boolean isValidValue(XMLGregorianCalendar c) {
        return this.schemaType.equals(c.getXMLSchemaType());
    }

    @Override
    public int size() {
        if (!this.finite) {
            throw new IllegalStateException();
        }
        Number sum = 0;
        for (int i = 0; i < this.wzIntervals.size(); ++i) {
            sum = OWLRealUtils.integerSum(sum, 1681);
            if (OWLRealUtils.compare(Integer.MAX_VALUE, sum) > 0) continue;
            return Integer.MAX_VALUE;
        }
        return sum;
    }

    public String toString() {
        return String.format("{%s,%s,%s}", this.datatype, this.wzIntervals, this.nzIntervals);
    }

    @Override
    public RestrictedDataRange<XMLGregorianCalendar> union(RestrictedDataRange<?> other) {
        if (other instanceof RestrictedTimelineDataRange) {
            RestrictedTimelineDataRange otherRRD = (RestrictedTimelineDataRange)other;
            ArrayList<ContinuousRealInterval> revisedWz = new ArrayList<ContinuousRealInterval>(this.wzIntervals);
            for (ContinuousRealInterval i : otherRRD.wzIntervals) {
                ArrayList<Object> unionWith = new ArrayList<Object>();
                Iterator jt = revisedWz.iterator();
                while (jt.hasNext()) {
                    ContinuousRealInterval j = (ContinuousRealInterval)jt.next();
                    if (!i.canUnionWith(j)) continue;
                    jt.remove();
                    unionWith.add(j);
                }
                if (unionWith.isEmpty()) {
                    revisedWz.add(i);
                    continue;
                }
                HashSet<ContinuousRealInterval> tmp = new HashSet<ContinuousRealInterval>();
                for (ContinuousRealInterval continuousRealInterval : unionWith) {
                    tmp.addAll(i.union(continuousRealInterval));
                }
                revisedWz.addAll(tmp);
            }
            ArrayList<ContinuousRealInterval> revisedNz = new ArrayList<ContinuousRealInterval>(this.nzIntervals);
            for (ContinuousRealInterval i : otherRRD.nzIntervals) {
                ArrayList<ContinuousRealInterval> unionWith = new ArrayList<ContinuousRealInterval>();
                Iterator jt = revisedNz.iterator();
                while (jt.hasNext()) {
                    ContinuousRealInterval continuousRealInterval = (ContinuousRealInterval)jt.next();
                    if (!i.canUnionWith(continuousRealInterval)) continue;
                    jt.remove();
                    unionWith.add(continuousRealInterval);
                }
                if (unionWith.isEmpty()) {
                    revisedNz.add(i);
                    continue;
                }
                HashSet<ContinuousRealInterval> tmp = new HashSet<ContinuousRealInterval>();
                for (ContinuousRealInterval j : unionWith) {
                    tmp.addAll(i.union(j));
                }
                revisedNz.addAll(tmp);
            }
            return this.create(this, revisedWz, revisedNz);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Iterator<XMLGregorianCalendar> valueIterator() {
        throw new UnsupportedOperationException();
    }
}

