/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.bool;

import com.clarkparsia.pellet.api.term.entity.Facet;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.EmptyIterator;
import com.clarkparsia.pellet.datatypes.RestrictedDataRange;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidConstrainingFacetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class RestrictedBooleanDataRange
implements RestrictedDataRange<Boolean> {
    private final Datatype<Boolean> dt;
    private final boolean permitFalse;
    private final boolean permitTrue;

    public RestrictedBooleanDataRange(Datatype<Boolean> dt) {
        this.dt = dt;
        this.permitTrue = true;
        this.permitFalse = true;
    }

    private RestrictedBooleanDataRange(RestrictedBooleanDataRange other, boolean permitTrue, boolean permitFalse) {
        this.dt = other.dt;
        this.permitFalse = permitFalse;
        this.permitTrue = permitTrue;
    }

    @Override
    public RestrictedDataRange<Boolean> applyConstrainingFacet(Facet facet, Object value) throws InvalidConstrainingFacetException {
        throw new InvalidConstrainingFacetException(facet, value);
    }

    @Override
    public boolean contains(Object value) {
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            if (b.booleanValue()) {
                return this.permitTrue;
            }
            return this.permitFalse;
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(int n) {
        if (n <= 0) {
            return true;
        }
        if (n == 1) {
            return this.permitTrue || this.permitFalse;
        }
        if (n == 2) {
            return this.permitTrue && this.permitFalse;
        }
        return false;
    }

    @Override
    public RestrictedDataRange<Boolean> exclude(Collection<?> values) {
        boolean permitTrue = this.permitTrue;
        boolean permitFalse = this.permitFalse;
        for (Object o : values) {
            if (!(o instanceof Boolean)) continue;
            Boolean b = (Boolean)o;
            if (b.booleanValue()) {
                permitTrue = false;
                continue;
            }
            permitFalse = false;
        }
        if (permitTrue == this.permitTrue && permitFalse == this.permitFalse) {
            return this;
        }
        return new RestrictedBooleanDataRange(this, permitTrue, permitFalse);
    }

    @Override
    public Datatype<? extends Boolean> getDatatype() {
        return this.dt;
    }

    @Override
    public Boolean getValue(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RestrictedDataRange<Boolean> intersect(RestrictedDataRange<?> other, boolean negated) {
        if (other instanceof RestrictedBooleanDataRange) {
            boolean permitFalse;
            RestrictedBooleanDataRange otherRBD = (RestrictedBooleanDataRange)other;
            boolean permitTrue = this.permitTrue && otherRBD.permitTrue;
            boolean bl = permitFalse = this.permitFalse && otherRBD.permitFalse;
            if (permitTrue == this.permitTrue && permitFalse == this.permitFalse) {
                return this;
            }
            if (permitTrue == otherRBD.permitTrue && permitFalse == otherRBD.permitFalse) {
                return otherRBD;
            }
            return new RestrictedBooleanDataRange(this, permitTrue, permitFalse);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isEmpty() {
        return !this.permitTrue && !this.permitFalse;
    }

    @Override
    public boolean isEnumerable() {
        return true;
    }

    @Override
    public boolean isFinite() {
        return true;
    }

    @Override
    public int size() {
        return (this.permitTrue ? 1 : 0) + (this.permitFalse ? 1 : 0);
    }

    @Override
    public RestrictedDataRange<Boolean> union(RestrictedDataRange<?> other) {
        if (other instanceof RestrictedBooleanDataRange) {
            boolean permitFalse;
            RestrictedBooleanDataRange otherRBD = (RestrictedBooleanDataRange)other;
            boolean permitTrue = this.permitTrue || otherRBD.permitTrue;
            boolean bl = permitFalse = this.permitFalse || otherRBD.permitFalse;
            if (permitTrue == this.permitTrue && permitFalse == this.permitFalse) {
                return this;
            }
            if (permitTrue == otherRBD.permitTrue && permitFalse == otherRBD.permitFalse) {
                return otherRBD;
            }
            return new RestrictedBooleanDataRange(this, permitTrue, permitFalse);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Iterator<Boolean> valueIterator() {
        if (this.permitTrue) {
            if (this.permitFalse) {
                return Arrays.asList(Boolean.TRUE, Boolean.FALSE).iterator();
            }
            return Arrays.asList(Boolean.TRUE).iterator();
        }
        if (this.permitFalse) {
            return Arrays.asList(Boolean.FALSE).iterator();
        }
        return new EmptyIterator<Boolean>();
    }
}

