/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import com.clarkparsia.pellet.api.term.entity.Literal;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDataRange;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;

class NamedDatatype<T>
implements Datatype<T> {
    private final com.clarkparsia.pellet.api.term.entity.NamedDatatype name;
    private final RestrictedDataRange<T> range;

    NamedDatatype(com.clarkparsia.pellet.api.term.entity.NamedDatatype name, RestrictedDataRange<T> range) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.range = range;
    }

    @Override
    public RestrictedDataRange<T> asDataRange() {
        return this.range;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamedDatatype other = (NamedDatatype)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public Literal getCanonicalRepresentation(Literal input) throws InvalidLiteralException {
        return this.range.getDatatype().getCanonicalRepresentation(input);
    }

    @Override
    public Literal getLiteral(Object value) {
        Literal literal;
        if (value instanceof Literal && this.name.equals((literal = (Literal)value).getDatatype())) {
            return literal;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public com.clarkparsia.pellet.api.term.entity.NamedDatatype getName() {
        return this.name;
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this.range.getDatatype().getPrimitiveDatatype();
    }

    @Override
    public T getValue(Literal literal) throws InvalidLiteralException {
        T value = this.range.getDatatype().getValue(literal);
        if (!this.range.contains(value)) {
            throw new InvalidLiteralException(this.name, literal);
        }
        return value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    public String toString() {
        return this.name.getName();
    }
}

