/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import com.clarkparsia.pellet.api.term.Term;
import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.entity.DataAnd;
import com.clarkparsia.pellet.api.term.entity.DataNot;
import com.clarkparsia.pellet.api.term.entity.DataOneOf;
import com.clarkparsia.pellet.api.term.entity.DataOr;
import com.clarkparsia.pellet.api.term.entity.Datatype;
import com.clarkparsia.pellet.api.term.entity.NamedDatatype;
import com.clarkparsia.pellet.api.term.entity.RestrictedDatatype;
import com.clarkparsia.pellet.api.term.visitor.BaseTermVisitor;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;

public class NamedDataRangeExpander
extends BaseTermVisitor<Datatype> {
    private Map<NamedDatatype, Datatype> map;
    private boolean change;

    public Datatype expand(Datatype input, Map<NamedDatatype, Datatype> map) {
        if (map.isEmpty()) {
            return input;
        }
        this.map = map;
        return input.accept(this);
    }

    @Override
    protected Datatype defaultVisit(Term term) {
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype visit(DataAnd term) {
        boolean listChange = false;
        ArrayList args = Lists.newArrayListWithCapacity((int)term.size());
        for (Datatype datatype : term) {
            args.add(datatype.accept(this));
            if (!this.change) continue;
            listChange = true;
        }
        if (listChange) {
            this.change = true;
            return TermFactory.dataAnd(args);
        }
        this.change = false;
        return term;
    }

    @Override
    public Datatype visit(DataNot term) {
        Datatype ret = term.getArg().accept(this);
        if (this.change) {
            return TermFactory.dataNot(ret);
        }
        return term;
    }

    @Override
    public Datatype visit(DataOneOf term) {
        this.change = false;
        return term;
    }

    @Override
    public Datatype visit(DataOr term) {
        boolean listChange = false;
        ArrayList args = Lists.newArrayListWithCapacity((int)term.size());
        for (Datatype datatype : term) {
            args.add(datatype.accept(this));
            if (!this.change) continue;
            listChange = true;
        }
        if (listChange) {
            this.change = true;
            return TermFactory.dataOr(args);
        }
        this.change = false;
        return term;
    }

    @Override
    public Datatype visit(RestrictedDatatype dt) {
        this.change = false;
        return dt;
    }

    @Override
    public Datatype visit(NamedDatatype term) {
        Datatype a = this.map.get(term);
        if (a == null) {
            this.change = false;
            return term;
        }
        this.change = true;
        return a;
    }
}

