/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import com.clarkparsia.pellet.api.term.entity.Facet;
import com.clarkparsia.pellet.api.term.entity.Literal;
import com.clarkparsia.pellet.api.term.entity.NamedDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDataRange;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidConstrainingFacetException;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class InfiniteNamedDatatype
implements Datatype<Literal> {
    private static final Map<NamedDatatype, WeakReference<InfiniteNamedDatatype>> cache = new WeakHashMap<NamedDatatype, WeakReference<InfiniteNamedDatatype>>();
    private final NamedDatatype name;
    private final RestrictedDataRange<Literal> range;

    public static InfiniteNamedDatatype get(NamedDatatype dtName) {
        InfiniteNamedDatatype dt;
        WeakReference<InfiniteNamedDatatype> dtRef = cache.get(dtName);
        InfiniteNamedDatatype infiniteNamedDatatype = dt = dtRef == null ? null : (InfiniteNamedDatatype)dtRef.get();
        if (dt == null) {
            dt = new InfiniteNamedDatatype(dtName);
            cache.put(dtName, new WeakReference<InfiniteNamedDatatype>(dt));
        }
        return dt;
    }

    private InfiniteNamedDatatype(NamedDatatype name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.range = new RestrictedDataRange<Literal>(){

            @Override
            public RestrictedDataRange<Literal> applyConstrainingFacet(Facet facet, Object value) throws InvalidConstrainingFacetException {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean contains(Object value) {
                if (value instanceof Literal) {
                    Literal literal = (Literal)value;
                    return InfiniteNamedDatatype.this.name.equals(literal.getDatatype());
                }
                return false;
            }

            @Override
            public boolean containsAtLeast(int n) {
                return true;
            }

            @Override
            public RestrictedDataRange<Literal> exclude(Collection<?> values) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Datatype<? extends Literal> getDatatype() {
                return InfiniteNamedDatatype.this;
            }

            @Override
            public Literal getValue(int i) {
                throw new UnsupportedOperationException();
            }

            @Override
            public RestrictedDataRange<Literal> intersect(RestrictedDataRange<?> other, boolean negated) {
                if (other == this) {
                    return this;
                }
                throw new IllegalArgumentException();
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean isEnumerable() {
                return false;
            }

            @Override
            public boolean isFinite() {
                return false;
            }

            @Override
            public int size() {
                throw new UnsupportedOperationException();
            }

            @Override
            public RestrictedDataRange<Literal> union(RestrictedDataRange<?> other) {
                if (other == this) {
                    return this;
                }
                throw new IllegalArgumentException();
            }

            @Override
            public Iterator<Literal> valueIterator() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public RestrictedDataRange<Literal> asDataRange() {
        return this.range;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InfiniteNamedDatatype other = (InfiniteNamedDatatype)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public Literal getCanonicalRepresentation(Literal input) throws InvalidLiteralException {
        if (!(this.name instanceof Literal) && !this.name.equals(input.getDatatype())) {
            throw new IllegalArgumentException();
        }
        return input;
    }

    @Override
    public Literal getLiteral(Object value) {
        Literal literal;
        if (value instanceof Literal && this.name.equals((literal = (Literal)value).getDatatype())) {
            return literal;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public NamedDatatype getName() {
        return this.name;
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Literal getValue(Literal literal) throws InvalidLiteralException {
        return this.getCanonicalRepresentation(literal);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    public String toString() {
        return this.name.getName();
    }
}

