/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.term.impl.entity;

import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.axiom.AnnotationValue;
import com.clarkparsia.pellet.api.term.axiom.Asymmetric;
import com.clarkparsia.pellet.api.term.axiom.Declaration;
import com.clarkparsia.pellet.api.term.axiom.DisjointObjectProperties;
import com.clarkparsia.pellet.api.term.axiom.EntityAnnotation;
import com.clarkparsia.pellet.api.term.axiom.EquivalentObjectProperties;
import com.clarkparsia.pellet.api.term.axiom.InverseProperties;
import com.clarkparsia.pellet.api.term.axiom.Irreflexive;
import com.clarkparsia.pellet.api.term.axiom.ObjectFunctional;
import com.clarkparsia.pellet.api.term.axiom.ObjectInverseFunctional;
import com.clarkparsia.pellet.api.term.axiom.ObjectPropertyDomain;
import com.clarkparsia.pellet.api.term.axiom.ObjectPropertyRange;
import com.clarkparsia.pellet.api.term.axiom.Reflexive;
import com.clarkparsia.pellet.api.term.axiom.SubObjectPropertyChain;
import com.clarkparsia.pellet.api.term.axiom.SubObjectPropertyOf;
import com.clarkparsia.pellet.api.term.axiom.Symmetric;
import com.clarkparsia.pellet.api.term.axiom.Transitive;
import com.clarkparsia.pellet.api.term.builtins.AnnotationProperties;
import com.clarkparsia.pellet.api.term.entity.AnnotationProperty;
import com.clarkparsia.pellet.api.term.entity.ClassExpression;
import com.clarkparsia.pellet.api.term.entity.Individual;
import com.clarkparsia.pellet.api.term.entity.InverseObjectProperty;
import com.clarkparsia.pellet.api.term.entity.NamedAnnotationProperty;
import com.clarkparsia.pellet.api.term.entity.NamedClass;
import com.clarkparsia.pellet.api.term.entity.NamedDataProperty;
import com.clarkparsia.pellet.api.term.entity.NamedDatatype;
import com.clarkparsia.pellet.api.term.entity.NamedEntity;
import com.clarkparsia.pellet.api.term.entity.NamedIndividual;
import com.clarkparsia.pellet.api.term.entity.NamedObjectProperty;
import com.clarkparsia.pellet.api.term.entity.ObjectAll;
import com.clarkparsia.pellet.api.term.entity.ObjectCardinality;
import com.clarkparsia.pellet.api.term.entity.ObjectHasValue;
import com.clarkparsia.pellet.api.term.entity.ObjectMax;
import com.clarkparsia.pellet.api.term.entity.ObjectMin;
import com.clarkparsia.pellet.api.term.entity.ObjectProperty;
import com.clarkparsia.pellet.api.term.entity.ObjectPropertyList;
import com.clarkparsia.pellet.api.term.entity.ObjectSelf;
import com.clarkparsia.pellet.api.term.entity.ObjectSome;
import com.clarkparsia.pellet.api.term.impl.NamedTermImpl;
import com.clarkparsia.pellet.api.term.query.DirectSubObjectPropertyOf;
import com.clarkparsia.pellet.api.term.query.StrictSubObjectPropertyOf;
import com.clarkparsia.pellet.api.term.visitor.TermVisitor;
import com.clarkparsia.pellet.api.term.visitor.TermVisitorVoid;

public class NamedObjectPropertyImpl
extends NamedTermImpl
implements NamedObjectProperty {
    private final InverseObjectProperty inverse = TermFactory.inverse(this);

    public NamedObjectPropertyImpl(String name) {
        super(name);
    }

    @Override
    public void accept(TermVisitorVoid visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(TermVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean isInverse() {
        return false;
    }

    @Override
    public boolean isVariable() {
        return false;
    }

    @Override
    public NamedObjectProperty getNamedProperty() {
        return this;
    }

    @Override
    public <T extends NamedEntity> T as(Class<T> entityType) {
        if (entityType.isInstance(this)) {
            return (T)this;
        }
        if (entityType.equals(NamedClass.class)) {
            return (T)TermFactory.namedClass(this.getName());
        }
        if (entityType.equals(NamedObjectProperty.class)) {
            return (T)TermFactory.namedObjectProperty(this.getName());
        }
        if (entityType.equals(NamedDataProperty.class)) {
            return (T)TermFactory.namedDataProperty(this.getName());
        }
        if (entityType.equals(NamedIndividual.class)) {
            return (T)TermFactory.namedIndividual(this.getName());
        }
        if (entityType.equals(NamedAnnotationProperty.class)) {
            return (T)TermFactory.namedAnnotationProperty(this.getName());
        }
        if (entityType.equals(NamedDatatype.class)) {
            return (T)TermFactory.namedDatatype(this.getName());
        }
        throw new IllegalArgumentException("Unrecognized entity type: " + String.valueOf(entityType));
    }

    @Override
    public ObjectProperty inverse() {
        return this.inverse;
    }

    @Override
    public EntityAnnotation comment(AnnotationValue value) {
        return TermFactory.annotation(this, (AnnotationProperty)AnnotationProperties.COMMENT, value);
    }

    @Override
    public EntityAnnotation comment(String value) {
        return TermFactory.annotation(this, (AnnotationProperty)AnnotationProperties.COMMENT, (AnnotationValue)TermFactory.literal(value));
    }

    @Override
    public EntityAnnotation label(String value) {
        return TermFactory.annotation(this, (AnnotationProperty)AnnotationProperties.LABEL, (AnnotationValue)TermFactory.literal(value));
    }

    @Override
    public EntityAnnotation label(AnnotationValue value) {
        return TermFactory.annotation(this, (AnnotationProperty)AnnotationProperties.LABEL, value);
    }

    @Override
    public EntityAnnotation annotation(AnnotationProperty p, AnnotationValue value) {
        return TermFactory.annotation(this, p, value);
    }

    @Override
    public EntityAnnotation annotation(AnnotationProperty p, String value) {
        return TermFactory.annotation(this, p, (AnnotationValue)TermFactory.literal(value));
    }

    @Override
    public Asymmetric asymmetric() {
        return TermFactory.asymmetric(this);
    }

    @Override
    public ObjectFunctional functional() {
        return TermFactory.functional(this);
    }

    @Override
    public ObjectInverseFunctional inverseFunctional() {
        return TermFactory.inverseFunctional(this);
    }

    @Override
    public Irreflexive irreflexive() {
        return TermFactory.irreflexive(this);
    }

    @Override
    public Reflexive reflexive() {
        return TermFactory.reflexive(this);
    }

    @Override
    public Symmetric symmetric() {
        return TermFactory.symmetric(this);
    }

    @Override
    public Transitive transitive() {
        return TermFactory.transitive(this);
    }

    @Override
    public EquivalentObjectProperties equivalentTo(ObjectProperty p) {
        return TermFactory.equivalentProperties((ObjectProperty)this, p);
    }

    @Override
    public ObjectAll only(ClassExpression c) {
        return TermFactory.all(this, c);
    }

    @Override
    public ObjectSome some(ClassExpression c) {
        return TermFactory.some(this, c);
    }

    @Override
    public ObjectMin min(int cardinality) {
        return TermFactory.min(this, cardinality);
    }

    @Override
    public ObjectMin min(int cardinality, ClassExpression c) {
        return TermFactory.min(this, cardinality, c);
    }

    @Override
    public ObjectMax max(int cardinality) {
        return TermFactory.max(this, cardinality);
    }

    @Override
    public ObjectMax max(int cardinality, ClassExpression c) {
        return TermFactory.max(this, cardinality, c);
    }

    @Override
    public ObjectCardinality exactly(int cardinality) {
        return TermFactory.cardinality(this, cardinality);
    }

    @Override
    public ObjectCardinality exactly(int cardinality, ClassExpression c) {
        return TermFactory.cardinality(this, cardinality, c);
    }

    @Override
    public ObjectHasValue value(Individual i) {
        return TermFactory.hasValue(this, i);
    }

    @Override
    public ObjectSelf self() {
        return TermFactory.self(this);
    }

    @Override
    public Declaration declaration() {
        return TermFactory.declaration(this);
    }

    @Override
    public InverseProperties inverseOf(ObjectProperty p) {
        return TermFactory.inverseOf(this, p);
    }

    @Override
    public SubObjectPropertyOf subPropertyOf(ObjectProperty sup) {
        return TermFactory.subPropertyOf(this, sup);
    }

    @Override
    public DirectSubObjectPropertyOf directSubPropertyOf(ObjectProperty sup) {
        return TermFactory.directSubPropertyOf(this, sup);
    }

    @Override
    public StrictSubObjectPropertyOf strictSubPropertyOf(ObjectProperty sup) {
        return TermFactory.strictSubPropertyOf(this, sup);
    }

    @Override
    public SubObjectPropertyChain subPropertyChain(NamedObjectProperty ... properties) {
        return TermFactory.subPropertyOf(TermFactory.propertyList(properties), (ObjectProperty)this);
    }

    @Override
    public SubObjectPropertyChain subPropertyChain(ObjectPropertyList properties) {
        return TermFactory.subPropertyOf(properties, (ObjectProperty)this);
    }

    @Override
    public ObjectPropertyDomain domain(ClassExpression domain) {
        return TermFactory.domain(this, domain);
    }

    @Override
    public ObjectPropertyRange range(ClassExpression range) {
        return TermFactory.range(this, range);
    }

    @Override
    public DisjointObjectProperties disjointWith(ObjectProperty p) {
        return TermFactory.disjointProperties(this, p);
    }
}

