/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.term.impl.entity;

import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.api.term.entity.Literal;
import com.clarkparsia.pellet.api.term.entity.NamedDatatype;
import com.clarkparsia.pellet.api.term.impl.entity.LiteralValueImpl;
import com.clarkparsia.pellet.api.term.visitor.TermVisitor;
import com.clarkparsia.pellet.api.term.visitor.TermVisitorVoid;
import com.complexible.common.hash.HashCodeUtil;
import com.google.common.base.Objects;

public class LiteralImpl
extends LiteralValueImpl
implements Literal {
    private final NamedDatatype datatype;
    private final String lexicalValue;
    private final String language;

    public LiteralImpl(String lexicalValue, String language) {
        this.lexicalValue = lexicalValue;
        this.datatype = Datatypes.LANG_STRING;
        this.language = language;
    }

    public LiteralImpl(String lexicalValue, NamedDatatype datatype) {
        this.lexicalValue = lexicalValue;
        this.datatype = datatype;
        this.language = null;
    }

    @Override
    public void accept(TermVisitorVoid visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(TermVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected void computeHashCode() {
        this.hashCode = 23;
        this.hashCode = HashCodeUtil.hash((int)this.hashCode, (Object)this.datatype);
        this.hashCode = HashCodeUtil.hash((int)this.hashCode, (Object)this.language);
        this.hashCode = HashCodeUtil.hash((int)this.hashCode, (Object)this.lexicalValue);
    }

    @Override
    public NamedDatatype getDatatype() {
        return this.datatype;
    }

    @Override
    public String getLexicalValue() {
        return this.lexicalValue;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public boolean hasLanguage() {
        return this.language != null;
    }

    @Override
    public boolean isVariable() {
        return false;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Literal)) {
            return false;
        }
        Literal that = (Literal)other;
        return this.getLexicalValue().equals(that.getLexicalValue()) && this.getDatatype().equals(that.getDatatype()) && Objects.equal((Object)this.getLanguage(), (Object)that.getLanguage());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('\"');
        builder.append(this.lexicalValue);
        builder.append('\"');
        if (this.language != null) {
            builder.append('@');
            builder.append(this.language);
        } else if (!this.datatype.equals(Datatypes.STRING)) {
            builder.append("^^");
            builder.append(this.datatype);
        }
        return builder.toString();
    }
}

