/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.term.impl.axiom;

import com.clarkparsia.pellet.api.term.axiom.HasKey;
import com.clarkparsia.pellet.api.term.entity.ClassExpression;
import com.clarkparsia.pellet.api.term.entity.DataProperty;
import com.clarkparsia.pellet.api.term.entity.ObjectProperty;
import com.clarkparsia.pellet.api.term.entity.Property;
import com.clarkparsia.pellet.api.term.impl.TermImpl;
import com.clarkparsia.pellet.api.term.visitor.TermVisitor;
import com.clarkparsia.pellet.api.term.visitor.TermVisitorVoid;
import com.google.common.collect.Sets;
import java.util.Set;

public class HasKeyImpl
extends TermImpl
implements HasKey {
    private final ClassExpression keyClass;
    private final Set<ObjectProperty> objProperties;
    private final Set<DataProperty> dataProperties;

    public HasKeyImpl(ClassExpression keyClass, Set<ObjectProperty> objProperties, Set<DataProperty> dataProperties) {
        this.keyClass = keyClass;
        this.objProperties = objProperties;
        this.dataProperties = dataProperties;
    }

    @Override
    public Set<DataProperty> getDataProperties() {
        return this.dataProperties;
    }

    @Override
    public ClassExpression getKeyClass() {
        return this.keyClass;
    }

    @Override
    public Set<ObjectProperty> getObjectProperties() {
        return this.objProperties;
    }

    @Override
    public Set<Property> getProperties() {
        return Sets.union(this.objProperties, this.dataProperties);
    }

    @Override
    public <T> T accept(TermVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(TermVisitorVoid visitor) {
        visitor.visit(this);
    }

    @Override
    protected void computeHashCode() {
        this.hashCode = this.keyClass.hashCode() ^ this.objProperties.hashCode() >> 1 ^ this.dataProperties.hashCode() << 1;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HasKey)) {
            return false;
        }
        HasKey that = (HasKey)other;
        return this.keyClass.equals(that.getKeyClass()) && this.objProperties.equals(that.getObjectProperties()) && this.dataProperties.equals(that.getDataProperties());
    }

    @Override
    public String toString() {
        return "HasKey(" + String.valueOf(this.keyClass) + " " + String.valueOf(this.objProperties) + " " + String.valueOf(this.dataProperties) + ")";
    }
}

