/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.term.builtins;

import com.clarkparsia.pellet.api.term.NamedTerm;
import com.clarkparsia.pellet.api.term.axiom.Declaration;
import com.clarkparsia.pellet.api.term.entity.Entity;
import com.clarkparsia.pellet.api.term.entity.NamedEntity;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Comparator;

public class Terms {
    private static final Predicate<Entity> IS_VARIABLE = new Predicate<Entity>(){

        public boolean apply(Entity input) {
            return input.isVariable();
        }
    };
    private static final Predicate<Entity> IS_NOT_VARIABLE = new Predicate<Entity>(){

        public boolean apply(Entity input) {
            return !input.isVariable();
        }
    };
    private static final Predicate<Entity> IS_NAMED = new Predicate<Entity>(){

        public boolean apply(Entity input) {
            return input.isNamed();
        }
    };
    private static final Comparator<NamedTerm> NAMED_TERM_COMPARATOR = new Comparator<NamedTerm>(){

        @Override
        public int compare(NamedTerm o1, NamedTerm o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final Function<NamedEntity, Declaration> DECLARATION_ENTITY_MAPPER = new Function<NamedEntity, Declaration>(){

        public Declaration apply(NamedEntity e) {
            return e.declaration();
        }
    };
    private static final Function<Declaration, NamedEntity> ENTITY_DECLARATION_MAPPER = new Function<Declaration, NamedEntity>(){

        public NamedEntity apply(Declaration declaration) {
            return declaration.getEntity();
        }
    };

    public static final Predicate<Entity> isVariable() {
        return IS_VARIABLE;
    }

    public static final Predicate<Entity> isNotVariable() {
        return IS_NOT_VARIABLE;
    }

    public static final Predicate<Entity> isNamed() {
        return IS_NAMED;
    }

    public static final Comparator<NamedTerm> namedTermComparator() {
        return NAMED_TERM_COMPARATOR;
    }

    public static final Function<NamedEntity, Declaration> entityDeclarationMapper() {
        return DECLARATION_ENTITY_MAPPER;
    }

    public static final Function<Declaration, NamedEntity> declarationEntityMapper() {
        return ENTITY_DECLARATION_MAPPER;
    }
}

