/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.term.builtins;

import com.clarkparsia.pellet.api.term.Term;
import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.builtins.Classes;
import com.clarkparsia.pellet.api.term.builtins.Types;
import com.clarkparsia.pellet.api.term.entity.ClassExpression;
import com.clarkparsia.pellet.api.term.entity.DataAll;
import com.clarkparsia.pellet.api.term.entity.DataCardinality;
import com.clarkparsia.pellet.api.term.entity.DataHasValue;
import com.clarkparsia.pellet.api.term.entity.DataMax;
import com.clarkparsia.pellet.api.term.entity.DataMin;
import com.clarkparsia.pellet.api.term.entity.DataOneOf;
import com.clarkparsia.pellet.api.term.entity.DataProperty;
import com.clarkparsia.pellet.api.term.entity.DataSome;
import com.clarkparsia.pellet.api.term.entity.Datatype;
import com.clarkparsia.pellet.api.term.entity.Individual;
import com.clarkparsia.pellet.api.term.entity.NamedClass;
import com.clarkparsia.pellet.api.term.entity.ObjectAll;
import com.clarkparsia.pellet.api.term.entity.ObjectAnd;
import com.clarkparsia.pellet.api.term.entity.ObjectCardinality;
import com.clarkparsia.pellet.api.term.entity.ObjectHasValue;
import com.clarkparsia.pellet.api.term.entity.ObjectMax;
import com.clarkparsia.pellet.api.term.entity.ObjectMin;
import com.clarkparsia.pellet.api.term.entity.ObjectNot;
import com.clarkparsia.pellet.api.term.entity.ObjectOneOf;
import com.clarkparsia.pellet.api.term.entity.ObjectOr;
import com.clarkparsia.pellet.api.term.entity.ObjectProperty;
import com.clarkparsia.pellet.api.term.entity.ObjectSelf;
import com.clarkparsia.pellet.api.term.entity.ObjectSome;
import com.clarkparsia.pellet.api.term.visitor.BaseTermVisitor;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

class Normalize {
    private static final NormalizeVisitor VISITOR = new NormalizeVisitor();

    Normalize() {
    }

    public static ClassExpression normalize(ClassExpression c) {
        return c.accept(VISITOR);
    }

    private static class NormalizeVisitor
    extends BaseTermVisitor<ClassExpression> {
        private NormalizeVisitor() {
        }

        @Override
        protected ClassExpression defaultVisit(Term term) {
            assert (term instanceof ClassExpression);
            return (ClassExpression)term;
        }

        private Set<ClassExpression> negateList(Iterable<ClassExpression> classes) {
            HashSet result = Sets.newHashSet();
            for (ClassExpression c : classes) {
                result.add(Types.negate(c));
            }
            return result;
        }

        private Set<ClassExpression> normalizeList(Set<ClassExpression> classes, boolean negate) {
            HashSet result = Sets.newHashSet();
            for (ClassExpression c : classes) {
                result.add(Normalize.normalize(negate ? Types.negate(c) : c));
            }
            return result;
        }

        @Override
        public ClassExpression visit(ObjectAnd and) {
            return Types.simplify(TermFactory.and(this.normalizeList((Set<ClassExpression>)and.getArgs(), false)));
        }

        @Override
        public ClassExpression visit(ObjectNot not) {
            ClassExpression arg = not.getArg();
            if (arg.isNamed()) {
                if (arg.equals(Classes.THING)) {
                    return Classes.NOTHING;
                }
                if (arg.equals(Classes.NOTHING)) {
                    return Classes.THING;
                }
                return not;
            }
            return Types.simplify(Types.negate(Normalize.normalize(arg)));
        }

        @Override
        public ClassExpression visit(ObjectOr or) {
            return Normalize.normalize(TermFactory.not(TermFactory.and(this.negateList(or))));
        }

        @Override
        public ClassExpression visit(DataAll all) {
            DataProperty p = all.getProperty();
            Datatype q = all.getQualification();
            return Types.simplify(p.only(q));
        }

        @Override
        public ClassExpression visit(DataCardinality card) {
            DataProperty p = card.getProperty();
            int n = card.getCardinality();
            Datatype q = card.getQualification();
            return Normalize.normalize(TermFactory.and((ClassExpression)p.min(n, q), (ClassExpression)p.max(n, q)));
        }

        @Override
        public ClassExpression visit(DataHasValue value) {
            DataProperty p = value.getProperty();
            DataOneOf t = TermFactory.dataOneOf(value.getValue());
            return Normalize.normalize(TermFactory.not(p.only(TermFactory.dataNot(t))));
        }

        @Override
        public ClassExpression visit(DataMax max) {
            DataProperty p = max.getProperty();
            int n = max.getCardinality();
            Datatype q = max.getQualification();
            return Normalize.normalize(TermFactory.not(p.min(n + 1, q)));
        }

        @Override
        public ClassExpression visit(DataMin min) {
            DataProperty p = min.getProperty();
            int n = min.getCardinality();
            Datatype q = min.getQualification();
            return Types.simplify(p.min(n, q));
        }

        @Override
        public ClassExpression visit(DataSome some) {
            DataProperty p = some.getProperty();
            Datatype q = some.getQualification();
            Datatype negQ = Types.negate(q);
            return Normalize.normalize(TermFactory.not(p.only(negQ)));
        }

        @Override
        public ClassExpression visit(NamedClass c) {
            return c;
        }

        @Override
        public ClassExpression visit(ObjectAll all) {
            ObjectProperty p = all.getProperty();
            ClassExpression q = all.getQualification();
            ClassExpression normQ = Normalize.normalize(q);
            return Types.simplify(p.only(normQ));
        }

        @Override
        public ClassExpression visit(ObjectCardinality card) {
            ObjectProperty p = card.getProperty();
            int n = card.getCardinality();
            ClassExpression q = card.getQualification();
            return Normalize.normalize(TermFactory.and((ClassExpression)p.min(n, q), (ClassExpression)p.max(n, q)));
        }

        @Override
        public ClassExpression visit(ObjectHasValue value) {
            ObjectProperty p = value.getProperty();
            ObjectOneOf q = TermFactory.oneOf(value.getValue());
            return Normalize.normalize(TermFactory.not(p.only(TermFactory.not(q))));
        }

        @Override
        public ClassExpression visit(ObjectMax max) {
            ObjectProperty p = max.getProperty();
            int n = max.getCardinality();
            ClassExpression q = max.getQualification();
            return Normalize.normalize(TermFactory.not(p.min(n + 1, q)));
        }

        @Override
        public ClassExpression visit(ObjectMin min) {
            ClassExpression normQ;
            ObjectProperty p = min.getProperty();
            int n = min.getCardinality();
            ClassExpression q = min.getQualification();
            return Types.simplify(q == (normQ = Normalize.normalize(q)) ? min : p.min(n, normQ));
        }

        @Override
        public ClassExpression visit(ObjectOneOf oneOf) {
            int n = oneOf.size();
            if (n == 1) {
                return oneOf;
            }
            ArrayList singletons = Lists.newArrayListWithExpectedSize((int)n);
            for (Individual individual : oneOf) {
                singletons.add(TermFactory.not(TermFactory.oneOf(individual)));
            }
            return TermFactory.not(TermFactory.and(singletons));
        }

        @Override
        public ClassExpression visit(ObjectSome some) {
            ObjectProperty p = some.getProperty();
            ClassExpression q = some.getQualification();
            ClassExpression negQ = Types.negate(q);
            return Normalize.normalize(TermFactory.not(p.only(negQ)));
        }

        @Override
        public ClassExpression visit(ObjectSelf self) {
            return self;
        }
    }
}

