/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.term.builtins;

import com.clarkparsia.pellet.api.term.Term;
import com.clarkparsia.pellet.api.term.TermCollection;
import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.builtins.Classes;
import com.clarkparsia.pellet.api.term.entity.ClassExpression;
import com.clarkparsia.pellet.api.term.entity.DataAll;
import com.clarkparsia.pellet.api.term.entity.DataAnd;
import com.clarkparsia.pellet.api.term.entity.DataCardinality;
import com.clarkparsia.pellet.api.term.entity.DataMax;
import com.clarkparsia.pellet.api.term.entity.DataMin;
import com.clarkparsia.pellet.api.term.entity.DataNot;
import com.clarkparsia.pellet.api.term.entity.DataOr;
import com.clarkparsia.pellet.api.term.entity.DataProperty;
import com.clarkparsia.pellet.api.term.entity.DataSome;
import com.clarkparsia.pellet.api.term.entity.Datatype;
import com.clarkparsia.pellet.api.term.entity.ObjectAll;
import com.clarkparsia.pellet.api.term.entity.ObjectAnd;
import com.clarkparsia.pellet.api.term.entity.ObjectCardinality;
import com.clarkparsia.pellet.api.term.entity.ObjectMax;
import com.clarkparsia.pellet.api.term.entity.ObjectMin;
import com.clarkparsia.pellet.api.term.entity.ObjectNot;
import com.clarkparsia.pellet.api.term.entity.ObjectOr;
import com.clarkparsia.pellet.api.term.entity.ObjectProperty;
import com.clarkparsia.pellet.api.term.entity.ObjectSome;
import com.clarkparsia.pellet.api.term.visitor.BaseTermVisitor;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;

class NNF {
    private static final NegatedVisitor negVisitor = new NegatedVisitor();
    private static final PositiveVisitor posVisitor = new PositiveVisitor();
    private static final NegatedDataVisitor negDataVisitor = new NegatedDataVisitor();
    private static final PositiveDataVisitor posDataVisitor = new PositiveDataVisitor();

    NNF() {
    }

    public static ClassExpression nnf(ClassExpression c) {
        return c.accept(posVisitor);
    }

    public static Datatype nnf(Datatype d) {
        return d.accept(posDataVisitor);
    }

    private static class PositiveVisitor
    extends BaseTermVisitor<ClassExpression> {
        private PositiveVisitor() {
        }

        @Override
        protected ClassExpression defaultVisit(Term term) {
            assert (term instanceof ClassExpression);
            return (ClassExpression)term;
        }

        protected Set<ClassExpression> nnfAll(TermCollection<ClassExpression> classes) {
            HashSet results = Sets.newHashSetWithExpectedSize((int)classes.size());
            boolean alreadyInNNF = false;
            for (ClassExpression c : classes) {
                ClassExpression nnfC;
                alreadyInNNF &= c == (nnfC = c.accept(this));
                results.add(nnfC);
            }
            return alreadyInNNF ? null : results;
        }

        @Override
        public ClassExpression visit(DataAll all) {
            Datatype nnfQ;
            DataProperty p = all.getProperty();
            Datatype q = all.getQualification();
            return q == (nnfQ = q.accept(posDataVisitor)) ? all : TermFactory.all(p, nnfQ);
        }

        @Override
        public ClassExpression visit(ObjectAll all) {
            ClassExpression nnfQ;
            ObjectProperty p = all.getProperty();
            ClassExpression q = all.getQualification();
            return q == (nnfQ = q.accept(this)) ? all : TermFactory.all(p, nnfQ);
        }

        @Override
        public ClassExpression visit(ObjectAnd and) {
            Set<ClassExpression> nnfArgs = this.nnfAll(and);
            boolean alreadyInNNF = nnfArgs == null;
            return alreadyInNNF ? and : TermFactory.and(nnfArgs);
        }

        @Override
        public ClassExpression visit(DataCardinality card) {
            Datatype nnfQ;
            DataProperty p = card.getProperty();
            int n = card.getCardinality();
            Datatype q = card.getQualification();
            return q == (nnfQ = q.accept(posDataVisitor)) ? card : TermFactory.cardinality(p, n, nnfQ);
        }

        @Override
        public ClassExpression visit(ObjectCardinality card) {
            ClassExpression nnfQ;
            ObjectProperty p = card.getProperty();
            int n = card.getCardinality();
            ClassExpression q = card.getQualification();
            return q == (nnfQ = q.accept(this)) ? card : TermFactory.cardinality(p, n, nnfQ);
        }

        @Override
        public ClassExpression visit(DataMax max) {
            Datatype nnfQ;
            DataProperty p = max.getProperty();
            int n = max.getCardinality();
            Datatype q = max.getQualification();
            return q == (nnfQ = q.accept(posDataVisitor)) ? max : TermFactory.max(p, n, nnfQ);
        }

        @Override
        public ClassExpression visit(ObjectMax max) {
            ClassExpression nnfQ;
            ObjectProperty p = max.getProperty();
            int n = max.getCardinality();
            ClassExpression q = max.getQualification();
            return q == (nnfQ = q.accept(this)) ? max : TermFactory.max(p, n, nnfQ);
        }

        @Override
        public ClassExpression visit(DataMin min) {
            Datatype nnfQ;
            DataProperty p = min.getProperty();
            int n = min.getCardinality();
            Datatype q = min.getQualification();
            return q == (nnfQ = q.accept(posDataVisitor)) ? min : TermFactory.min(p, n, nnfQ);
        }

        @Override
        public ClassExpression visit(ObjectMin min) {
            ClassExpression nnfQ;
            ObjectProperty p = min.getProperty();
            int n = min.getCardinality();
            ClassExpression q = min.getQualification();
            return q == (nnfQ = q.accept(this)) ? min : TermFactory.min(p, n, nnfQ);
        }

        @Override
        public ClassExpression visit(ObjectNot not) {
            return not.getArg().accept(negVisitor);
        }

        @Override
        public ClassExpression visit(ObjectOr or) {
            Set<ClassExpression> nnfArgs = this.nnfAll(or);
            return nnfArgs == null ? or : TermFactory.or(nnfArgs);
        }

        @Override
        public ClassExpression visit(DataSome some) {
            Datatype nnfQ;
            DataProperty p = some.getProperty();
            Datatype q = some.getQualification();
            return q == (nnfQ = q.accept(posDataVisitor)) ? some : TermFactory.some(p, nnfQ);
        }

        @Override
        public ClassExpression visit(ObjectSome some) {
            ClassExpression nnfQ;
            ObjectProperty p = some.getProperty();
            ClassExpression q = some.getQualification();
            return q == (nnfQ = q.accept(this)) ? some : TermFactory.some(p, nnfQ);
        }
    }

    private static class PositiveDataVisitor
    extends BaseTermVisitor<Datatype> {
        private PositiveDataVisitor() {
        }

        @Override
        protected Datatype defaultVisit(Term term) {
            assert (term instanceof Datatype);
            return (Datatype)term;
        }

        protected Set<Datatype> nnfAll(TermCollection<Datatype> classes) {
            HashSet results = Sets.newHashSetWithExpectedSize((int)classes.size());
            boolean alreadyInNNF = false;
            for (Datatype c : classes) {
                Datatype nnfC;
                alreadyInNNF &= c == (nnfC = c.accept(this));
                results.add(nnfC);
            }
            return alreadyInNNF ? null : results;
        }

        @Override
        public Datatype visit(DataAnd and) {
            Set<Datatype> nnfArgs = this.nnfAll(and);
            return nnfArgs == null ? and : TermFactory.dataAnd(nnfArgs);
        }

        @Override
        public Datatype visit(DataNot not) {
            return not.getArg().accept(negDataVisitor);
        }

        @Override
        public Datatype visit(DataOr or) {
            Set<Datatype> nnfArgs = this.nnfAll(or);
            return nnfArgs == null ? or : TermFactory.dataOr(nnfArgs);
        }
    }

    private static class NegatedVisitor
    extends BaseTermVisitor<ClassExpression> {
        private NegatedVisitor() {
        }

        protected Set<ClassExpression> nnfAll(TermCollection<ClassExpression> classes) {
            HashSet results = Sets.newHashSetWithExpectedSize((int)classes.size());
            for (ClassExpression c : classes) {
                ClassExpression nnfC = c.accept(this);
                results.add(nnfC);
            }
            return results;
        }

        @Override
        public ClassExpression defaultVisit(Term c) {
            assert (c instanceof ClassExpression);
            return TermFactory.not((ClassExpression)c);
        }

        @Override
        public ClassExpression visit(DataAll all) {
            DataProperty p = all.getProperty();
            Datatype q = all.getQualification();
            return TermFactory.some(p, q.accept(negDataVisitor));
        }

        @Override
        public ClassExpression visit(ObjectAll all) {
            ObjectProperty p = all.getProperty();
            ClassExpression q = all.getQualification();
            return TermFactory.some(p, q.accept(negVisitor));
        }

        @Override
        public ClassExpression visit(ObjectAnd and) {
            Set<ClassExpression> args = this.nnfAll(and);
            return args == null ? and : TermFactory.or(args);
        }

        @Override
        public ClassExpression visit(DataCardinality card) {
            DataProperty p = card.getProperty();
            int n = card.getCardinality();
            Datatype q = card.getQualification();
            if (n == 0) {
                return TermFactory.min(p, 1, q.accept(posDataVisitor));
            }
            Datatype nnfQ = q.accept(posDataVisitor);
            return TermFactory.or((ClassExpression)TermFactory.max(p, n - 1, nnfQ), (ClassExpression)TermFactory.min(p, n + 1, nnfQ));
        }

        @Override
        public ClassExpression visit(ObjectCardinality card) {
            ObjectProperty p = card.getProperty();
            int n = card.getCardinality();
            ClassExpression q = card.getQualification();
            if (n == 0) {
                return TermFactory.min(p, 1, q.accept(posVisitor));
            }
            ClassExpression nnfQ = q.accept(posVisitor);
            return TermFactory.or((ClassExpression)TermFactory.max(p, n - 1, nnfQ), (ClassExpression)TermFactory.min(p, n + 1, nnfQ));
        }

        @Override
        public ClassExpression visit(DataMax max) {
            DataProperty p = max.getProperty();
            int n = max.getCardinality();
            Datatype q = max.getQualification();
            return TermFactory.min(p, n + 1, q.accept(posDataVisitor));
        }

        @Override
        public ClassExpression visit(ObjectMax max) {
            ObjectProperty p = max.getProperty();
            int n = max.getCardinality();
            ClassExpression q = max.getQualification();
            return TermFactory.min(p, n + 1, q.accept(posVisitor));
        }

        @Override
        public ClassExpression visit(DataMin min) {
            DataProperty p = min.getProperty();
            int n = min.getCardinality();
            Datatype q = min.getQualification();
            if (n == 0) {
                return Classes.NOTHING;
            }
            return TermFactory.max(p, n - 1, q.accept(posDataVisitor));
        }

        @Override
        public ClassExpression visit(ObjectMin min) {
            ObjectProperty p = min.getProperty();
            int n = min.getCardinality();
            ClassExpression q = min.getQualification();
            if (n == 0) {
                return Classes.NOTHING;
            }
            return TermFactory.max(p, n - 1, q.accept(posVisitor));
        }

        @Override
        public ClassExpression visit(ObjectNot not) {
            return not.getArg().accept(posVisitor);
        }

        @Override
        public ClassExpression visit(ObjectOr or) {
            Set<ClassExpression> args = this.nnfAll(or);
            return args == null ? or : TermFactory.and(args);
        }

        @Override
        public ClassExpression visit(DataSome some) {
            DataProperty p = some.getProperty();
            Datatype q = some.getQualification();
            return TermFactory.all(p, q.accept(negDataVisitor));
        }

        @Override
        public ClassExpression visit(ObjectSome some) {
            ObjectProperty p = some.getProperty();
            ClassExpression q = some.getQualification();
            return TermFactory.all(p, q.accept(negVisitor));
        }
    }

    private static class NegatedDataVisitor
    extends BaseTermVisitor<Datatype> {
        private NegatedDataVisitor() {
        }

        protected Set<Datatype> nnfAll(TermCollection<Datatype> datatypes) {
            HashSet results = Sets.newHashSetWithExpectedSize((int)datatypes.size());
            for (Datatype d : datatypes) {
                Datatype nnfD = d.accept(this);
                results.add(nnfD);
            }
            return results;
        }

        @Override
        public Datatype defaultVisit(Term c) {
            assert (c instanceof Datatype);
            return TermFactory.dataNot((Datatype)c);
        }

        @Override
        public Datatype visit(DataAnd and) {
            Set<Datatype> args = this.nnfAll(and);
            return args == null ? and : TermFactory.dataOr(args);
        }

        @Override
        public Datatype visit(DataNot not) {
            return not.getArg().accept(posDataVisitor);
        }

        @Override
        public Datatype visit(DataOr or) {
            Set<Datatype> args = this.nnfAll(or);
            return args == null ? or : TermFactory.dataAnd(args);
        }
    }
}

