/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.term.builtins;

import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.function.Expression;
import com.clarkparsia.pellet.api.term.function.Function;
import com.clarkparsia.pellet.api.term.function.FunctionEval;
import com.clarkparsia.pellet.api.term.visitor.TermVisitor;
import com.clarkparsia.pellet.api.term.visitor.TermVisitorVoid;
import com.google.common.collect.Maps;
import java.util.Map;

public enum Functions implements Function
{
    AND(2, Integer.MAX_VALUE, NS.SWRL, "and"),
    OR(2, Integer.MAX_VALUE, NS.SWRL, "or"),
    NOT(1, NS.SWRL, "booleanNot"),
    LESS_THAN(2, NS.SWRL, "lessThan"),
    GREATER_THAN(2, NS.SWRL, "greaterThan"),
    LESS_THAN_OR_EQUAL(2, NS.SWRL, "lessThanOrEqual"),
    GREATER_THAN_OR_EQUAL(2, NS.SWRL, "greaterThanOrEqual"),
    EQUAL(2, NS.SWRL, "equal"),
    NOT_EQUAL(2, NS.SWRL, "notEqual"),
    DATE(3, 4, NS.SWRL, "date"),
    DATE_TIME(6, 7, NS.SWRL, "dateTime"),
    DAY_TIME_DURATION(4, NS.SWRL, "dayTimeDuration"),
    TIME(3, 4, NS.SWRL, "time"),
    YEAR_MONTH_DURATION(2, NS.SWRL, "yearMonthDuration"),
    RESOLVE_URI(2, NS.SWRL, "resolveURI"),
    ANY_URI(6, NS.SWRL, "anyURI"),
    ABS(1, NS.SWRL, "abs"),
    ADD(2, Integer.MAX_VALUE, NS.SWRL, "add"),
    CEILING(1, NS.SWRL, "ceiling"),
    COS(1, NS.SWRL, "cos"),
    DIVIDE(2, NS.SWRL, "divide"),
    FLOOR(1, NS.SWRL, "floor"),
    INTEGER_DIVIDE(2, NS.SWRL, "integerDivide"),
    MOD(2, NS.SWRL, "mod"),
    MULTIPLY(2, Integer.MAX_VALUE, NS.SWRL, "multiply"),
    POW(2, NS.SWRL, "pow"),
    ROUND(1, NS.SWRL, "round"),
    ROUND_HALF_TO_EVEN(1, 2, NS.SWRL, "roundHalfToEven"),
    SIN(1, NS.SWRL, "sin"),
    SUBTRACT(2, NS.SWRL, "subtract"),
    TAN(1, NS.SWRL, "tan"),
    UNARY_MINUS(1, NS.SWRL, "unaryMinus"),
    UNARY_PLUS(1, NS.SWRL, "unaryPlus"),
    STRING_EQUAL_IGNORE_CASE(2, NS.SWRL, "stringEqualIgnoreCase"),
    STRING_CONCAT(0, Integer.MAX_VALUE, NS.SWRL, "stringConcat"),
    SUBSTRING(2, 3, NS.SWRL, "substring"),
    STRING_LENGTH(1, NS.SWRL, "stringLength"),
    NORMALIZE_SPACE(1, NS.SWRL, "normalizeSpace"),
    UPPER_CASE(1, NS.SWRL, "upperCase"),
    LOWER_CASE(1, NS.SWRL, "lowerCase"),
    TRANSLATE(3, NS.SWRL, "translate"),
    CONTAINS(2, NS.SWRL, "contains"),
    CONTAINS_IGNORE_CASE(2, NS.SWRL, "containsIgnoreCase"),
    STARTS_WITH(2, NS.SWRL, "startsWith"),
    ENDS_WITH(2, NS.SWRL, "endsWith"),
    SUBSTRING_BEFORE(2, NS.SWRL, "substringBefore"),
    SUBSTRING_AFTER(2, NS.SWRL, "substringAfter"),
    MATCHES(2, 3, NS.SWRL, "matches"),
    REPLACE(3, 4, NS.SWRL, "replace"),
    TOKENIZE(2, NS.SWRL, "tokenize"),
    NEW_INDIVIDUAL(0, NS.SPARQL, "UUID"),
    BOUND(1, NS.SPARQL, "bound"),
    BNODE(0, 1, NS.SPARQL, "bnode"),
    COALESCE(1, Integer.MAX_VALUE, NS.SPARQL, "coalesce"),
    DATATYPE(1, NS.SPARQL, "datatype"),
    IF(3, NS.SPARQL, "IF"),
    IN(1, Integer.MAX_VALUE, NS.SPARQL, "IN"),
    IRI(1, NS.SPARQL, "IRI"),
    IS_URI(1, NS.SPARQL, "isURI"),
    IS_BNODE(1, NS.SPARQL, "isBNode"),
    IS_LITERAL(1, NS.SPARQL, "isLiteral"),
    IS_RESOURCE(1, NS.SPARQL, "isResource"),
    IS_NUMERIC(1, NS.SPARQL, "isNumeric"),
    LANG(1, NS.SPARQL, "lang"),
    LANG_MATCHES(2, NS.SPARQL, "langMatches"),
    SAME_TERM(2, NS.SPARQL, "sameTerm"),
    STR(1, NS.SPARQL, "str"),
    CONST(1, NS.SPARQL, "const");

    private static final Map<String, Function> FUNCTIONS;
    private final String name;
    private final int minArity;
    private final int maxArity;

    public static Function get(String uri) {
        return FUNCTIONS.get(uri);
    }

    private Functions(int arity, NS ns, String name) {
        this(arity, arity, ns, name);
    }

    private Functions(int minArity, int maxArity, NS ns, String name) {
        this.name = String.valueOf((Object)ns) + name;
        this.minArity = minArity;
        this.maxArity = maxArity;
    }

    @Override
    public int getArity() {
        return this.minArity;
    }

    @Override
    public int getMaxArity() {
        return this.maxArity;
    }

    @Override
    public int getMinArity() {
        return this.minArity;
    }

    @Override
    public boolean isFixedArity() {
        return this.minArity == this.maxArity;
    }

    @Override
    public void accept(TermVisitorVoid visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(TermVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public FunctionEval eval(Expression ... entities) {
        return TermFactory.functionEval((Function)this, entities);
    }

    @Override
    public FunctionEval eval(Iterable<? extends Expression> entities) {
        return TermFactory.functionEval((Function)this, entities);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isNamed() {
        return true;
    }

    public String toString() {
        return this.name;
    }

    static {
        FUNCTIONS = Maps.newHashMap();
        for (Functions function : Functions.values()) {
            FUNCTIONS.put(function.getName(), function);
        }
    }

    public static enum NS {
        SWRL("http://www.w3.org/2003/11/swrlb#"),
        SPARQL("http://www.w3.org/ns/sparql#");

        private final String ns;

        private NS(String ns) {
            this.ns = ns;
        }

        public String toString() {
            return this.ns;
        }
    }
}

