/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.term.builtins;

import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.api.term.builtins.Facets;
import com.clarkparsia.pellet.api.term.builtins.Functions;
import com.clarkparsia.pellet.api.term.entity.DataAnd;
import com.clarkparsia.pellet.api.term.entity.DataNot;
import com.clarkparsia.pellet.api.term.entity.DataOneOf;
import com.clarkparsia.pellet.api.term.entity.DataOr;
import com.clarkparsia.pellet.api.term.entity.Facet;
import com.clarkparsia.pellet.api.term.entity.FacetRestriction;
import com.clarkparsia.pellet.api.term.entity.Literal;
import com.clarkparsia.pellet.api.term.entity.LiteralValue;
import com.clarkparsia.pellet.api.term.entity.NamedDatatype;
import com.clarkparsia.pellet.api.term.entity.RestrictedDatatype;
import com.clarkparsia.pellet.api.term.function.FilterAtom;
import com.clarkparsia.pellet.api.term.function.FunctionEval;
import com.clarkparsia.pellet.api.term.query.DatatypeAtom;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.DatatypeReasoner;
import com.clarkparsia.pellet.datatypes.DatatypeReasonerImpl;
import com.clarkparsia.pellet.datatypes.types.real.XSDUnsignedInt;
import com.clarkparsia.pellet.datatypes.types.real.XSDUnsignedLong;
import com.clarkparsia.pellet.datatypes.types.real.XSDUnsignedShort;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FunctionAtomRewriter {
    private static final Map<Facet, List<com.clarkparsia.pellet.api.term.function.Function>> FACET_FUNCTIONS = ImmutableMap.builder().put((Object)Facets.MIN_INCLUSIVE, (Object)ImmutableList.of((Object)Functions.GREATER_THAN_OR_EQUAL)).put((Object)Facets.MIN_EXCLUSIVE, (Object)ImmutableList.of((Object)Functions.GREATER_THAN)).put((Object)Facets.MAX_INCLUSIVE, (Object)ImmutableList.of((Object)Functions.LESS_THAN_OR_EQUAL)).put((Object)Facets.MAX_EXCLUSIVE, (Object)ImmutableList.of((Object)Functions.LESS_THAN)).put((Object)Facets.PATTERN, (Object)ImmutableList.of((Object)Functions.MATCHES)).put((Object)Facets.LENGTH, (Object)ImmutableList.of((Object)Functions.STRING_LENGTH, (Object)Functions.EQUAL)).put((Object)Facets.MIN_LENGTH, (Object)ImmutableList.of((Object)Functions.STRING_LENGTH, (Object)Functions.GREATER_THAN_OR_EQUAL)).put((Object)Facets.MAX_LENGTH, (Object)ImmutableList.of((Object)Functions.STRING_LENGTH, (Object)Functions.LESS_THAN_OR_EQUAL)).put((Object)Facets.LANG_RANGE, (Object)ImmutableList.of((Object)Functions.LANG, (Object)Functions.LANG_MATCHES)).build();
    private static final Map<NamedDatatype, com.clarkparsia.pellet.api.term.entity.Datatype> BULTIN_DATATYPE_DEFINITONS = ImmutableMap.builder().put((Object)Datatypes.BYTE, (Object)FunctionAtomRewriter.createRestrictedDatatype(Datatypes.INTEGER, (byte)-128, (byte)127)).put((Object)Datatypes.SHORT, (Object)FunctionAtomRewriter.createRestrictedDatatype(Datatypes.INTEGER, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE)).put((Object)Datatypes.INT, (Object)FunctionAtomRewriter.createRestrictedDatatype(Datatypes.INTEGER, Integer.MIN_VALUE, Integer.MAX_VALUE)).put((Object)Datatypes.LONG, (Object)FunctionAtomRewriter.createRestrictedDatatype(Datatypes.INTEGER, Long.MIN_VALUE, Long.MAX_VALUE)).put((Object)Datatypes.POSITIVE_INTEGER, (Object)FunctionAtomRewriter.createRestrictedDatatype(Datatypes.INTEGER, 1, null)).put((Object)Datatypes.NEGATIVE_INTEGER, (Object)FunctionAtomRewriter.createRestrictedDatatype(Datatypes.INTEGER, null, -1)).put((Object)Datatypes.NON_POSITIVE_INTEGER, (Object)FunctionAtomRewriter.createRestrictedDatatype(Datatypes.INTEGER, null, 0)).put((Object)Datatypes.NON_NEGATIVE_INTEGER, (Object)FunctionAtomRewriter.createRestrictedDatatype(Datatypes.INTEGER, 0, null)).put((Object)Datatypes.UNSIGNED_BYTE, (Object)FunctionAtomRewriter.createRestrictedDatatype(Datatypes.INTEGER, 0, XSDUnsignedLong.MAX_VALUE)).put((Object)Datatypes.UNSIGNED_SHORT, (Object)FunctionAtomRewriter.createRestrictedDatatype(Datatypes.INTEGER, 0, XSDUnsignedShort.MAX_VALUE)).put((Object)Datatypes.UNSIGNED_INT, (Object)FunctionAtomRewriter.createRestrictedDatatype(Datatypes.INTEGER, 0, XSDUnsignedInt.MAX_VALUE)).put((Object)Datatypes.UNSIGNED_LONG, (Object)FunctionAtomRewriter.createRestrictedDatatype(Datatypes.INTEGER, 0, XSDUnsignedLong.MAX_VALUE)).build();
    private DatatypeReasoner reasoner;

    private static com.clarkparsia.pellet.api.term.entity.Datatype createRestrictedDatatype(NamedDatatype base, Object minValue, Object maxValue) {
        Datatype<?> datatype = DatatypeReasonerImpl.coreDatatypes.get(base);
        RestrictedDatatype result = null;
        if (minValue != null) {
            Literal minLiteral = datatype.getLiteral(minValue);
            result = base.minInclusive(minLiteral);
        }
        if (maxValue != null) {
            Literal maxLiteral = datatype.getLiteral(maxValue);
            result = result == null ? base.maxInclusive(maxLiteral) : result.maxInclusive(maxLiteral);
        }
        return result;
    }

    public FunctionAtomRewriter() {
    }

    public FunctionAtomRewriter(DatatypeReasoner reasoner) {
        this.reasoner = reasoner;
    }

    private com.clarkparsia.pellet.api.term.entity.Datatype getDefinition(NamedDatatype datatype) {
        com.clarkparsia.pellet.api.term.entity.Datatype definition = BULTIN_DATATYPE_DEFINITONS.get(datatype);
        if (definition == null && this.reasoner != null) {
            definition = this.reasoner.getDefinition(datatype);
        }
        return definition;
    }

    public FilterAtom rewrite(DatatypeAtom atom) {
        return this.rewrite(atom, true);
    }

    public FilterAtom rewrite(DatatypeAtom atom, boolean positive) {
        FunctionEval fe = this.rewrite(atom.getDatatype(), atom.getLiteral());
        FunctionEval aFc = positive ? fe : TermFactory.functionEval((com.clarkparsia.pellet.api.term.function.Function)Functions.NOT, fe);
        return fe == null ? null : TermFactory.filter(aFc);
    }

    private FunctionEval rewrite(com.clarkparsia.pellet.api.term.entity.Datatype datatype, LiteralValue arg) {
        if (datatype.isNamed()) {
            NamedDatatype nd = (NamedDatatype)datatype;
            com.clarkparsia.pellet.api.term.entity.Datatype definition = this.getDefinition(nd);
            if (nd.equals(Datatypes.LITERAL)) {
                return TermFactory.functionEval((com.clarkparsia.pellet.api.term.function.Function)Functions.IS_LITERAL, arg);
            }
            if (definition == null) {
                return TermFactory.functionEval((com.clarkparsia.pellet.api.term.function.Function)Functions.EQUAL, TermFactory.functionEval((com.clarkparsia.pellet.api.term.function.Function)Functions.DATATYPE, arg), nd);
            }
            return this.rewrite(definition, arg);
        }
        if (datatype instanceof DataAnd) {
            return Functions.AND.eval(this.rewrite(((DataAnd)datatype).getArgs(), arg));
        }
        if (datatype instanceof DataOr) {
            return Functions.AND.eval(this.rewrite(((DataOr)datatype).getArgs(), arg));
        }
        if (datatype instanceof DataNot) {
            return Functions.NOT.eval(this.rewrite(((DataNot)datatype).getArg(), arg));
        }
        if (datatype instanceof RestrictedDatatype) {
            ArrayList atoms = Lists.newArrayList();
            RestrictedDatatype restricted = (RestrictedDatatype)datatype;
            atoms.add(this.rewrite(restricted.getDatatype(), arg));
            for (FacetRestriction restriction : restricted.getRestrictions()) {
                List<com.clarkparsia.pellet.api.term.function.Function> functions = FACET_FUNCTIONS.get(restriction.getFacet());
                if (functions == null || functions.size() < 1 || functions.size() > 2) {
                    throw new UnsupportedOperationException("Cannot convert: " + String.valueOf(restriction));
                }
                boolean singleFunc = functions.size() == 1;
                LiteralValue expr = singleFunc ? arg : TermFactory.functionEval(functions.get(0), arg);
                com.clarkparsia.pellet.api.term.function.Function f = functions.get(singleFunc ? 0 : 1);
                atoms.add(TermFactory.functionEval(f, expr, restriction.getValue()));
            }
            return Functions.AND.eval(atoms);
        }
        if (datatype instanceof DataOneOf) {
            ArrayList atoms = Lists.newArrayList();
            DataOneOf oneOf = (DataOneOf)datatype;
            for (LiteralValue lit : oneOf) {
                atoms.add(TermFactory.functionEval((com.clarkparsia.pellet.api.term.function.Function)Functions.EQUAL, arg, lit));
            }
            return Functions.OR.eval(atoms);
        }
        throw new UnsupportedOperationException("Cannot convert: " + String.valueOf(datatype));
    }

    private Iterable<FunctionEval> rewrite(Iterable<com.clarkparsia.pellet.api.term.entity.Datatype> datatypes, final LiteralValue arg) {
        return Iterables.filter((Iterable)Iterables.transform(datatypes, (Function)new Function<com.clarkparsia.pellet.api.term.entity.Datatype, FunctionEval>(){

            public FunctionEval apply(com.clarkparsia.pellet.api.term.entity.Datatype datatype) {
                return FunctionAtomRewriter.this.rewrite(datatype, arg);
            }
        }), (Predicate)Predicates.notNull());
    }
}

