/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.term.builtins;

import com.clarkparsia.pellet.api.term.Term;
import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.TermSet;
import com.clarkparsia.pellet.api.term.builtins.Types;
import com.clarkparsia.pellet.api.term.entity.ClassExpression;
import com.clarkparsia.pellet.api.term.entity.DataAnd;
import com.clarkparsia.pellet.api.term.entity.DataOneOf;
import com.clarkparsia.pellet.api.term.entity.DataOr;
import com.clarkparsia.pellet.api.term.entity.Datatype;
import com.clarkparsia.pellet.api.term.entity.Individual;
import com.clarkparsia.pellet.api.term.entity.LiteralValue;
import com.clarkparsia.pellet.api.term.entity.ObjectAnd;
import com.clarkparsia.pellet.api.term.entity.ObjectOneOf;
import com.clarkparsia.pellet.api.term.entity.ObjectOr;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

class DNF {
    DNF() {
    }

    public static ClassExpression dnf(ClassExpression term) {
        return DNF.dnfFromNnf(Types.nnf(term));
    }

    public static Datatype dnf(Datatype term) {
        return DNF.dnfFromNnf(Types.nnf(term));
    }

    private static Datatype dnfFromNnf(Datatype term) {
        Datatype dnf;
        if (term instanceof DataAnd) {
            Iterator i = ((DataAnd)term).iterator();
            ArrayList conjuncts = Lists.newArrayList();
            while (i.hasNext()) {
                Datatype a = (Datatype)i.next();
                if (a instanceof DataAnd) {
                    i = Iterators.concat(i, ((DataAnd)a).iterator());
                    continue;
                }
                Datatype dnfA = DNF.dnfFromNnf(a);
                conjuncts.add(dnfA);
            }
            ArrayList disjuncts = Lists.newArrayList();
            for (Datatype a : conjuncts) {
                if (disjuncts.isEmpty()) {
                    DNF.addToList(a, a instanceof DataOr, disjuncts);
                    continue;
                }
                ArrayList thisArgs = Lists.newArrayList();
                ArrayList newDisjuncts = Lists.newArrayList();
                DNF.addToList(a, a instanceof DataOr, thisArgs);
                for (Datatype a1 : thisArgs) {
                    for (Datatype b : disjuncts) {
                        HashSet list = Sets.newHashSet();
                        DNF.addToList(a1, a1 instanceof DataAnd, list);
                        DNF.addToList(b, b instanceof DataAnd, list);
                        newDisjuncts.add(TermFactory.dataAnd(list));
                    }
                }
                disjuncts = newDisjuncts;
            }
            dnf = TermFactory.dataOr(disjuncts);
        } else if (term instanceof DataOr) {
            Iterator i = ((DataOr)term).iterator();
            ArrayList args = Lists.newArrayList();
            while (i.hasNext()) {
                Datatype a = (Datatype)i.next();
                if (a instanceof DataOr) {
                    i = Iterators.concat(i, ((DataOr)a).iterator());
                    continue;
                }
                args.add(DNF.dnfFromNnf(a));
            }
            dnf = TermFactory.dataOr(args);
        } else if (term instanceof DataOneOf) {
            Iterator i = ((DataOneOf)term).iterator();
            ArrayList args = Lists.newArrayList();
            while (i.hasNext()) {
                LiteralValue a = (LiteralValue)i.next();
                args.add(TermFactory.dataOneOf(a));
            }
            dnf = TermFactory.dataOr(args);
        } else {
            dnf = term;
        }
        return dnf;
    }

    private static ClassExpression dnfFromNnf(ClassExpression term) {
        ClassExpression dnf;
        if (term instanceof ObjectAnd) {
            Iterator i = ((ObjectAnd)term).iterator();
            ArrayList conjuncts = Lists.newArrayList();
            while (i.hasNext()) {
                ClassExpression a = (ClassExpression)i.next();
                if (a instanceof ObjectAnd) {
                    i = Iterators.concat(i, ((ObjectAnd)a).iterator());
                    continue;
                }
                ClassExpression dnfA = DNF.dnfFromNnf(a);
                conjuncts.add(dnfA);
            }
            ArrayList disjuncts = Lists.newArrayList();
            for (ClassExpression a : conjuncts) {
                if (disjuncts.isEmpty()) {
                    DNF.addToList(a, a instanceof ObjectOr, disjuncts);
                    continue;
                }
                ArrayList thisArgs = Lists.newArrayList();
                ArrayList newDisjuncts = Lists.newArrayList();
                DNF.addToList(a, a instanceof ObjectOr, thisArgs);
                for (ClassExpression a1 : thisArgs) {
                    for (ClassExpression b : disjuncts) {
                        HashSet list = Sets.newHashSet();
                        DNF.addToList(a1, a1 instanceof ObjectAnd, list);
                        DNF.addToList(b, b instanceof ObjectAnd, list);
                        newDisjuncts.add(TermFactory.and(list));
                    }
                }
                disjuncts = newDisjuncts;
            }
            dnf = TermFactory.or(disjuncts);
        } else if (term instanceof ObjectOr) {
            Iterator i = ((ObjectOr)term).iterator();
            ArrayList args = Lists.newArrayList();
            while (i.hasNext()) {
                ClassExpression a = (ClassExpression)i.next();
                if (a instanceof ObjectOr) {
                    i = Iterators.concat(i, ((ObjectOr)a).iterator());
                    continue;
                }
                args.add(DNF.dnfFromNnf(a));
            }
            dnf = TermFactory.or(args);
        } else if (term instanceof ObjectOneOf) {
            Iterator i = ((ObjectOneOf)term).iterator();
            ArrayList args = Lists.newArrayList();
            while (i.hasNext()) {
                Individual a = (Individual)i.next();
                args.add(TermFactory.oneOf(a));
            }
            dnf = TermFactory.or(args);
        } else {
            dnf = term;
        }
        return dnf;
    }

    private static <T extends Term> void addToList(T term, boolean flatten, Collection<T> result) {
        if (flatten) {
            for (Term c : (TermSet)((Object)term)) {
                result.add(c);
            }
        } else {
            result.add(term);
        }
    }
}

