/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.api.query.impl;

import com.clarkparsia.pellet.api.query.Binding;
import com.clarkparsia.pellet.api.term.Term;
import com.clarkparsia.pellet.api.term.entity.Variable;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.util.Iterator;

public class NestedBinding
implements Binding {
    private final NestedBinding parent;
    private final Variable var;
    private final Term value;

    public NestedBinding(NestedBinding parent, Variable var, Term value) {
        this.parent = parent;
        this.var = var;
        this.value = value;
    }

    @Override
    public Binding copy() {
        return this;
    }

    @Override
    public boolean contains(Variable var) {
        return Objects.equal((Object)this.var, (Object)var) || this.parent != null && this.parent.contains(var);
    }

    @Override
    public boolean isEmpty() {
        return this.var == null && this.parent == null;
    }

    @Override
    public int size() {
        return this.parent == null ? (this.var == null ? 0 : 1) : 1 + this.parent.size();
    }

    @Override
    public Iterator<Variable> vars() {
        return this.parent == null ? (this.var == null ? ImmutableSet.of().iterator() : Iterators.singletonIterator((Object)this.var)) : Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.var), this.parent.vars());
    }

    @Override
    public Term apply(Variable var) {
        return Objects.equal((Object)this.var, (Object)var) ? this.value : (this.parent == null ? null : this.parent.apply(var));
    }

    public String toString() {
        if (this.var == null) {
            return "[]";
        }
        NestedBinding binding = this;
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(String.valueOf(binding.var) + "->" + String.valueOf(binding.value));
        binding = binding.parent;
        while (binding.var != null) {
            sb.append(", ");
            sb.append(String.valueOf(binding.var) + "->" + String.valueOf(binding.value));
            binding = binding.parent;
        }
        sb.append("]");
        return sb.toString();
    }
}

